/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.util.types.constants.PolicyTypeConstant;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrPropertyPanel;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrDateField;
import com.sanrad.swing.components.SrEnterTimeField;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.components.SrRadioButton;
import com.sanrad.swing.components.SrTimeField;
import com.sanrad.swing.components.SrWidget;
import com.sanrad.swing.text.IntegerDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.EventListener;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class SrPolicyParamsPanel
extends SrPanel {
    private SrPropertyPanel m_props;
    private SrComboBox<PolicyTypeConstant> m_policyTypeCombo;
    private SrPolicyStartAtPanel m_startAtPanel;
    private SrEnterTimeField m_runEveryField;
    public static final String IMMEDIATE_BTT_CMD = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_PAIR_NEW_CG_PARAMS_START_AT_IMMEDIATE_RADIO_DESC);
    public static final String DATA_AND_TIME_BTT_CMD = "Date&Time";

    public SrPolicyParamsPanel(String title) {
        this();
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), title));
    }

    public SrPolicyParamsPanel() {
        super(new GridBagLayout());
        this.initComponents();
    }

    private void initComponents() {
        PolicyTypeConstant[] listOfMethods = new PolicyTypeConstant[]{PolicyTypeConstant.REPLICATE_PERIODIC};
        this.m_policyTypeCombo = new SrComboBox<PolicyTypeConstant>((T[])listOfMethods);
        this.m_runEveryField = new SrEnterTimeField();
        this.m_runEveryField.setDocument(new IntegerDocument(){

            @Override
            public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
                String currentValue = this.getText(0, this.getLength());
                String leftValue = currentValue.substring(0, offset);
                String rightValue = currentValue.substring(offset, currentValue.length());
                String finalValue = leftValue + str + rightValue;
                try {
                    int value = Integer.parseInt(finalValue);
                    if (value <= 0) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                super.insertString(offset, str, attr);
            }
        });
        this.m_props = new SrPropertyPanel(this.getClass().toString(), false, true, false);
        this.m_props.addProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_PAIR_NEW_CG_PARAMS_METHOD_KEY_DESC), this.m_policyTypeCombo);
        this.m_props.addProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_PAIR_NEW_CG_PARAMS_RUN_EVERY_KEY_DESC), (SrComponent)this.m_runEveryField);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.fill = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weighty = 0.2;
        constraints.insets = new Insets(10, 20, 0, 20);
        this.add((Component)this.m_props, constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 10;
        constraints.weighty = 0.9;
        SrPropertyPanel startAtPanel = new SrPropertyPanel(this.getClass().toString(), false, true, false);
        this.m_startAtPanel = new SrPolicyStartAtPanel();
        SrWidget startLabel = new SrWidget("Start at:", new SrClientLabel("Start at:"));
        SrWidget startFields = new SrWidget("Start at:", this.m_startAtPanel);
        GridBagConstraints labelConstrains = new GridBagConstraints();
        labelConstrains.anchor = 18;
        labelConstrains.fill = 2;
        labelConstrains.insets = new Insets(10, 0, 0, 40);
        startLabel.setConstraints(labelConstrains);
        startAtPanel.addProperty(startLabel, startFields);
        this.add((Component)startAtPanel, constraints);
    }

    public PolicyTypeConstant getPolicyType() {
        return (PolicyTypeConstant)this.m_policyTypeCombo.getSelectedItem();
    }

    public void setPolicyType(PolicyTypeConstant type) {
        this.m_policyTypeCombo.setSelectedItem(type);
    }

    public Long getStartatValue() {
        return (Long)this.m_startAtPanel.getValue();
    }

    public void setStartatValue(Long startat) {
        this.m_startAtPanel.setValue(startat);
    }

    public Long getRunEveryValue() {
        return new Long(this.m_runEveryField.getTimeMinutes());
    }

    public void setRunEveryValue(Long runEvery) {
        this.m_runEveryField.setValue(runEvery);
    }

    public DateAndTimePanel getDataTimeStartatField() {
        return this.m_startAtPanel.getDataAndTimePanel();
    }

    public SrEnterTimeField getRunEveryField() {
        return this.m_runEveryField;
    }

    public SrPropertyPanel getPropertyPanel() {
        return this.m_props;
    }

    public ButtonGroup getStartAtBttGroup() {
        return this.m_startAtPanel.m_bttGroup;
    }

    public static void main(String[] args) {
        SrPolicyParamsPanel p = new SrPolicyParamsPanel("Replication Policy");
        JDialog dlg = new JDialog((Frame)null, "test", true);
        dlg.getContentPane().add(p);
        dlg.setSize(400, 400);
        dlg.show();
        System.exit(0);
    }

    public static class DateAndTimePanel
    extends SrPanel {
        private SrDateField m_date;
        private SrTimeField m_time;

        public DateAndTimePanel() {
            super(new BorderLayout(0, 5));
            SrPanel subDatePanel = new SrPanel(new FlowLayout(0, 5, 0));
            SrClientLabel dateLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_PAIR_NEW_CG_PARAMS_START_AT_DATE_RADIO_DESC));
            subDatePanel.add(dateLbl);
            this.m_date = new SrDateField();
            subDatePanel.add(this.m_date);
            this.add((Component)subDatePanel, "North");
            SrPanel subTimePanel = new SrPanel(new FlowLayout(0, 5, 0));
            SrClientLabel timeLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_PAIR_WIZ_PAIR_NEW_CG_PARAMS_START_AT_TIME_RADIO_DESC));
            subTimePanel.add(timeLbl);
            this.m_time = new SrTimeField();
            subTimePanel.add(this.m_time);
            this.add((Component)subTimePanel, "South");
        }

        public SrDateField getDateField() {
            return this.m_date;
        }

        public SrTimeField getTimeField() {
            return this.m_time;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.m_time.setEnableComponent(enabled);
            this.m_date.setEnableComponent(enabled);
        }

        public Long getDateAndTime() {
            int[] ddmmyy = this.m_date.getCurrentDateValue();
            int[] hhmmss = this.m_time.getCurrentTimeValue();
            GregorianCalendar myCal = new GregorianCalendar(ddmmyy[2], ddmmyy[1], ddmmyy[0], hhmmss[0], hhmmss[1], hhmmss[2]);
            Date myDate = myCal.getTime();
            return new Long(myDate.getTime());
        }

        public void setDateAndTime(Long value) {
            long longValue = value;
            this.m_date.setDate(longValue);
            this.m_time.setTime(longValue);
        }
    }

    public static class SrPolicyStartAtPanel
    extends SrPanel
    implements ActionListener,
    ItemListener,
    SrComponent {
        private DateAndTimePanel m_dataAndTimePanel;
        private SrLabelField m_immediate;
        private ButtonGroup m_bttGroup;
        private SrRadioButton m_immediatelyButton;
        private SrRadioButton m_startatButton;

        public SrPolicyStartAtPanel() {
            super(new GridBagLayout());
            this.initComponents();
        }

        private void initComponents() {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 0;
            constraints.anchor = 18;
            constraints.insets = new Insets(5, 0, 0, 0);
            this.m_dataAndTimePanel = new DateAndTimePanel();
            this.m_immediatelyButton = new SrRadioButton();
            this.m_immediatelyButton.setActionCommand(IMMEDIATE_BTT_CMD);
            this.m_immediatelyButton.addActionListener(this);
            this.m_immediatelyButton.addItemListener(this);
            this.m_immediate = new SrLabelField(IMMEDIATE_BTT_CMD);
            this.m_startatButton = new SrRadioButton();
            this.m_startatButton.setActionCommand(SrPolicyParamsPanel.DATA_AND_TIME_BTT_CMD);
            this.m_startatButton.addActionListener(this);
            this.m_startatButton.addItemListener(this);
            this.m_bttGroup = new ButtonGroup();
            this.m_bttGroup.add(this.m_immediatelyButton);
            this.m_bttGroup.add(this.m_startatButton);
            this.m_immediatelyButton.setSelected(true);
            this.m_dataAndTimePanel.setEnabled(false);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 0.05;
            this.add((Component)this.m_immediatelyButton, constraints);
            constraints.gridx = 0;
            constraints.gridy = 1;
            this.add((Component)this.m_startatButton, constraints);
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            this.add((Component)this.m_immediate, constraints);
            constraints.gridx = 1;
            constraints.gridy = 1;
            this.add((Component)this.m_dataAndTimePanel, constraints);
        }

        public DateAndTimePanel getDataAndTimePanel() {
            return this.m_dataAndTimePanel;
        }

        @Override
        public void addComponentFocusListener(FocusListener fl) {
        }

        @Override
        public void addComponentValidListener(EventListener l) {
        }

        @Override
        public int compareTo(SrComponent com) {
            return 0;
        }

        @Override
        public Component getComponent() {
            return this;
        }

        public Object getValue() {
            if (this.m_immediatelyButton.isSelected()) {
                return new Long(0L);
            }
            return this.m_dataAndTimePanel.getDateAndTime();
        }

        @Override
        public boolean isComponentEnabled() {
            return this.m_immediatelyButton.isEnabled() || this.m_startatButton.isEnabled();
        }

        @Override
        public boolean isComponentValid() {
            return true;
        }

        @Override
        public void removeComponentFocusListener(FocusListener fl) {
        }

        @Override
        public void removeComponentValidListener(EventListener l) {
        }

        @Override
        public void setEnableComponent(boolean enable) {
            this.m_immediatelyButton.setEnabled(false);
            this.m_startatButton.setEnabled(false);
            this.m_dataAndTimePanel.m_date.setEnabled(false);
            this.m_dataAndTimePanel.m_time.setEnabled(false);
        }

        public void setValue(Object value) {
            if (value instanceof Long) {
                long longValue = (Long)value;
                if (longValue == 0L) {
                    this.m_immediatelyButton.setSelected(true);
                } else {
                    this.m_startatButton.setSelected(true);
                    this.m_dataAndTimePanel.setDateAndTime((Long)value);
                }
            } else if (value instanceof Date) {
                this.setValue(new Long(((Date)value).getTime()));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setComponentsEnableState(e.getActionCommand());
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.setComponentsEnableState(((SrRadioButton)e.getSource()).getActionCommand());
        }

        private void setComponentsEnableState(String actionCmd) {
            if (actionCmd.equals(SrPolicyParamsPanel.DATA_AND_TIME_BTT_CMD)) {
                this.m_dataAndTimePanel.setEnabled(true);
                this.m_immediate.setEnabled(false);
            } else {
                this.m_dataAndTimePanel.setEnabled(false);
                this.m_immediate.setEnabled(true);
            }
        }
    }
}

