/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.dr.wizards.SrResourceTableModel;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.TransparentVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeCreationHandler;
import com.sanrad.nms.client.data.volume.VolumeOperationHandler;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.dr.ResourceSelectionEvent;
import com.sanrad.nms.client.event.dr.ResourceSelectionListener;
import com.sanrad.nms.client.gui.dr.wizards.DRWizardValidation;
import com.sanrad.nms.client.gui.dr.wizards.SrDRWizardPanel;
import com.sanrad.nms.client.gui.storage.SrVolOperStorageTablePanel;
import com.sanrad.nms.client.gui.volume.VolumeOperationFrame;
import com.sanrad.nms.client.gui.volume.VolumeOperationToolBarPanel;
import com.sanrad.swing.SrTree;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.wizard.ContextKey;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public abstract class SrCreateVolumeWizardPanel
extends SrDRWizardPanel
implements ResourceSelectionListener {
    protected WizardVolumeOperationFrame m_volumeFrm;
    protected VolumeTreeNode m_selectedResource;

    protected SrCreateVolumeWizardPanel(ClusterNode cluster) {
        this.m_volumeFrm = new WizardVolumeOperationFrame(null, new VolumeCreationHandler(cluster), cluster);
        this.setSavedAsPrevious(false);
        this.add((Component)this.m_volumeFrm.getContentPane(), "Center");
    }

    @Override
    public void display() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SrCreateVolumeWizardPanel.this.m_volumeFrm.getTablePanel().getTable().getRowCount() > 0) {
                    SrCreateVolumeWizardPanel.this.m_volumeFrm.getTablePanel().getTable().getSelectionModel().setSelectionInterval(0, 0);
                    SrCreateVolumeWizardPanel.this.m_volumeFrm.getTablePanel().getTable().requestFocus();
                    SrCreateVolumeWizardPanel.this.m_volumeFrm.getTreeObject().clearSelection();
                }
            }
        });
        boolean goNext = this.generalVolumeCheck(this.m_selectedResource);
        this.setNextButtonEnabled(goNext);
    }

    @Override
    public WizardPanel next() {
        return null;
    }

    @Override
    public boolean validateNext(List list) {
        return true;
    }

    @Override
    public void onResourceSelection(ResourceSelectionEvent e) {
        this.m_selectedResource = null;
        Vector nodes = e.getSelectionVector();
        if (!nodes.isEmpty()) {
            this.m_selectedResource = (VolumeTreeNode)nodes.get(0);
        }
        this.setNextButtonEnabled(this.generalVolumeCheck(this.m_selectedResource));
    }

    protected abstract ContextKey getContextKeyForSelectedResource();

    protected VolumeTreeNode getSelectedResource() {
        return this.m_selectedResource;
    }

    private void selectionChanged() {
        Object lastPathComp;
        this.m_selectedResource = null;
        ArrayList<Object> selectedVolumes = new ArrayList<Object>();
        TreePath[] selectedPaths = this.m_volumeFrm.getTreeObject().getSelectionPaths();
        if (selectedPaths != null && selectedPaths.length == 1 && (lastPathComp = selectedPaths[0].getLastPathComponent()) instanceof VolumeTreeNode) {
            selectedVolumes.add(lastPathComp);
        }
        StorageDeviceNode[] storageNodes = this.m_volumeFrm.getTablePanel().getSelectedDeviceNodes();
        int i = storageNodes.length;
        while (i-- > 0) {
            selectedVolumes.add(storageNodes[i]);
        }
        if (!selectedVolumes.isEmpty()) {
            this.m_selectedResource = (VolumeTreeNode)selectedVolumes.get(0);
            this.wizardContext.setAttribute(this.getContextKeyForSelectedResource(), this.m_selectedResource, this);
        }
        if (selectedVolumes.size() > 1) {
            this.setNextButtonEnabled(false);
        } else {
            this.setNextButtonEnabled(this.generalVolumeCheck(this.m_selectedResource));
        }
    }

    protected boolean generalVolumeCheck(VolumeTreeNode vol) {
        return this.commonVolumeCheck(vol) && this.validateVolume(vol);
    }

    private boolean commonVolumeCheck(VolumeTreeNode vol) {
        DirectAccessDeviceNode disk;
        if (vol == null) {
            return false;
        }
        if (!DRWizardValidation.isRedundant(vol)) {
            return false;
        }
        if (vol.isConfigured()) {
            return false;
        }
        if (vol instanceof TransparentVolumeNode || vol instanceof SnapshotVolumeNode || vol instanceof JournalVolumeNode) {
            return false;
        }
        if (vol instanceof StorageDeviceNode && !SrResourceTableModel.isStorageValidForSource((StorageDeviceNode)vol)) {
            return false;
        }
        if (vol instanceof SubDirectAccessDeviceNode && !SrResourceTableModel.isSubDiskValidForSource((SubDirectAccessDeviceNode)vol)) {
            return false;
        }
        if (vol instanceof DirectAccessDeviceNode && ((disk = (DirectAccessDeviceNode)vol).hasSubdisks() || !SrResourceTableModel.isDiskValidForSource(disk))) {
            return false;
        }
        if (vol.isChildOfAnotherVolume()) {
            return false;
        }
        if (vol.isNeedSync()) {
            return false;
        }
        return DRPairManager.getPairContainingVolume(vol) == null;
    }

    protected boolean validateVolume(VolumeTreeNode vol) {
        return true;
    }

    @Override
    public final void removeListeners() {
        DirectAccessDeviceManager.getInstance().removeDirectAccessDeviceListener(this.m_volumeFrm);
        SubDirectAccessDeviceManager.getInstance().removeSubDirectDeviceListener(this.m_volumeFrm);
        this.removeOtherListeners();
    }

    protected abstract void removeOtherListeners();

    @Override
    public void back() {
        this.wizardContext.setAttribute(this.getContextKeyForSelectedResource(), null, this);
    }

    public static class WizardVolumeOperationToolBarPanel
    extends VolumeOperationToolBarPanel {
        public WizardVolumeOperationToolBarPanel(VolumeOperationHandler volOperHandler, VolumeOperationFrame workWith) {
            super(volOperHandler, workWith);
        }

        @Override
        protected void initToolBar() {
            this.addButtonMirror();
            this.addButtonStripe();
            this.addButtonConcatenation();
        }
    }

    private class WizardVolumeOperationFrame
    extends VolumeOperationFrame {
        public WizardVolumeOperationFrame(VolumeTreeNode source, VolumeOperationHandler handler, ClusterNode workingCluster) {
            super(source, handler, workingCluster);
            this.jSplitPane1.setDividerLocation(300);
            final ListSelectionModel tableSelectionModel = this.getTablePanel().getTable().getSelectionModel();
            final TreeSelectionModel treeSelectionModel = this.getTreeObject().getSelectionModel();
            tableSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (WizardVolumeOperationFrame.this.getTablePanel().getTable().getSelectedRow() >= 0) {
                        treeSelectionModel.clearSelection();
                    }
                    if (!e.getValueIsAdjusting()) {
                        SrCreateVolumeWizardPanel.this.selectionChanged();
                    }
                }
            });
            treeSelectionModel.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreePath tp = e.getNewLeadSelectionPath();
                    if (tp != null) {
                        tableSelectionModel.clearSelection();
                    }
                    SrCreateVolumeWizardPanel.this.selectionChanged();
                }
            });
        }

        protected GridBagConstraints getConstraintsForUpperPanel() {
            return new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        }

        @Override
        protected void initToolBarPanel() {
            this.m_volumeOperationToolbarPanel = new WizardVolumeOperationToolBarPanel(this.myOperationHandler, this);
            this.addToolBarPanel(this.m_volumeOperationToolbarPanel);
        }

        public SrTree getTreeObject() {
            return this.volumeTreeViewPanel.getTreeObject();
        }

        public SrVolOperStorageTablePanel getTablePanel() {
            return (SrVolOperStorageTablePanel)this.storageTableViewPanel.getCurrentTablePanel();
        }

        @Override
        public void fail(String msg) {
            SrCreateVolumeWizardPanel.this.getOwner().fail(msg);
        }

        @Override
        protected void initSystemComboBox() {
        }
    }
}

