/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SrStorageTableColumns;
import com.sanrad.nms.client.data.storage.SrStorageTableModel;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.storage.StoragePoolSelector;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.SubDirectAccessDeviceAdapter;
import com.sanrad.nms.client.event.SubDirectAccessDeviceEvent;
import com.sanrad.nms.client.event.volume.VolumeAdapter;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.actions.ActionsPool;
import com.sanrad.nms.client.gui.actions.SrTransientAction;
import com.sanrad.nms.client.gui.dr.wizards.SrDRWizardPanel;
import com.sanrad.nms.client.gui.storage.SrStorageTablePanel;
import com.sanrad.nms.client.gui.storage.StorageTableHeader;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.util.AllocationPolicy;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.swing.TableViewPanel;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.jwf.WizardTransaction;
import com.sanrad.swing.wizard.ContextKey;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.SrFuture;
import com.sanrad.util.virtualization.ResourceAliasUtil;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;

public class SrAllocateVolumeWizardPanel
extends SrDRWizardPanel {
    private SrStorageTablePanel myStorageTable;
    private ClusterNode myCluster;
    private String myRequestedVolumeAlias;
    private BigInteger myRequestedVolumeSize;
    private PhysicalStorageDriveTypeConstant myDriveType;
    private PhysicalStorageRaidLevelConstant myRaidLevel;
    private ContextKey myVolumeContextKey;
    private WizardPanel myNextWizardPanel;
    private VolumeCreationListener myVolumeCreation = new VolumeCreationListener();
    private SubdiskCreationListener mySubdiskListener = new SubdiskCreationListener();

    public SrAllocateVolumeWizardPanel(ClusterNode aCluster, String aVolumeAlias, BigInteger aVolumeSize, PhysicalStorageDriveTypeConstant aResourcesDriveType, PhysicalStorageRaidLevelConstant aResourcesRaidLevel, Integer aResourcesBlockSize, ContextKey aVolumeContextKey, WizardPanel aNextPanel) {
        Util.validateInputNotNull(aCluster, "Cluster node");
        Util.validateInputNotNull(aVolumeSize, "Volume size");
        Util.validateInputNotNull(aVolumeContextKey, "Context key of created volume");
        Util.validateInputNotNull(aNextPanel, "Next wizard panel");
        this.myCluster = aCluster;
        this.myRequestedVolumeAlias = aVolumeAlias;
        this.myRequestedVolumeSize = aVolumeSize;
        this.myDriveType = aResourcesDriveType;
        this.myRaidLevel = aResourcesRaidLevel;
        this.myNextWizardPanel = aNextPanel;
        this.myVolumeContextKey = aVolumeContextKey;
        this.addWizardTransaction(new CreateVolumeTransaction());
        SrStorageTableModel model = new SrStorageTableModel(new SrStorageTableColumns());
        this.myStorageTable = new SrStorageTablePanel(model, null){
            private static final long serialVersionUID = 1L;

            @Override
            protected void setPopupMenu() {
            }

            @Override
            protected void rowSelectionChanged(int[] rowIndices) {
            }
        };
        List<DirectAccessDeviceNode> availableDisks = null;
        availableDisks = aResourcesDriveType == null || aResourcesRaidLevel == null || aResourcesBlockSize == null ? StoragePoolSelector.getClusterDisks(aCluster, true) : StoragePoolSelector.getClusterDisks(aCluster, aResourcesDriveType, aResourcesRaidLevel, aResourcesBlockSize, true);
        for (DirectAccessDeviceNode disk : availableDisks) {
            if (BigInteger.ZERO.compareTo(disk.getAllocationSpace()) >= 0) continue;
            model.addStorageData(disk);
        }
        TableViewPanel tableView = new TableViewPanel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.STORAGE_TABEL_VIEW_PANEL_TITLE), this.myStorageTable);
        this.add((Component)tableView, "Center");
    }

    BigInteger getMaxSizeFromSelection() {
        List storageAliasObjects = this.myStorageTable.getSelctedValues(StorageTableHeader.DISK_ALIAS.getColumnName());
        BigInteger maxSize = BigInteger.ZERO;
        for (AliasObject storageAliasObject : storageAliasObjects) {
            DirectAccessDeviceNode disk = (DirectAccessDeviceNode)storageAliasObject.getValue();
            maxSize = maxSize.add(disk.getAllocationSpace());
        }
        return maxSize;
    }

    private ClientConfigElementData buildClientCed() {
        List storageAliasObjects = this.myStorageTable.getSelctedValues(StorageTableHeader.DISK_ALIAS.getColumnName());
        PhysicalStorageDriveTypeConstant driveType = null;
        PhysicalStorageRaidLevelConstant raidLevel = null;
        ArrayList<CommKeyClassId> selectedDisksIds = new ArrayList<CommKeyClassId>();
        for (AliasObject storageAliasObject : storageAliasObjects) {
            DirectAccessDeviceNode disk = (DirectAccessDeviceNode)storageAliasObject.getValue();
            selectedDisksIds.add((CommKeyClassId)disk.getIdentifier());
            if (driveType == null) {
                driveType = disk.getDriveType();
            }
            if (raidLevel != null) continue;
            raidLevel = disk.getRaidLevel();
        }
        ClientConfigElementData createCed = new ClientConfigElementData(ClassID.GENERAL_VOLUME, (CommKeyClassId)this.myCluster.getIdentifier(), ConfigOperation.CREATE);
        ArrayList<String> allAliases = new ArrayList<String>();
        allAliases.addAll(VolumeManager.getInstance().getAllVolumeAliases(this.myCluster));
        allAliases.addAll(StorageManager.getInstance().getAllAliases(this.myCluster));
        String alias = ResourceAliasUtil.getRecommendedAlias(this.myRequestedVolumeAlias, allAliases);
        createCed.putValue(ClientParameterCode.VOLUME_ALIAS, alias);
        createCed.putValue(ClientParameterCode.VOLUME_SPACE, this.myRequestedVolumeSize);
        AllocationPolicy policy = AllocationPolicy.ALLOWED_STORAGES;
        policy = policy.createResourcesPolicy(selectedDisksIds);
        policy = policy.addPolicy(AllocationPolicy.IGNORE_RAID_ATTACHMENT);
        createCed.putValue(ClientParameterCode.VOLUME_ALLOCATION_POLICY, policy);
        createCed.putValue(ClientParameterCode.PHYSICAL_STORAGE_DRIVE_TYPE, driveType);
        createCed.putValue(ClientParameterCode.PHYSICAL_STORAGE_RAID_LEVEL, raidLevel);
        return createCed;
    }

    @Override
    public Action getNextButtonAction() {
        SrTransientAction<Void, Void> action = ActionsPool.getInstance().provide(this);
        SrTransientAction.AbstractProxy<Void, Void> actionProxy = new SrTransientAction.AbstractProxy<Void, Void>(){

            @Override
            public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> aArg) {
                return Collections.EMPTY_LIST;
            }

            @Override
            public String derivedClientUpdateEnabled() {
                String error = this.checkStoragesSelection();
                if (error != null) {
                    return error;
                }
                if (SrAllocateVolumeWizardPanel.this.myRequestedVolumeSize.compareTo(SrAllocateVolumeWizardPanel.this.getMaxSizeFromSelection()) > 0) {
                    return "There is not enough space in the selected disks";
                }
                return null;
            }

            @Override
            public String getName() {
                return "";
            }

            private String checkStoragesSelection() {
                List storageAliasObjects = SrAllocateVolumeWizardPanel.this.myStorageTable.getSelctedValues(StorageTableHeader.DISK_ALIAS.getColumnName());
                PhysicalStorageDriveTypeConstant driveType = null;
                PhysicalStorageRaidLevelConstant raidLevel = null;
                Integer blockSize = null;
                for (AliasObject storageAliasObject : storageAliasObjects) {
                    DirectAccessDeviceNode disk = (DirectAccessDeviceNode)storageAliasObject.getValue();
                    if (driveType == null) {
                        driveType = disk.getDriveType();
                    } else if (!driveType.equals(disk.getDriveType())) {
                        return "Storages of different drive types are selected";
                    }
                    if (raidLevel == null) {
                        raidLevel = disk.getRaidLevel();
                    } else if (!raidLevel.equals(disk.getRaidLevel())) {
                        return "Storages of different RAID levels are selected";
                    }
                    if (blockSize == null) {
                        blockSize = disk.getBlockSize();
                        continue;
                    }
                    if (blockSize.equals(disk.getBlockSize())) continue;
                    return "Storages of different block sizes are selected";
                }
                return null;
            }
        };
        action.setProxy(actionProxy);
        this.myStorageTable.getTable().getSelectionModel().addListSelectionListener(new View.ViewListSelectionListener(action));
        return action;
    }

    @Override
    public void back() {
    }

    @Override
    public void display() {
        VolumeManager.getInstance().addVolumeListener(this.myVolumeCreation);
        SubDirectAccessDeviceManager.getInstance().addSubDirectDeviceListener(this.mySubdiskListener);
    }

    @Override
    public WizardPanel next() {
        return this.myNextWizardPanel;
    }

    @Override
    public void removeListeners() {
        VolumeManager.getInstance().removeVolumeListener(this.myVolumeCreation);
        SubDirectAccessDeviceManager.getInstance().removeSubDirectDeviceListener(this.mySubdiskListener);
        ActionsPool.getInstance().releaseActions(this);
    }

    @Override
    public boolean validateNext(List list) {
        return true;
    }

    private class SubdiskCreationListener
    extends SubDirectAccessDeviceAdapter {
        private SubdiskCreationListener() {
        }

        @Override
        public void subDirecetAccessDeviceCreated(SubDirectAccessDeviceEvent event) {
            SubDirectAccessDeviceNode subdisk = event.getSubdisk();
            if (subdisk.getAlias().startsWith(SrAllocateVolumeWizardPanel.this.myRequestedVolumeAlias)) {
                SrAllocateVolumeWizardPanel.this.wizardContext.setAttribute(SrAllocateVolumeWizardPanel.this.myVolumeContextKey, subdisk, SrAllocateVolumeWizardPanel.this);
            }
        }
    }

    private class VolumeCreationListener
    extends VolumeAdapter {
        private VolumeCreationListener() {
        }

        @Override
        public void volumeCreate(VolumeEvent e) {
            VolumeTreeNode volume = e.getVolumeNode();
            if (volume.getAlias().startsWith(SrAllocateVolumeWizardPanel.this.myRequestedVolumeAlias)) {
                SrAllocateVolumeWizardPanel.this.wizardContext.setAttribute(SrAllocateVolumeWizardPanel.this.myVolumeContextKey, volume, SrAllocateVolumeWizardPanel.this);
            }
        }
    }

    private class CreateVolumeTransaction
    extends WizardTransaction {
        private CreateVolumeTransaction() {
        }

        @Override
        protected void transaction() {
            SrFuture<Void> future = ClientAOImpl.getInstance().configureElementsTree(SrAllocateVolumeWizardPanel.this.buildClientCed());
            this.waitAndBlockActions(future, SrAllocateVolumeWizardPanel.this.getOwner());
        }
    }
}

