/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SequentialAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.ConcatinationVolumeNode;
import com.sanrad.nms.client.data.volume.CubeVolumeNode;
import com.sanrad.nms.client.data.volume.MirrorVolumeNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.StripeVolumeNode;
import com.sanrad.nms.client.data.volume.TransparentVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.swing.ImageObject;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;

public class ResourceTableCellRenderer
extends DefaultTableCellRenderer {
    private Color m_bgSelectionColor = LookAndFill.TABLE_SELECTION_BACKGROUND;
    private Color m_bgTableBg = LookAndFill.TABLE_BACKGROUND;
    private SrPanel m_innerPanel = new SrPanel(new BorderLayout());
    private SrClientLabel m_alarmLbl;

    public ResourceTableCellRenderer() {
        this.m_innerPanel.setBackground(Color.white);
        this.m_alarmLbl = new SrClientLabel();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            value = "";
        }
        String val = value.toString();
        int ind = -1;
        ind = val.indexOf("[");
        if (ind >= 0) {
            val = val.substring(0, ind);
        }
        super.getTableCellRendererComponent(table, val, isSelected, hasFocus, row, column);
        ImageIcon icon = null;
        if (value instanceof SrTreeNode) {
            icon = ((SrTreeNode)value).getNodeIcon();
        }
        this.setIcon(icon);
        if (hasFocus) {
            this.setBorder(noFocusBorder);
        }
        if (isSelected) {
            this.setBackground(this.m_bgSelectionColor);
            this.m_innerPanel.setBackground(this.m_bgSelectionColor);
        } else {
            this.setBackground(this.m_bgTableBg);
            this.m_innerPanel.setBackground(this.m_bgTableBg);
        }
        if (value instanceof VolumeTreeNode) {
            VolumeTreeNode node = (VolumeTreeNode)value;
            this.m_alarmLbl.setIcon(node.getAlarmIcon());
        }
        this.m_innerPanel.removeAll();
        this.m_innerPanel.add((Component)this.m_alarmLbl, "West");
        this.m_innerPanel.add((Component)this, "Center");
        return this.m_innerPanel;
    }

    private ImageIcon getIcon(Object value) {
        ImageObject icon = null;
        if (value instanceof DefaultMutableTreeNode) {
            if (value instanceof CubeVolumeNode) {
                icon = ClientImageObject.CUBE_VOLUME;
            } else if (value instanceof ConcatinationVolumeNode) {
                icon = ClientImageObject.CONCATINATION_VOLUME;
            } else if (value instanceof MirrorVolumeNode) {
                icon = ClientImageObject.MIRROR_VOLUME;
            } else if (value instanceof StripeVolumeNode) {
                icon = ClientImageObject.STRIPE_VOLUME;
            } else if (value instanceof TransparentVolumeNode) {
                icon = ClientImageObject.TRANSPARENT_VOLUME;
            } else if (value instanceof SubDirectAccessDeviceNode) {
                icon = ClientImageObject.SUB_DISK;
            } else if (value instanceof DirectAccessDeviceNode) {
                icon = ClientImageObject.DISK;
            } else if (value instanceof SequentialAccessDeviceNode) {
                icon = ClientImageObject.TAPE;
            } else if (value instanceof StorageDeviceNode) {
                icon = ClientImageObject.GENERAL_SCSI_DEVICE;
            } else if (value instanceof SnapshotVolumeNode) {
                icon = ClientImageObject.SNAPSHOT;
            }
        }
        if (icon != null) {
            return icon.getImageIcon();
        }
        return null;
    }
}

