/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.wizards;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.swing.jwf.WizardContext;
import java.text.MessageFormat;
import java.util.ArrayList;

public class DRWizardValidation {
    private static String notRedundantErrMsgPatern = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_WIZ_NOT_REDUNDANT_ERR_MSG);

    private DRWizardValidation() {
    }

    public static String getNotRedundantElementsErrorMessage(WizardContext wcx) {
        SrTreeNode[] elements = DRWizardValidation.getAllElements(wcx);
        ArrayList<SrTreeNode> notRedundantElements = new ArrayList<SrTreeNode>();
        int i = elements.length;
        while (i-- > 0) {
            if (!AlarmsManager.getInstance().isAlarmExist(elements[i], AlarmType.OBJ_NOT_REDUNDANT.toString())) continue;
            notRedundantElements.add(elements[i]);
        }
        if (notRedundantElements.isEmpty()) {
            return null;
        }
        Object[] args = new Object[2];
        SrTreeNode firstNorRedundantElement = (SrTreeNode)notRedundantElements.get(0);
        args[0] = firstNorRedundantElement;
        args[1] = SystemRootNode.getInstance().getClusterNodeOfSource(firstNorRedundantElement);
        return MessageFormat.format(notRedundantErrMsgPatern, args);
    }

    private static SrTreeNode[] getAllElements(WizardContext wcx) {
        ArrayList list = new ArrayList();
        for (Object next : wcx.getAllValues()) {
            if (!(next instanceof SrTreeNode)) continue;
            list.add(next);
        }
        return list.toArray(new SrTreeNode[list.size()]);
    }

    public static boolean isRedundant(SrTreeNode aElement) {
        return !AlarmsManager.getInstance().isAlarmExist(aElement, AlarmType.OBJ_NOT_REDUNDANT.toString());
    }
}

