/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.pit;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.dr.DRConsistencyGroupManager;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.dr.pit.DRPiTManager;
import com.sanrad.nms.client.data.dr.pit.DRPiTNode;
import com.sanrad.nms.client.data.dr.pit.PiTContainer;
import com.sanrad.nms.client.data.dr.pit.SrPiTTableHeader;
import com.sanrad.nms.client.data.dr.pit.SrPiTTableModel;
import com.sanrad.nms.client.event.dr.DRAsyncPairEvent;
import com.sanrad.nms.client.event.dr.DRAsyncPairListener;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupEvent;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupListener;
import com.sanrad.nms.client.event.dr.DREvent;
import com.sanrad.nms.client.event.dr.DRListener;
import com.sanrad.nms.client.event.dr.DRPiTEvent;
import com.sanrad.nms.client.event.dr.DRPiTListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.swing.OKCancelDialog;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrTablePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.GregorianCalendar;
import javax.swing.JFrame;
import javax.swing.Timer;

public abstract class SrPiTDialog
extends OKCancelDialog
implements DRAsyncPairListener,
DRConsistencyGroupListener,
DRListener {
    private static final String LAST_UPDATE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PITS_DIALOG_LAST_REFRESH);
    private static final int LOAD_DELAY = 750;
    private static final int PITS_REFRESH_DELAY = 10000;
    protected PiTContainer m_pitParent;
    protected SrTablePanel m_pitTable;
    protected SrPanel m_mainPanel;
    protected GregorianCalendar calendar = new GregorianCalendar();
    private SrClientLabel m_lastUpdateField = new SrClientLabel();
    private Timer m_timer;
    private Timer m_dialogLoadTimer;
    private PiTsUpdateMonitor m_pitsMonitor = new PiTsUpdateMonitor();

    public SrPiTDialog(JFrame owner, String title, PiTContainer pitParent) {
        super(owner, title);
        this.setModal(false);
        this.m_pitParent = pitParent;
        this.setDefaultCloseOperation(2);
        this.btnCancel.setText(OKCancelDialog.CLOSE);
        DRASyncPairManager.getInstance().addDRPiTListener(this.m_pitsMonitor);
        DRConsistencyGroupManager.getInstance().addDRPiTListener(this.m_pitsMonitor);
        this.setWaitCursor();
        this.m_mainPanel = new SrPanel(new BorderLayout());
        this.getContentPane().add((Component)this.m_mainPanel, "Center");
        SrPanel lastUpdPanel = this.createSrPanel(new SrClientLabel(LAST_UPDATE), this.m_lastUpdateField);
        this.m_mainPanel.add((Component)lastUpdPanel, "North");
        this.m_pitTable = new SrTablePanel(new SrPiTTableModel(pitParent));
        this.m_pitTable.hideTableColumn(SrPiTTableHeader.PIT_NODE.getColumnName());
        this.m_pitTable.setSelectionMode(0);
        Dimension preferredSize = this.m_pitTable.getPreferredSize();
        preferredSize.height = preferredSize.width / 2;
        this.m_pitTable.setPreferredSize(preferredSize);
        this.m_mainPanel.add((Component)this.m_pitTable, "Center");
        Color valueFg = ClientLoader.UI_BUNDLE.getColorResource(SrDefaultUIBundleKeys.WIZARD_VALUE_LABEL_COLOR);
        this.m_lastUpdateField.setForeground(valueFg);
        this.pack();
        this.refreshPiTs();
        ActionListener refreshPitsAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SrPiTDialog.this.refreshPiTs();
            }
        };
        this.m_timer = new Timer(10000, refreshPitsAction);
        this.m_timer.start();
        this.m_dialogLoadTimer = new Timer(750, refreshPitsAction);
        this.m_dialogLoadTimer.setRepeats(false);
        this.m_dialogLoadTimer.start();
    }

    protected void registerPiTListeners() {
        SrPiTTableModel model = (SrPiTTableModel)this.m_pitTable.getModel();
        DRPiTManager.getInstance().addDRPiTListener(model);
    }

    protected void unregisterPiTListeners() {
        SrPiTTableModel model = (SrPiTTableModel)this.m_pitTable.getModel();
        DRPiTManager.getInstance().removeDRPiTListener(model);
    }

    @Override
    public void addListeners() {
        DRManager.getInstance().addDRListener(this);
    }

    @Override
    public void removeListeners() {
        DRManager.getInstance().removeDRListener(this);
    }

    @Override
    public void doOnCancel() {
        this.dispose();
    }

    @Override
    protected void setDefaultButton() {
        this.getRootPane().setDefaultButton(this.btnCancel);
    }

    @Override
    public void asyncPairChanged(DRAsyncPairEvent e) {
    }

    @Override
    public void asyncPairCreated(DRAsyncPairEvent e) {
    }

    @Override
    public void asyncPairRemoved(DRAsyncPairEvent e) {
        if (this.m_pitParent == e.getPair()) {
            SrOptionPaneUtil.showErrorMessage(this, this.getParentDeletionMessage());
            this.dispose();
        }
    }

    @Override
    public void consistencyGroupAliasChanged(DRConsistencyGroupEvent e) {
    }

    @Override
    public void consistencyGroupChanged(DRConsistencyGroupEvent e) {
    }

    @Override
    public void consistencyGroupCreated(DRConsistencyGroupEvent e) {
    }

    @Override
    public void consistencyGroupRemoved(DRConsistencyGroupEvent e) {
        if (this.m_pitParent == e.getExtendedElementNode()) {
            SrOptionPaneUtil.showErrorMessage(this, this.getParentDeletionMessage());
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        this.m_timer.stop();
        DRASyncPairManager.getInstance().removeDRPiTListener(this.m_pitsMonitor);
        DRConsistencyGroupManager.getInstance().removeDRPiTListener(this.m_pitsMonitor);
        DRPiTManager.getInstance().removeDRPiTListener(this.m_pitsMonitor);
        this.unregisterPiTListeners();
        super.dispose();
    }

    @Override
    public void drDiscoveryStarted(DREvent e) {
        String msg = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_DR_DISCOVERY_START_ERROR_MSG);
        String title = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_DR_DISCOVERY_START_ERROR_TITLE);
        SrOptionPaneUtil.showErrorMsg(this, msg, title);
        this.dispose();
    }

    @Override
    public void drDiscoveryCompleted(DREvent e) {
    }

    protected abstract void refreshPiTs();

    protected abstract String getParentDeletionMessage();

    protected abstract boolean isRelevantPiT(DRPiTNode var1);

    protected abstract void init();

    private class PiTsUpdateMonitor
    implements DRPiTListener {
        private int parentUpdateCount = 0;

        private PiTsUpdateMonitor() {
        }

        @Override
        public void drPiTCreated(DRPiTEvent pit) {
        }

        @Override
        public void drPiTChanged(DRPiTEvent pit) {
        }

        @Override
        public void drPiTRemoved(DRPiTEvent pit) {
        }

        @Override
        public void drPiTsParentUpdated(DRPiTEvent e) {
            if (e.getPiTParent() == SrPiTDialog.this.m_pitParent) {
                SrPiTDialog.this.calendar.setTimeInMillis(System.currentTimeMillis());
                SrPiTDialog.this.m_lastUpdateField.setText(SrPiTDialog.this.calendar.getTime().toString());
                ++this.parentUpdateCount;
                if (this.parentUpdateCount == 2) {
                    SrPiTDialog.this.registerPiTListeners();
                    SrPiTDialog.this.init();
                    SrPiTDialog.this.setDefaultCursor();
                    DRPiTManager.getInstance().addDRPiTListener(this);
                }
            }
        }
    }
}

