/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr.pit;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRConsistencyGroupManager;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.pit.DRPiTManager;
import com.sanrad.nms.client.data.dr.pit.DRPiTNode;
import com.sanrad.nms.client.data.dr.pit.PiTContainer;
import com.sanrad.nms.client.data.dr.pit.SrCGPiTChildrenTableHeader;
import com.sanrad.nms.client.data.dr.pit.SrCGPiTChildrenTableModel;
import com.sanrad.nms.client.data.dr.pit.SrPiTTableModel;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.dr.pit.SrPiTDialog;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SrConsistencyGroupPiTsDialog
extends SrPiTDialog {
    private static final String SUB_RABLE_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_PITS_DIALOG_SUB_TABLE_TITLE);
    private SrTablePanel m_pitChildrenTablePanel;
    private SrClientLabel m_selectedPiTDateField = new SrClientLabel();

    public SrConsistencyGroupPiTsDialog(ExtendedElementNode cg) {
        super((JFrame)ClientLoader.getMainFrame(), ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_CG_PITS_DIALOG_TITLE, cg.toString()), cg);
        this.m_pitChildrenTablePanel = new SrTablePanel(new SrCGPiTChildrenTableModel());
        this.m_pitChildrenTablePanel.hideTableColumn(SrCGPiTChildrenTableHeader.PIT_NODE.getColumnName());
        this.m_pitChildrenTablePanel.getTable().setRowSelectionAllowed(false);
        this.m_pitTable.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SrCGPiTChildrenTableModel model = (SrCGPiTChildrenTableModel)SrConsistencyGroupPiTsDialog.this.m_pitChildrenTablePanel.getTable().getModel();
                    int selectedRow = SrConsistencyGroupPiTsDialog.this.m_pitTable.getSelectedRow();
                    if (selectedRow >= 0) {
                        DRPiTNode selectedPit = ((SrPiTTableModel)SrConsistencyGroupPiTsDialog.this.m_pitTable.getModel()).getPiT(selectedRow);
                        model.setPiTParent(selectedPit);
                        model.init();
                    } else {
                        model.setPiTParent(null);
                        model.removeAllRows();
                    }
                }
            }
        });
        Dimension mainTableSize = this.m_pitTable.getPreferredSize();
        Dimension preferredSize = new Dimension(mainTableSize.width, mainTableSize.height / 2);
        this.m_pitChildrenTablePanel.setPreferredSize(preferredSize);
        SrPanel subTableTitlePanel = this.createSrPanel(new SrClientLabel(SUB_RABLE_TITLE), this.m_selectedPiTDateField);
        SrPanel subTablePanel = new SrPanel(new BorderLayout());
        subTablePanel.add((Component)subTableTitlePanel, "North");
        subTablePanel.add((Component)this.m_pitChildrenTablePanel, "Center");
        this.m_mainPanel.add((Component)subTablePanel, "South");
        this.pack();
    }

    @Override
    protected void refreshPiTs() {
        ArrayList<SrFuture<Void>> futures = new ArrayList<SrFuture<Void>>();
        futures.add(DRConsistencyGroupManager.getInstance().refreshPiTs((ExtendedElementNode)this.m_pitParent));
        DRASyncPairNode[] pairs = ((ExtendedElementNode)this.m_pitParent).getPairs();
        futures.add(DRASyncPairManager.getInstance().refreshPiTs(Arrays.asList(pairs)));
        SrAction.waitAndInvokeController(futures, this);
    }

    @Override
    protected String getParentDeletionMessage() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_PITS_DIALOG_CG_WAS_DELETED_MSG);
    }

    @Override
    protected boolean isRelevantPiT(DRPiTNode pit) {
        PiTContainer pitParent = pit.getParentNode();
        return pitParent == this.m_pitParent || pitParent instanceof DRASyncPairNode && ((ExtendedElementNode)this.m_pitParent).containsPair((DRASyncPairNode)pitParent);
    }

    @Override
    protected void init() {
        DRPiTManager.getInstance().readPiTs(this.m_pitParent);
        DRASyncPairNode[] pairs = ((ExtendedElementNode)this.m_pitParent).getPairs();
        int i = pairs.length;
        while (i-- > 0) {
            DRPiTManager.getInstance().readPiTs(pairs[i]);
        }
        SrPiTTableModel model = (SrPiTTableModel)this.m_pitTable.getModel();
        model.init();
    }

    @Override
    protected void registerPiTListeners() {
        super.registerPiTListeners();
        SrCGPiTChildrenTableModel model = (SrCGPiTChildrenTableModel)this.m_pitChildrenTablePanel.getTable().getModel();
        DRPiTManager.getInstance().addDRPiTListener(model);
    }

    @Override
    protected void unregisterPiTListeners() {
        super.unregisterPiTListeners();
        SrCGPiTChildrenTableModel model = (SrCGPiTChildrenTableModel)this.m_pitChildrenTablePanel.getTable().getModel();
        DRPiTManager.getInstance().removeDRPiTListener(model);
    }
}

