/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.volume.VolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.swing.SrPropertyPanel;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.components.SrWidget;
import com.sanrad.util.BundleKeysInterface;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.BorderFactory;

public class SrSyncPairPropertiesPanel
extends SrPropertyPanel {
    protected DRPairNode m_pair;
    public static final String KEY_PRIM_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_PRIM_TITLE_KEY);
    public static final String KEY_SEC_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_SEC_TITLE_KEY);
    public static final String KEY_SITE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_SITE_KEY);
    public static final String KEY_CLUSTER = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_CLUSTER_KEY);
    public static final String KEY_VOLUME = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_VOLUME_KEY);
    public static final String KEY_PAIR_STATE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_STATE_KEY);
    public static final String KEY_PAIR_MODE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_MODE_KEY);
    public static final String KEY_INITIALS_SYNC = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_INIRIAL_SYNC_TITLE_KEY);
    public static final String KEY_INITIALS_SYNC_TYPE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_INIRIAL_SYNC_TYPE_KEY);
    public static final String KEY_INITIALS_SYNC_STATE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_INIRIAL_SYNC_STATE_KEY);
    public static final String KEY_INITIALS_SYNC_DATA_TARNS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_INIRIAL_SYNC_DATA_TRNAS_KEY);
    public static final String KEY_OTHERS_PANEL_NAME = "Others";
    public static final String KEY_REPLICATION = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_REPLICATION_TITLE_KEY);
    public static final String KEY_REPLICATION_MODE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_REPLICATION_MODE_KEY);
    public static final String KEY_REPLICATION_STATE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_REPLICATION_STATE_KEY);

    protected SrSyncPairPropertiesPanel(String panelName, DRPairNode pair) {
        super(panelName, false, false, false);
        this.m_pair = pair;
        this.initComponents();
    }

    public SrSyncPairPropertiesPanel(DRPairNode pair) {
        this(SrSyncPairPropertiesPanel.class.getName(), pair);
        this.updateFields(pair);
    }

    private void initComponents() {
        SrPropertyPanel primPanel = this.getPrimaryPanel();
        primPanel.setBorder(BorderFactory.createTitledBorder(KEY_PRIM_TITLE));
        GridBagConstraints itemConstraints = new GridBagConstraints();
        itemConstraints.gridwidth = 2;
        itemConstraints.insets = new Insets(0, 10, 5, 0);
        itemConstraints.weightx = 1.0;
        itemConstraints.anchor = 17;
        itemConstraints.fill = 1;
        this.addPropertyPanel(primPanel, true, itemConstraints);
        SrPropertyPanel secPanel = this.getSecondaryPanel();
        secPanel.setBorder(BorderFactory.createTitledBorder(KEY_SEC_TITLE));
        itemConstraints.insets.right = 10;
        this.addPropertyPanel(secPanel, true, itemConstraints);
        SrPropertyPanel othersPanel = this.getOthersPanel();
        itemConstraints = new GridBagConstraints();
        itemConstraints.gridy = 1;
        itemConstraints.gridwidth = 0;
        itemConstraints.insets = new Insets(10, 0, 0, 0);
        itemConstraints.weightx = 1.0;
        itemConstraints.anchor = 17;
        itemConstraints.fill = 2;
        this.addPropertyPanel(othersPanel, true, itemConstraints);
        SrPropertyPanel initialSyncPanel = this.getInitialSyncPanel();
        this.addPropertyPanel(initialSyncPanel, true);
        SrPropertyPanel replicationPanel = this.getReplicationPanel();
        replicationPanel.setBorder(BorderFactory.createTitledBorder(KEY_REPLICATION));
        this.addPropertyPanel(replicationPanel, true);
    }

    protected DRPairInitialSyncTypeConstant[] getInitialSyncValidValues() {
        if (DRInitialSyncStateConstant.IN_PROGRESS.equals(this.m_pair.getInitialSyncState()) || this.m_pair.getReplicationState().contains(DRReplicationStateConstant.FALLBACK) || this.m_pair.getReplicationState().contains(DRReplicationStateConstant.PLANNED_FAILOVER)) {
            return new DRPairInitialSyncTypeConstant[]{this.m_pair.getInitialSyncType()};
        }
        return new DRPairInitialSyncTypeConstant[]{DRPairInitialSyncTypeConstant.ONLINE, DRPairInitialSyncTypeConstant.NONE};
    }

    private SrPropertyPanel getInitialSyncPanel() {
        SrPropertyPanel initialSyncPanel = new SrPropertyPanel(KEY_INITIALS_SYNC);
        SrComboBox<DRPairInitialSyncTypeConstant> initialSyncComboBox = new SrComboBox<DRPairInitialSyncTypeConstant>((T[])this.getInitialSyncValidValues());
        initialSyncPanel.addProperty(KEY_INITIALS_SYNC_TYPE, initialSyncComboBox);
        initialSyncPanel.addProperty(KEY_INITIALS_SYNC_STATE, SrWidget.getReadOnlyWidget(KEY_INITIALS_SYNC_STATE, new SrTextField()));
        initialSyncPanel.addProperty(KEY_INITIALS_SYNC_DATA_TARNS, SrWidget.getReadOnlyWidget(KEY_INITIALS_SYNC_DATA_TARNS, new SrTextField()));
        initialSyncPanel.setBorder(BorderFactory.createTitledBorder(KEY_INITIALS_SYNC));
        return initialSyncPanel;
    }

    protected SrPropertyPanel getPrimaryPanel() {
        SrPropertyPanel primPanel = new SrPropertyPanel(KEY_PRIM_TITLE);
        primPanel.addProperty(KEY_SITE, SrWidget.getReadOnlyWidget(KEY_SITE, new SrTextField()));
        primPanel.addProperty(KEY_CLUSTER, SrWidget.getReadOnlyWidget(KEY_CLUSTER, new SrTextField()));
        primPanel.addProperty(KEY_VOLUME, SrWidget.getReadOnlyWidget(KEY_VOLUME, new SrTextField()));
        return primPanel;
    }

    protected SrPropertyPanel getSecondaryPanel() {
        SrPropertyPanel secPanel = new SrPropertyPanel(KEY_SEC_TITLE);
        secPanel.addProperty(KEY_SITE, SrWidget.getReadOnlyWidget(KEY_SITE, new SrTextField()));
        secPanel.addProperty(KEY_CLUSTER, SrWidget.getReadOnlyWidget(KEY_CLUSTER, new SrTextField()));
        secPanel.addProperty(KEY_VOLUME, SrWidget.getReadOnlyWidget(KEY_VOLUME, new SrTextField()));
        return secPanel;
    }

    protected SrPropertyPanel getOthersPanel() {
        SrPropertyPanel othersPanel = new SrPropertyPanel(KEY_OTHERS_PANEL_NAME);
        othersPanel.addProperty(KEY_PAIR_STATE, SrWidget.getReadOnlyWidget(KEY_PAIR_STATE, new SrTextField()));
        othersPanel.addProperty(KEY_PAIR_MODE, SrWidget.getReadOnlyWidget(KEY_PAIR_MODE, new SrTextField()));
        return othersPanel;
    }

    protected SrPropertyPanel getReplicationPanel() {
        SrPropertyPanel replicationPanel = new SrPropertyPanel(KEY_REPLICATION);
        replicationPanel.addProperty(KEY_REPLICATION_STATE, SrWidget.getReadOnlyWidget(KEY_REPLICATION_STATE, new SrTextField()));
        replicationPanel.addProperty(KEY_REPLICATION_MODE, SrWidget.getReadOnlyWidget(KEY_REPLICATION_MODE, new SrTextField()));
        return replicationPanel;
    }

    public DRPairNode getPair() {
        return this.m_pair;
    }

    public void updateFields(DRPairNode pair) {
        this.setPropertyValue(KEY_INITIALS_SYNC + "__" + KEY_INITIALS_SYNC_TYPE, pair.getInitialSyncType());
        this.setPropertyValue(KEY_INITIALS_SYNC + "__" + KEY_INITIALS_SYNC_STATE, pair.getInitialSyncState());
        String[] args = new String[]{String.valueOf(pair.getDataTransffered())};
        String iSyncDataTrans = ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_INIRIAL_SYNC_DATA_TRNAS_VALUE, args);
        this.setPropertyValue(KEY_INITIALS_SYNC + "__" + KEY_INITIALS_SYNC_DATA_TARNS, iSyncDataTrans);
        this.setPropertyValue(KEY_PRIM_TITLE + "__" + KEY_CLUSTER, SystemRootNode.getInstance().getClusterNodeOfSource(pair.getPairPrimaryVolume()));
        this.setPropertyValue(KEY_PRIM_TITLE + "__" + KEY_SITE, pair.getPairPrimarySite());
        this.setPropertyValue(KEY_PRIM_TITLE + "__" + KEY_VOLUME, pair.getPairPrimaryVolume());
        this.setPropertyValue(KEY_SEC_TITLE + "__" + KEY_CLUSTER, SystemRootNode.getInstance().getClusterNodeOfSource(pair.getPairSecondaryVolume()));
        this.setPropertyValue(KEY_SEC_TITLE + "__" + KEY_SITE, pair.getPairSecondarySite());
        this.setPropertyValue(KEY_SEC_TITLE + "__" + KEY_VOLUME, pair.getPairSecondaryVolume());
        this.setPropertyValue("Others__" + KEY_PAIR_STATE, pair.getPairState());
        this.setPropertyValue("Others__" + KEY_PAIR_MODE, pair.getMode());
        this.setPropertyValue(KEY_REPLICATION + "__" + KEY_REPLICATION_MODE, this.m_pair.getMode());
        this.setPropertyValue(KEY_REPLICATION + "__" + KEY_REPLICATION_STATE, this.m_pair.getReplicationState());
    }

    public void volumeAliasChanged(VolumeEvent e) {
        VolumeTreeNode primVol;
        VolumeNode vol = (VolumeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        if (vol == (primVol = this.getPair().getPairPrimaryVolume())) {
            this.setPropertyValue(KEY_PRIM_TITLE + "__" + KEY_VOLUME, vol.getAlias());
            return;
        }
        VolumeTreeNode secVol = this.getPair().getPairSecondaryVolume();
        if (vol == secVol) {
            this.setPropertyValue(KEY_SEC_TITLE + "__" + KEY_VOLUME, vol.getAlias());
        }
    }

    public DRPairInitialSyncTypeConstant getInitialSyncType() {
        return (DRPairInitialSyncTypeConstant)this.getPropertyVal(KEY_INITIALS_SYNC + "__" + KEY_INITIALS_SYNC_TYPE);
    }
}

