/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.DRSyncPairManager;
import com.sanrad.nms.client.data.dr.DRSyncPairNode;
import com.sanrad.nms.client.data.site.SiteManager;
import com.sanrad.nms.client.event.dr.DREvent;
import com.sanrad.nms.client.event.dr.DRListener;
import com.sanrad.nms.client.event.dr.DRSyncPairEvent;
import com.sanrad.nms.client.event.dr.DRSyncPairListener;
import com.sanrad.nms.client.event.site.SiteEvent;
import com.sanrad.nms.client.event.site.SiteListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.dr.SrSyncPairPropertiesPanel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SrSyncPairPropertiesDialog
extends SrOKCancelDialog
implements DRSyncPairListener,
SiteListener,
DRListener {
    protected DRPairNode m_pair;
    private SrSyncPairPropertiesPanel panel;

    public SrSyncPairPropertiesDialog(JFrame frm, DRPairNode pair) {
        this(frm, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_SYNC_PAIR_PROPERTIES_DIALOG_TITLE), pair);
        this.panel = new SrSyncPairPropertiesPanel(pair);
        this.addCenterPanel(this.panel);
        this.setOKAction();
        this.pack();
    }

    protected SrSyncPairPropertiesDialog(JFrame frm, String title, DRPairNode pair) {
        super(frm, title, false);
        this.m_pair = pair;
        this.addListeners();
    }

    @Override
    public void addListeners() {
        DRSyncPairManager.getInstance().addDRSyncPairListener(this);
        SiteManager.getInstance().addSiteListener(this);
        DRManager.getInstance().addDRListener(this);
    }

    @Override
    public void removeListeners() {
        DRSyncPairManager.getInstance().removeDRSyncPairListener(this);
        SiteManager.getInstance().removeSiteListener(this);
        DRManager.getInstance().removeDRListener(this);
    }

    protected void setOKAction() {
        SrClientAction<Void, Void> myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                HashMap<ClientParameterCode, DRPairInitialSyncTypeConstant> changedParams = new HashMap<ClientParameterCode, DRPairInitialSyncTypeConstant>();
                DRPairInitialSyncTypeConstant initialSyncType = SrSyncPairPropertiesDialog.this.panel.getInitialSyncType();
                if (initialSyncType != null && !initialSyncType.equals(SrSyncPairPropertiesDialog.this.m_pair.getInitialSyncType())) {
                    changedParams.put(ClientParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, initialSyncType);
                }
                if (!changedParams.isEmpty()) {
                    return Collections.singleton(DRSyncPairManager.getInstance().changeSyncPair((DRSyncPairNode)SrSyncPairPropertiesDialog.this.m_pair, changedParams));
                }
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                return null;
            }
        };
        this.setOKAction(myOKAction);
    }

    @Override
    public void syncPairCreated(DRSyncPairEvent e) {
    }

    @Override
    public void syncPairRemoved(DRSyncPairEvent e) {
        if (e.getPair() == this.m_pair) {
            String msg = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_PAIR_WAS_DELETED_MSG);
            String title = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_PAIR_WAS_DELETED_MSG_TITLE);
            JOptionPane.showMessageDialog(this, msg, title, 0);
            this.dispose();
        }
    }

    @Override
    public void syncPairChanged(DRSyncPairEvent e) {
    }

    @Override
    public void siteRemoved(SiteEvent event) {
    }

    @Override
    public void sitePropertiesChanged(SiteEvent event) {
    }

    @Override
    public void siteCreated(SiteEvent event) {
    }

    @Override
    public void siteStatusChanged(SiteEvent event) {
    }

    @Override
    public void drDiscoveryStarted(DREvent e) {
        String msg = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_DR_DISCOVERY_START_ERROR_MSG);
        String title = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_DR_DISCOVERY_START_ERROR_TITLE);
        SrOptionPaneUtil.showErrorMsg(this, msg, title);
        this.dispose();
    }

    @Override
    public void drDiscoveryCompleted(DREvent e) {
    }

    @Override
    public void doOnCancel() {
    }
}

