/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.dr.ConsistencyGroupNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRConsistencyGroupManager;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.DRSyncPairNode;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.ExtendedPairNode;
import com.sanrad.nms.client.data.dr.SrConsistencyGroupsTableModel;
import com.sanrad.nms.client.data.dr.SrPairDetailsTableModel;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.gui.SrCheckBoxTreePanel;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.SrTreeModel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import com.sanrad.util.concurrent.SrFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class SrSelectAndStartReplicateDialog
extends SrOKCancelDialog {
    View<MutableTreeNode> myTreeView;
    SrCheckBoxTreePanel myTreePanel = new SrCheckBoxTreePanel(new DRNodeRenderer());

    public SrSelectAndStartReplicateDialog() {
        super((JFrame)ClientLoader.getMainFrame(), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_START_REPLICATE_DIALOG_TITLE), true);
        this.myTreePanel.addNodeCheckListener(new SrCheckBoxTreePanel.NodeCheckListener(){

            @Override
            public void treeNodeChecked(MutableTreeNode aNode) {
                this.checkSubTree(aNode, true);
            }

            private void checkSubTree(MutableTreeNode parent, boolean checked) {
                List<MutableTreeNode> children = SrSelectAndStartReplicateDialog.this.myTreePanel.getChildren(parent);
                for (MutableTreeNode child : children) {
                    SrSelectAndStartReplicateDialog.this.myTreePanel.setNodeChecked(child, checked);
                    this.checkSubTree(child, checked);
                }
            }

            @Override
            public void treeNodeUnChecked(MutableTreeNode aNode) {
                MutableTreeNode parent = SrSelectAndStartReplicateDialog.this.myTreePanel.getParentNode(aNode);
                while (parent != null) {
                    SrSelectAndStartReplicateDialog.this.myTreePanel.setNodeChecked(parent, false);
                    parent = SrSelectAndStartReplicateDialog.this.myTreePanel.getParentNode(parent);
                }
                this.checkSubTree(aNode, false);
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.myTreePanel.getTreeObject());
        this.myTreeView = new View<MutableTreeNode>(){

            @Override
            public Collection<MutableTreeNode> getValue() {
                return SrSelectAndStartReplicateDialog.this.myTreePanel.getCheckedNodes();
            }

            @Override
            public void addListener(SrAction<MutableTreeNode, ?> action) {
            }

            @Override
            public void removeListener(SrAction<MutableTreeNode, ?> action) {
            }
        };
        this.initTreeWithDRElements();
        this.addCenterPanel(this.myTreePanel);
        this.setOKAction(new StartReplicateAction());
        this.myTreePanel.getTreeObject().expandAllTree();
        this.pack();
    }

    @Override
    public void addListeners() {
    }

    private void initTreeWithDRElements() {
        SiteNode[] sites = SystemRootNode.getInstance().getSiteNodes();
        SrConsistencyGroupsTableModel cgModel = SrConsistencyGroupsTableModel.getInstance();
        SrPairDetailsTableModel pairModel = SrPairDetailsTableModel.getInstance();
        SrTreeModel treeModel = this.myTreePanel.getTreeModel();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
        for (SiteNode site : sites) {
            List<ExtendedElementNode> cgs = cgModel.getAllGroupsPrimaryOnSite(site);
            List<DRSyncPairNode> syncPairs = pairModel.getSyncPairsPrimaryOnSite(site);
            if (cgs.size() <= 0 && syncPairs.size() <= 0) continue;
            treeModel.insertOrderedByName(rootNode, site);
            for (ExtendedElementNode cg : cgs) {
                treeModel.insertOrderedByName(site, cg);
                if (!(cg instanceof ConsistencyGroupNode)) continue;
                for (DRASyncPairNode pair : cg.getPairs()) {
                    treeModel.insertOrderedByName(cg, pair);
                }
            }
            for (DRSyncPairNode syncPair : syncPairs) {
                treeModel.insertOrderedByName(site, syncPair);
            }
        }
        this.myTreePanel.getTreeObject().expandPath(treeModel.getTreePath(rootNode));
    }

    @Override
    public void doOnCancel() {
        this.clearAll();
        this.dispose();
    }

    private void clearAll() {
        ToolTipManager.sharedInstance().unregisterComponent(this.myTreePanel.getTreeObject());
    }

    @Override
    public void removeListeners() {
    }

    private static class DRNodeRenderer
    implements SrCheckBoxTreePanel.TreeNodeRendererProperties {
        private DRNodeRenderer() {
        }

        @Override
        public String getDisabledTooltip(MutableTreeNode node) {
            String cannotReplicateReason = null;
            if (node instanceof ExtendedElementNode) {
                cannotReplicateReason = DRConsistencyGroupManager.getInstance().validateStartReplication((ExtendedElementNode)node);
            } else if (node instanceof DRPairNode) {
                cannotReplicateReason = DRPairManager.validatePairStartReplication((DRPairNode)node);
            }
            return cannotReplicateReason;
        }

        @Override
        public String getTreeCellText(MutableTreeNode node) {
            if (node instanceof ExtendedPairNode) {
                return ((ExtendedPairNode)node).getPair().toString();
            }
            return node.toString();
        }
    }

    private class StartReplicateAction
    extends SrClientAction<MutableTreeNode, Void> {
        StartReplicateAction() {
            super(null, true, true, SrSelectAndStartReplicateDialog.this.myTreeView, SrLicenseTreePath.GDR_PATH);
            SrSelectAndStartReplicateDialog.this.myTreePanel.addNodeCheckListener(new SrCheckBoxTreePanel.NodeCheckListener(){

                @Override
                public void treeNodeChecked(MutableTreeNode aNode) {
                    StartReplicateAction.this.updateEnabled();
                }

                @Override
                public void treeNodeUnChecked(MutableTreeNode aNode) {
                    StartReplicateAction.this.updateEnabled();
                }
            });
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<MutableTreeNode> aArg) {
            ArrayList<DRSyncPairNode> syncList = new ArrayList<DRSyncPairNode>();
            ArrayList<ExtendedElementNode> cgsList = new ArrayList<ExtendedElementNode>();
            for (MutableTreeNode node : aArg) {
                if (node instanceof DRSyncPairNode) {
                    syncList.add((DRSyncPairNode)node);
                    continue;
                }
                if (!(node instanceof ExtendedElementNode)) continue;
                cgsList.add((ExtendedElementNode)node);
            }
            return DRManager.getInstance().startReplicate(cgsList.toArray(new ExtendedElementNode[cgsList.size()]), syncList.toArray(new DRSyncPairNode[syncList.size()]));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }
}

