/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.SrMainTreeModel;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.ConsistencyGroupNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.DRSyncPairNode;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.ExtendedPairNode;
import com.sanrad.nms.client.data.dr.SrPairDetailsTableHeader;
import com.sanrad.nms.client.data.dr.SrPairDetailsTableModel;
import com.sanrad.nms.client.data.site.SiteManager;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.GenericTableCellRenderer;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrTransientWindowPane;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteDRAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.dr.SrASyncPairPropertiesDialog;
import com.sanrad.nms.client.gui.dr.SrPairActions;
import com.sanrad.nms.client.gui.dr.SrPairDetailsTablePopupMenu;
import com.sanrad.nms.client.gui.dr.SrSyncPairPropertiesDialog;
import com.sanrad.nms.client.gui.dr.pit.SrConsistencyGroupPiTsDialog;
import com.sanrad.nms.client.gui.dr.pit.SrPairPiTTableDialog;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.util.types.constants.CFStateConstant;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.SrSwingUtils;
import com.sanrad.swing.SrTableModel;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.ConstantView;
import com.sanrad.swing.actions.SrTableView;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.actions.ViewDecorator;
import com.sanrad.swing.components.SrProgressDotsPanel;
import com.sanrad.swing.table.SrTableCellTooltip;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class SrPairDetailsTablePanel
extends SrTablePanel
implements SrPairActions {
    private int m_colNodeIndex;
    private final View<DRPairNode> myView = new SrTableView<DRPairNode>((JTable)this.getTable()){

        @Override
        public Collection<DRPairNode> getValue() {
            return Arrays.asList(SrPairDetailsTablePanel.this.getSelectedPairsNodes());
        }
    };
    private final DeleteAction myDeleteAction = new DeleteDRAction<DRPairNode>(this.myView, StatusPanel.getInstance(), new DeleteAction.Confirmator<DRPairNode>(){

        @Override
        public String getTitle(DRPairNode item) {
            return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_PAIRS_TABLE_DELETE_PAIRS_MSG_BOX_TITLE);
        }

        @Override
        protected String getMessage(DRPairNode item) {
            return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_PAIRS_TABLE_DELETE_PAIR_MSG_BOX_STRING) + item + "?";
        }
    });
    public final SrClientAction propertiesAction = new SrClientAction<DRPairNode, Void>(true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<DRPairNode> arg) {
            Point prevDialogLocation = null;
            for (DRPairNode selectedNode : arg) {
                JDialog dialog = null;
                boolean isNewDialog = false;
                if (selectedNode instanceof DRASyncPairNode) {
                    dialog = (JDialog)selectedNode.getDialog(SrASyncPairPropertiesDialog.class);
                    if (dialog == null) {
                        dialog = new SrASyncPairPropertiesDialog((JFrame)ClientLoader.getMainFrame(), (DRASyncPairNode)selectedNode);
                        isNewDialog = true;
                    }
                } else {
                    dialog = (JDialog)selectedNode.getDialog(SrSyncPairPropertiesDialog.class);
                    if (dialog == null) {
                        dialog = new SrSyncPairPropertiesDialog((JFrame)ClientLoader.getMainFrame(), selectedNode);
                        isNewDialog = true;
                    }
                }
                if (isNewDialog) {
                    selectedNode.addDialog(dialog);
                    dialog.setVisible(true);
                } else {
                    dialog.requestFocus();
                }
                if (prevDialogLocation != null) {
                    prevDialogLocation.x += 22;
                    prevDialogLocation.y += 22;
                    dialog.setLocation(prevDialogLocation);
                    continue;
                }
                prevDialogLocation = dialog.getLocation();
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final AlarmAction myPropagatedAlarmsAction = new AlarmAction<DRPairNode>(this.myView, false);
    public final AlarmAction mySpecificAlarmsAction = new AlarmAction<DRPairNode>(this.myView, true);
    public final SrClientAction startInitialSync = new SrClientAction<DRPairNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_START_INITIAL_SYNC), true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){
        private Collection<DRPairNode> myLastArgs;
        {
            this.myLastArgs = null;
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<DRPairNode> arg) {
            ArrayList<String> drPairs = new ArrayList<String>(arg.size());
            for (DRPairNode node : arg) {
                drPairs.add((String)node.getIdentifier());
            }
            this.myLastArgs = arg;
            return Collections.singleton(ClientAOImpl.getInstance().startInitialSync(drPairs));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (DRPairNode node : this.myView.getValue()) {
                if (node.isInCopy()) {
                    ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_VOLUME_IN_COPY_OPERATION_MSG);
                }
                boolean isInactive = DRReplicationStateConstant.INACTIVE.equals(node.getReplicationState());
                if (node instanceof DRASyncPairNode && ((DRASyncPairNode)node).getConsistencyGroup() instanceof ConsistencyGroupNode) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_ASYNC_PAIR_IN_CG_MSG);
                }
                boolean isCFWait = CFStateConstant.CF_WAIT.equals(node.getControlFunctionState());
                if (isInactive) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_REPLICATION_INACTIVE_MSG);
                }
                if (node instanceof DRSyncPairNode) {
                    if (!DRInitialSyncStateConstant.NEED_SYNC.equals(node.getInitialSyncState())) {
                        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_NO_NEED_SYNC_MSG);
                    }
                    if (DRReplicationStateConstant.INACTIVE.equals(node.getReplicationState())) {
                        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_REPLICATION_INACTIVE_MSG);
                    }
                    if (!isCFWait) continue;
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_CF_IN_PROGRESS_MSG);
                }
                return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_NOT_SYNC_PAIR_MSG);
            }
            return null;
        }

        @Override
        protected void onActionFinished(Collection<? extends SrFuture<Void>> aFutures) {
            super.onActionFinished(aFutures);
            if (aFutures.size() == 1) {
                ArrayList<DRPairNode> started = new ArrayList<DRPairNode>(this.myLastArgs.size());
                for (DRPairNode pair : this.myLastArgs) {
                    if (!pair.getInitialSyncState().equals(DRInitialSyncStateConstant.OK) && !pair.getInitialSyncState().equals(DRInitialSyncStateConstant.IN_PROGRESS)) continue;
                    started.add(pair);
                }
                if (!started.isEmpty()) {
                    SrTransientWindowPane.showMultiGDRInitialSyncStarted(ClientLoader.getMainFrame(), started.size(), this.myLastArgs.size(), new SelectorAction(new ConstantView<DRPairNode>(started)));
                }
            }
            this.myLastArgs = null;
        }
    };
    public final SrClientAction endInitialSync = new SrClientAction<DRPairNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_END_INITIAL_SYNC), true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<DRPairNode> arg) {
            ArrayList<String> ids = new ArrayList<String>(arg.size());
            for (DRPairNode node : arg) {
                ids.add((String)node.getIdentifier());
            }
            return Collections.singleton(ClientAOImpl.getInstance().endInitialSync(ids));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (DRPairNode node : this.myView.getValue()) {
                if (node.isInCopy()) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_VOLUME_IN_COPY_OPERATION_MSG);
                }
                boolean isInactive = DRReplicationStateConstant.INACTIVE.equals(node.getReplicationState());
                if (node instanceof DRASyncPairNode && ((DRASyncPairNode)node).getConsistencyGroup() instanceof ConsistencyGroupNode) {
                    Object tooltipEIS = null;
                    if (!DRInitialSyncStateConstant.IN_PROGRESS.equals(node.getInitialSyncState())) {
                        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_NO_INIT_SYNC_MSG);
                    }
                    if (DRPairInitialSyncTypeConstant.OFFLINE.equals(node.getInitialSyncType())) continue;
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_NOT_OFFLINE_MSG);
                }
                boolean isCFWait = CFStateConstant.CF_WAIT.equals(node.getControlFunctionState());
                if (isInactive) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_REPLICATION_INACTIVE_MSG);
                }
                if (node instanceof DRSyncPairNode) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_NO_END_SYNC_ON_A_SYNC_PAIR_MSG);
                }
                if (!node.getInitialSyncType().equals(DRPairInitialSyncTypeConstant.OFFLINE)) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_NOT_OFFLINE_MSG);
                }
                if (!DRInitialSyncStateConstant.IN_PROGRESS.equals(node.getInitialSyncState())) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_NO_INIT_SYNC_MSG);
                }
                if (!isCFWait) continue;
                return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_CF_IN_PROGRESS_MSG);
            }
            return null;
        }
    };
    public final SrClientAction abortInitialSync = new SrClientAction<DRPairNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_ABORT_INITIAL_SYNC), true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<DRPairNode> arg) {
            ArrayList<String> ids = new ArrayList<String>(arg.size());
            for (DRPairNode node : arg) {
                ids.add((String)node.getIdentifier());
            }
            return Collections.singleton(ClientAOImpl.getInstance().abortInitialSync(ids));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (DRPairNode node : this.myView.getValue()) {
                if (node.isInCopy()) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_VOLUME_IN_COPY_OPERATION_MSG);
                }
                boolean isInactive = DRReplicationStateConstant.INACTIVE.equals(node.getReplicationState());
                if (node instanceof DRASyncPairNode && ((DRASyncPairNode)node).getConsistencyGroup() instanceof ConsistencyGroupNode) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_ASYNC_PAIR_IN_CG_MSG);
                }
                boolean isCFWait = CFStateConstant.CF_WAIT.equals(node.getControlFunctionState());
                if (isInactive) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_REPLICATION_INACTIVE_MSG);
                }
                if (node instanceof DRSyncPairNode) {
                    if (!DRInitialSyncStateConstant.IN_PROGRESS.equals(node.getInitialSyncState())) {
                        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_INIT_SYNC_NOT_IN_PROGRESS_MSG);
                    }
                    if (!isCFWait) continue;
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_CF_IN_PROGRESS_MSG);
                }
                return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_NOT_SYNC_PAIR_MSG);
            }
            return null;
        }
    };
    public final SrClientAction abortReplicationAction = new SrClientAction<DRPairNode, Void>(true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<DRPairNode> arg) {
            String confirmTitle = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_ABORT_REPLICATE_CONFIRM_TITLE);
            String confirmMsg = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_ABORT_REPLICATE_CONFIRM_MSG);
            int answer = SrOptionPaneUtil.showYesNoConfirmDialog(ClientLoader.getMainFrame(), confirmMsg, confirmTitle);
            if (answer == 1) {
                return Collections.EMPTY_LIST;
            }
            ArrayList ids = new ArrayList(arg.size());
            for (DRPairNode node : arg) {
                SrTreeNode activationNode = null;
                activationNode = node instanceof DRASyncPairNode && ((DRASyncPairNode)node).getConsistencyGroup() instanceof ExtendedPairNode ? ((DRASyncPairNode)node).getConsistencyGroup() : node;
                ids.add(activationNode.getIdentifier());
                DRManager.getInstance().abortReplicationRequestNotify(activationNode);
            }
            return Collections.singleton(ClientAOImpl.getInstance().abortReplicate(ids));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (DRPairNode node : this.myView.getValue()) {
                if (!(node instanceof DRASyncPairNode) || !(((DRASyncPairNode)node).getConsistencyGroup() instanceof ConsistencyGroupNode)) continue;
                return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_ASYNC_PAIR_IN_CG_MSG);
            }
            return null;
        }
    };
    private final SrClientAction disasterOccurredAction = new SrClientAction<DRPairNode, Void>(true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<DRPairNode> arg) {
            SrTreeNode[] drElements = SrPairDetailsTablePanel.this.getSelectedDRElementsForActivation();
            SiteManager.getInstance().disasterOccurred(drElements, ClientLoader.getMainFrame());
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (DRPairNode node : this.myView.getValue()) {
                ClusterNode remoteClusterNode = node.getRemoteCluster();
                if (remoteClusterNode == null || remoteClusterNode.getConnectedVSwitches().length == 0) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_CANT_DISASTER_FAILOVER_WITHOUT_REMOTE_CONNECTED_VSWITCHES);
                }
                ClusterNode localClusterNode = node.getLocalCluster();
                if (localClusterNode != null && localClusterNode.getConnectedVSwitches().length > 0) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_CANT_DISASTER_FAILOVER_WITH_LOCAL_CONNECTED_VSWITCHES);
                }
                if (!(node instanceof DRASyncPairNode) || !(((DRASyncPairNode)node).getConsistencyGroup() instanceof ConsistencyGroupNode)) continue;
                return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_ASYNC_PAIR_IN_CG_MSG);
            }
            return null;
        }
    };
    private final SrClientAction fallbackAction = new SrClientAction<DRPairNode, Void>(true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<DRPairNode> arg) {
            SrTreeNode[] drElements = SrPairDetailsTablePanel.this.getSelectedDRElementsForActivation();
            SiteManager.getInstance().fallback(drElements, ClientLoader.getMainFrame());
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (DRPairNode node : this.myView.getValue()) {
                if (node.isInCopy()) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_VOLUME_IN_COPY_OPERATION_MSG);
                }
                if (node instanceof DRASyncPairNode && ((DRASyncPairNode)node).getConsistencyGroup() instanceof ConsistencyGroupNode) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_ASYNC_PAIR_IN_CG_MSG);
                }
                boolean isCFWait = CFStateConstant.CF_WAIT.equals(node.getControlFunctionState());
                if (!DRModeConstant.SWITCHED.equals(node.getMode())) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_NOT_SWITCHED_MSG);
                }
                if (node.isPartial()) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_MISSING_SITE_MSG);
                }
                if (node.getReplicationState().contains(DRReplicationStateConstant.FALLBACK)) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_FALLBACK_IN_PROGRESS_MSG);
                }
                if (DRInitialSyncStateConstant.IN_PROGRESS.equals(node.getInitialSyncState())) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_INIT_SYNC_IN_PROGRESS_MSG);
                }
                if (!isCFWait) continue;
                return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_CF_IN_PROGRESS_MSG);
            }
            return null;
        }
    };
    private final SrClientAction plannedFailoverAction = new SrClientAction<DRPairNode, Void>(true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<DRPairNode> arg) {
            SrTreeNode[] drElements = SrPairDetailsTablePanel.this.getSelectedDRElementsForActivation();
            SiteManager.getInstance().plannedFailover(drElements, ClientLoader.getMainFrame());
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (DRPairNode node : this.myView.getValue()) {
                if (node.isInCopy()) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_VOLUME_IN_COPY_OPERATION_MSG);
                }
                if (node instanceof DRASyncPairNode && ((DRASyncPairNode)node).getConsistencyGroup() instanceof ConsistencyGroupNode) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_ASYNC_PAIR_IN_CG_MSG);
                }
                if (!DRModeConstant.NORMAL.equals(node.getMode())) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_SWITCHED_MSG);
                }
                if (node.isPartial()) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_MISSING_SITE_MSG);
                }
                if (node.getReplicationState().contains(DRReplicationStateConstant.PLANNED_FAILOVER)) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_FAILOVER_IN_PROGRESS_MSG);
                }
                if (DRInitialSyncStateConstant.IN_PROGRESS.equals(node.getInitialSyncState())) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_INIT_SYNC_IN_PROGRESS_MSG);
                }
                if (!CFStateConstant.CF_WAIT.equals(node.getControlFunctionState())) continue;
                return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_CF_IN_PROGRESS_MSG);
            }
            return null;
        }
    };
    private final SrClientAction startReplicationAction = new SrClientAction<DRPairNode, Void>(true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<DRPairNode> arg) {
            ArrayList<ExtendedElementNode> cgsList = new ArrayList<ExtendedElementNode>();
            ArrayList<DRPairNode> syncList = new ArrayList<DRPairNode>();
            for (DRPairNode node : arg) {
                if (node instanceof DRASyncPairNode && ((DRASyncPairNode)node).getConsistencyGroup() instanceof ExtendedPairNode) {
                    cgsList.add(((DRASyncPairNode)node).getConsistencyGroup());
                    continue;
                }
                syncList.add(node);
            }
            return DRManager.getInstance().startReplicate(cgsList.toArray(new ExtendedPairNode[cgsList.size()]), syncList.toArray(new DRSyncPairNode[syncList.size()]));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (DRPairNode node : this.myView.getValue()) {
                String msg = DRPairManager.validatePairStartReplication(node);
                if (msg == null) continue;
                return msg;
            }
            return null;
        }
    };
    public final SrClientAction showCGParentPiTs = new SrClientAction<DRPairNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_CG_PITS), null, true, true, this.myView, SrLicenseTreePath.GENERAL_PATH, false, false){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<DRPairNode> arg) {
            DRPairNode[] selectedNodes = SrPairDetailsTablePanel.this.getAvailableSelectedPairsForPiTs();
            Point prevDialogLocation = null;
            for (int i = 0; i < selectedNodes.length; ++i) {
                SrConsistencyGroupPiTsDialog dialog = (SrConsistencyGroupPiTsDialog)selectedNodes[i].getDialog(SrConsistencyGroupPiTsDialog.class);
                if (dialog == null) {
                    dialog = new SrConsistencyGroupPiTsDialog(((DRASyncPairNode)selectedNodes[i]).getConsistencyGroup());
                    selectedNodes[i].addDialog(dialog);
                    dialog.show();
                } else {
                    dialog.requestFocus();
                }
                if (prevDialogLocation != null) {
                    prevDialogLocation.x += 22;
                    prevDialogLocation.y += 22;
                    dialog.setLocation(prevDialogLocation);
                    continue;
                }
                prevDialogLocation = dialog.getLocation();
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction showPiTsAction = new SrClientAction<DRPairNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_SHOW_PITS), true, true, (View)new ViewDecorator<DRPairNode, DRPairNode>(this.myView){

        @Override
        public Collection<DRPairNode> getValue() {
            return Arrays.asList(SrPairDetailsTablePanel.this.getAvailableSelectedPairsForPiTs());
        }
    }, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<DRPairNode> arg) {
            DRPairNode[] selectedNodes = SrPairDetailsTablePanel.this.getAvailableSelectedPairsForPiTs();
            Point prevDialogLocation = null;
            for (int i = 0; i < selectedNodes.length; ++i) {
                SrPairPiTTableDialog dialog = (SrPairPiTTableDialog)selectedNodes[i].getDialog(SrPairPiTTableDialog.class);
                if (dialog == null) {
                    dialog = new SrPairPiTTableDialog((DRASyncPairNode)selectedNodes[i]);
                    selectedNodes[i].addDialog(dialog);
                    dialog.show();
                } else {
                    dialog.requestFocus();
                }
                if (prevDialogLocation != null) {
                    prevDialogLocation.x += 22;
                    prevDialogLocation.y += 22;
                    dialog.setLocation(prevDialogLocation);
                    continue;
                }
                prevDialogLocation = dialog.getLocation();
            }
            return Collections.singleton(new CompleteFuture("SrPairDetailsTablePanel.showPiTsAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };

    public SrPairDetailsTablePanel() {
        super(SrPairDetailsTableModel.getInstance());
        this.startReplicationAction.addControllerAsListener(StatusPanel.getInstance());
        SrPairDetailsTablePopupMenu popup = new SrPairDetailsTablePopupMenu(this, this.disasterOccurredAction, this.startReplicationAction, this.abortReplicationAction, this.plannedFailoverAction, this.fallbackAction);
        this.setTablePopUpMenuObject(popup);
        this.m_colNodeIndex = this.getModel().getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
        this.hideTableColumn(this.m_colNodeIndex);
        this.getTable().setSelectionMode(2);
        PairTableCellRenderer renderer = new PairTableCellRenderer();
        this.setTablePanelCellRenderer(renderer);
        ProgressBarRenderer initialSyncProgressRenderer = new ProgressBarRenderer();
        int initialSyncIndexInModel = this.getModel().getColumnIndex(SrPairDetailsTableHeader.INIT_SYNC.getColumnName());
        int initialSyncIndexInTable = this.getTable().convertColumnIndexToView(initialSyncIndexInModel);
        this.getTable().getColumnModel().getColumn(initialSyncIndexInTable).setCellRenderer(initialSyncProgressRenderer);
        ModeRenderer modeRenderer = new ModeRenderer();
        int modeIndexInModel = this.getModel().getColumnIndex(SrPairDetailsTableHeader.MODE.getColumnName());
        int modeIndexInTable = this.getTable().convertColumnIndexToView(modeIndexInModel);
        this.getTable().getColumnModel().getColumn(modeIndexInTable).setCellRenderer(modeRenderer);
        PendingPITsRenderer pitsRenderer = new PendingPITsRenderer();
        int pitsIndexInModel = this.getModel().getColumnIndex(SrPairDetailsTableHeader.PENDING_PITS.getColumnName());
        int pitsIndexInTable = this.getTable().convertColumnIndexToView(pitsIndexInModel);
        this.getTable().getColumnModel().getColumn(pitsIndexInTable).setCellRenderer(pitsRenderer);
        this.abortReplicationAction.addControllerAsListener(StatusPanel.getInstance());
        this.abortInitialSync.addControllerAsListener(StatusPanel.getInstance());
        this.endInitialSync.addControllerAsListener(StatusPanel.getInstance());
    }

    @Override
    public DeleteAction getDeleteAction() {
        return this.myDeleteAction;
    }

    @Override
    public DRPairNode[] getSelectedPairsNodes() {
        int nodeColIndx = this.getModel().getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
        int[] rows = this.getTable().getSelectedRows();
        DRPairNode[] retValues = new DRPairNode[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            retValues[i] = (DRPairNode)this.getModel().getValueAt(rows[i], nodeColIndx);
        }
        return retValues;
    }

    private SrTreeNode[] getSelectedDRElementsForActivation() {
        int nodeColIndx = this.getModel().getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
        int[] rows = this.getTable().getSelectedRows();
        SrTreeNode[] retValues = new SrTreeNode[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            DRPairNode pair = (DRPairNode)this.getModel().getValueAt(rows[i], nodeColIndx);
            retValues[i] = pair instanceof DRASyncPairNode && ((DRASyncPairNode)pair).getConsistencyGroup() instanceof ExtendedPairNode ? ((DRASyncPairNode)pair).getConsistencyGroup() : pair;
        }
        return retValues;
    }

    public AlarmAction getPropagatedAlarmsAction() {
        return this.myPropagatedAlarmsAction;
    }

    public AlarmAction getSpecificAlarmsAction() {
        return this.mySpecificAlarmsAction;
    }

    public final void startReplication() {
    }

    public DRPairNode[] getAvailableSelectedPairsForPiTs() {
        DRPairNode[] selectedNodes = this.getSelectedPairsNodes();
        ArrayList<DRPairNode> availableList = new ArrayList<DRPairNode>();
        for (int i = 0; i < selectedNodes.length; ++i) {
            boolean isActive;
            boolean bl = isActive = !DRReplicationStateConstant.INACTIVE.equals(selectedNodes[i].getReplicationState());
            if (!selectedNodes[i].getClass().equals(DRASyncPairNode.class) || !isActive) continue;
            availableList.add(selectedNodes[i]);
        }
        return availableList.toArray(new DRPairNode[availableList.size()]);
    }

    public void selectPairs(Collection<DRPairNode> pairNodesToSelect) {
        int rowCount = this.getTable().getRowCount();
        int nodeColIndx = this.getModel().getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
        HashSet<Integer> rows = new HashSet<Integer>(pairNodesToSelect.size());
        for (int i = 0; i < rowCount; ++i) {
            SrTreeNode node = (SrTreeNode)this.getTable().getModel().getValueAt(i, nodeColIndx);
            if (!(node instanceof DRPairNode) || !pairNodesToSelect.contains(node.getIdentifier())) continue;
            rows.add(i);
        }
        this.setSelectedRows(rows);
    }

    public void selectExtendedPair(ExtendedPairNode epNode) {
        int rowCount = this.getTable().getRowCount();
        int nodeColIndx = this.getModel().getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
        for (int i = 0; i < rowCount; ++i) {
            SrTreeNode node = (SrTreeNode)this.getTable().getModel().getValueAt(i, nodeColIndx);
            if (!(node instanceof ExtendedPairNode) || !node.getStub().equals(epNode.getStub())) continue;
            this.getTable().setRowSelectionInterval(i, i);
            return;
        }
    }

    private static class PendingPITsRenderer
    extends GenericTableCellRenderer {
        private PendingPITsRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Object[]) {
                Object[] args = (Object[])value;
                String[] strArgs = new String[]{String.valueOf(args[0]), String.valueOf(args[1])};
                this.setText(ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_COLUMN_PENDING_PITS_VALUE, strArgs));
            }
            int nodeIndexInModel = ((SrTableModel)table.getModel()).getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
            int nodeIndex = table.convertColumnIndexToView(nodeIndexInModel);
            DRPairNode node = (DRPairNode)table.getValueAt(row, nodeIndex);
            if (isSelected) {
                this.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
                this.setForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
            } else {
                this.setBackground(LookAndFill.TABLE_BACKGROUND);
                if (node != null && DRReplicationStateConstant.INACTIVE.equals(node.getReplicationState())) {
                    this.setForeground(LookAndFill.TABLE_INACTIVE_LINE_FOREGROUND);
                } else {
                    this.setForeground(LookAndFill.TABLE_FOREGROUND);
                }
            }
            return this;
        }
    }

    private static class ModeRenderer
    extends JPanel
    implements TableCellRenderer,
    SrTableCellTooltip {
        private SrProgressDotsPanel m_progress = new SrProgressDotsPanel(3, 2);

        ModeRenderer() {
            this.setLayout(new BorderLayout(0, 1));
            this.add((Component)this.m_progress, "Center");
        }

        @Override
        public String getTooltipText(int aRow, int aCol) {
            return this.m_progress.getText();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.m_progress.setText("");
                this.m_progress.setValue(0);
            } else if (value instanceof DRModeConstant) {
                this.m_progress.setText(value.toString());
                this.m_progress.setValue(0);
            } else {
                Object[] replicationAndProgress = (Object[])value;
                SrBITSConstant replicationState = (SrBITSConstant)replicationAndProgress[0];
                Integer progressValue = (Integer)replicationAndProgress[1];
                if (replicationState.contains(DRReplicationStateConstant.FALLBACK)) {
                    String[] args = new String[]{DRReplicationStateConstant.FALLBACK.toString()};
                    String display = ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_COLUMN_MODE_PROGRESS_VALUE, args);
                    this.m_progress.setText(display);
                } else if (replicationState.contains(DRReplicationStateConstant.PLANNED_FAILOVER)) {
                    String[] args = new String[]{DRReplicationStateConstant.PLANNED_FAILOVER.toString()};
                    String display = ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_COLUMN_MODE_PROGRESS_VALUE, args);
                    this.m_progress.setText(display);
                } else {
                    this.m_progress.setText(replicationState.toString());
                }
                this.m_progress.setValue(progressValue);
            }
            int nodeIndexInModel = ((SrTableModel)table.getModel()).getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
            int nodeIndex = table.convertColumnIndexToView(nodeIndexInModel);
            DRPairNode node = (DRPairNode)table.getValueAt(row, nodeIndex);
            if (isSelected) {
                this.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
                this.m_progress.setProgressForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
                this.setForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
            } else {
                this.setBackground(LookAndFill.TABLE_BACKGROUND);
                if (node != null && DRReplicationStateConstant.INACTIVE.equals(node.getReplicationState())) {
                    this.setForeground(LookAndFill.TABLE_INACTIVE_LINE_FOREGROUND);
                    this.m_progress.setProgressForeground(LookAndFill.TABLE_INACTIVE_LINE_FOREGROUND);
                } else {
                    this.setForeground(LookAndFill.TABLE_FOREGROUND);
                    this.m_progress.setProgressForeground(LookAndFill.TABLE_FOREGROUND);
                }
            }
            return this;
        }
    }

    static class ProgressBarRenderer
    extends JPanel
    implements TableCellRenderer,
    SrTableCellTooltip {
        private JProgressBar m_frog = new JProgressBar(0, 100);
        private SrClientLabel m_label = new SrClientLabel();

        ProgressBarRenderer() {
            this.setLayout(new BorderLayout(0, 1));
            this.m_frog.setBackground(LookAndFill.TABLE_BACKGROUND);
            this.add((Component)this.m_label, "West");
            this.add((Component)this.m_frog, "Center");
        }

        @Override
        public String getTooltipText(int aRow, int aCol) {
            return this.m_label.getText();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.m_label.setText("");
                this.m_frog.setVisible(false);
            } else {
                if (!(value instanceof Integer)) {
                    throw new ClassCastException("This renderer get only value of type Integer");
                }
                int intValue = (Integer)value;
                if (intValue < this.m_frog.getMaximum() && intValue > this.m_frog.getMinimum()) {
                    this.m_frog.setVisible(true);
                } else {
                    this.m_frog.setVisible(false);
                }
                StringBuffer sb = new StringBuffer();
                if (intValue < 100) {
                    sb.append(' ');
                }
                if (intValue < 10) {
                    sb.append(' ');
                }
                sb.append(value);
                sb.append('%');
                this.m_label.setText(sb.toString());
                this.m_frog.setValue(intValue);
            }
            int nodeIndexInModel = ((SrTableModel)table.getModel()).getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
            int nodeIndex = table.convertColumnIndexToView(nodeIndexInModel);
            DRPairNode node = (DRPairNode)table.getValueAt(row, nodeIndex);
            if (isSelected) {
                this.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
                this.m_label.setForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
                this.setForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
            } else {
                this.setBackground(LookAndFill.TABLE_BACKGROUND);
                if (node != null && DRReplicationStateConstant.INACTIVE.equals(node.getReplicationState())) {
                    this.setForeground(LookAndFill.TABLE_INACTIVE_LINE_FOREGROUND);
                    this.m_label.setForeground(LookAndFill.TABLE_INACTIVE_LINE_FOREGROUND);
                } else {
                    this.setForeground(LookAndFill.TABLE_FOREGROUND);
                    this.m_label.setForeground(LookAndFill.TABLE_FOREGROUND);
                }
            }
            return this;
        }
    }

    public static class PairTableCellRenderer
    extends GenericTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof DRPairNode) {
                DRPairNode pair = (DRPairNode)value;
                this.setText(pair.getPairType().toString());
                if (CFStateConstant.CF_WAIT.equals(pair.getControlFunctionState())) {
                    this.setIcon(SrSwingUtils.horizontallyJoinTwoIcons(ClientImageObject.DR_HOURGLASS.getImageIcon(), (ImageIcon)this.getIcon(), 1));
                }
            } else if (value instanceof ExtendedPairNode) {
                this.setText("");
                this.setIcon(null);
            }
            int nodeIndexInModel = ((SrTableModel)table.getModel()).getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
            int nodeIndex = table.convertColumnIndexToView(nodeIndexInModel);
            DRPairNode node = (DRPairNode)table.getValueAt(row, nodeIndex);
            if (isSelected) {
                this.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
                this.setForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
            } else {
                this.setBackground(LookAndFill.TABLE_BACKGROUND);
                if (node != null && DRReplicationStateConstant.INACTIVE.equals(node.getReplicationState())) {
                    this.setForeground(LookAndFill.TABLE_INACTIVE_LINE_FOREGROUND);
                } else {
                    this.setForeground(LookAndFill.TABLE_FOREGROUND);
                }
            }
            return this;
        }
    }

    private class SelectorAction
    extends SrClientAction<DRPairNode, Void> {
        public SelectorAction(View<DRPairNode> aView) {
            super(true, true, aView, SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<DRPairNode> aArg) {
            ClientLoader.getMainFrame().selectTreeNode(SrMainTreeModel.getInstance().getDRRootNode());
            SrPairDetailsTablePanel.this.selectPairs(aArg);
            return Collections.singleton(new CompleteFuture("SrPairDetailsTablePanel.SelectorAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }
}

