/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.dr.JournalTableHeader;
import com.sanrad.nms.client.data.dr.SrJournalsTableModel;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.event.dr.SrJournalSelectionEvent;
import com.sanrad.nms.client.event.dr.SrJournalSelectionListener;
import com.sanrad.nms.client.gui.DeleteItemsYesToAllDialog;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.dr.JournalVolumeTableCellRenderer;
import com.sanrad.nms.client.gui.dr.SrJournalsTablePopupMenu;
import com.sanrad.nms.client.gui.volume.dialogs.JournalVolumePropertiesDialog;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.volume.JournalVolume;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.SrTableView;
import com.sanrad.swing.actions.View;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.Timer;

public class SrJournalsTablePanel
extends SrTablePanel {
    SrEventListenerManager.Informer<SrJournalSelectionListener, SrJournalSelectionEvent> onJournalSelectionInformer = new SrEventListenerManager.Informer<SrJournalSelectionListener, SrJournalSelectionEvent>(){

        @Override
        public void inform(SrJournalSelectionListener listener, SrJournalSelectionEvent event) {
            listener.onJournalSelection(event);
        }
    };
    private static final int JOURNAL_UTILIZATION_DELAY_MILLI = 60000;
    private Timer myRefreshUtilizationTimer = new Timer(60000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SrJournalsTablePanel.this.refreshJournalsUtilization();
        }
    });
    private final View<JournalVolumeNode> myJournalNodeView = new SrTableView<JournalVolumeNode>((JTable)this.getTable()){

        @Override
        public Collection<JournalVolumeNode> getValue() {
            return Arrays.asList(SrJournalsTablePanel.this.getSelectedJournalsNodes());
        }
    };
    private final DeleteAction myDeleteAction = new DeleteAction<JournalVolumeNode>(this.myJournalNodeView, StatusPanel.getInstance(), new DeleteAction.Confirmator());
    public final SrClientAction journalPropertiesAction = new SrClientAction<JournalVolumeNode, Void>(true, true, this.myJournalNodeView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<JournalVolumeNode> arg) {
            Point prevDialogLocation = null;
            for (JournalVolumeNode node : arg) {
                JournalVolumePropertiesDialog dialog = new JournalVolumePropertiesDialog((JFrame)ClientLoader.getMainFrame(), node);
                dialog.show();
                if (prevDialogLocation != null) {
                    prevDialogLocation.x += 22;
                    prevDialogLocation.y += 22;
                    dialog.setLocation(prevDialogLocation);
                    continue;
                }
                prevDialogLocation = dialog.getLocation();
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final AlarmAction myOpenPropagatedAlarmsAction = new AlarmAction<JournalVolumeNode>(this.myJournalNodeView, false);
    public final AlarmAction myOpenSpecificAlarmsAction = new AlarmAction<JournalVolumeNode>(this.myJournalNodeView, true);

    public SrJournalsTablePanel() {
        super(SrJournalsTableModel.getInstance());
        this.hideTableColumn(this.getModel().getColumnIndex(JournalTableHeader.STUB.getColumnName()));
        this.setTablePanelCellRenderer(new JournalVolumeTableCellRenderer());
        SrJournalsTablePopupMenu popup = new SrJournalsTablePopupMenu(this);
        popup.addListener(this);
        this.setTablePopUpMenuObject(popup);
        this.setSelectionMode(2);
        this.myRefreshUtilizationTimer.start();
    }

    @Override
    protected void rowSelectionChanged(int[] rowIndices) {
        if (rowIndices != null && rowIndices.length > 0) {
            List<Object> row = this.getRow(rowIndices[0]);
            if (row != null) {
                RemoteObject stub = (RemoteObject)row.get(this.getModel().getColumnIndex(JournalTableHeader.STUB.getColumnName()));
                SrJournalSelectionEvent event = new SrJournalSelectionEvent(SystemRootNode.getInstance().getRefByStub(stub));
                this.m_listeners.fireEvent(SrJournalSelectionListener.class, event, this.onJournalSelectionInformer);
            }
        } else {
            SrJournalSelectionEvent event = new SrJournalSelectionEvent(new Object());
            this.m_listeners.fireEvent(SrJournalSelectionListener.class, event, this.onJournalSelectionInformer);
        }
    }

    public void addJournalSelectionListener(SrJournalSelectionListener l) {
        this.m_listeners.add(l);
    }

    public void removeJournalSelectionListener(SrJournalSelectionListener l) {
        this.m_listeners.remove(l);
    }

    private int getUserChoice() {
        int response;
        int rowsSelected = this.getTable().getSelectedRowCount();
        switch (rowsSelected) {
            case 0: {
                return -10;
            }
            case 1: {
                response = JOptionPane.showConfirmDialog(this, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_JOURNAL_DELETE_JOURNAL_MSG_BOX_STRING), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_JOURNAL_DELETE_JOURNALS_MSG_BOX_TITLE), 0, 3);
                break;
            }
            default: {
                String[] selectedAliases = this.getSelectedJournalsAliases();
                response = DeleteItemsYesToAllDialog.showYesToAllDialog(this, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_JOURNAL_DELETE_JOURNALS_MSG_BOX_STRING), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_JOURNAL_DELETE_JOURNALS_MSG_BOX_TITLE), rowsSelected, selectedAliases, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_JOURNAL_DELETE_ONE_JOURNAL_MSG_BOX_STRING));
            }
        }
        return response;
    }

    private String[] getSelectedJournalsAliases() {
        JournalVolumeNode[] nodes = this.getSelectedJournalsNodes();
        String[] retValues = new String[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            retValues[i] = nodes[i].getAlias();
        }
        return retValues;
    }

    private JournalVolumeNode[] getSelectedJournalsNodes() {
        int aliasCol = this.getModel().getColumnIndex(JournalTableHeader.ALIAS.getColumnName());
        int[] rows = this.getTable().getSelectedRows();
        JournalVolumeNode[] retValues = new JournalVolumeNode[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            retValues[i] = (JournalVolumeNode)this.getModel().getValueAt(rows[i], aliasCol);
        }
        return retValues;
    }

    public DeleteAction getDeleteAction() {
        return this.myDeleteAction;
    }

    private JournalVolumeNode[] getSelectedJournals() {
        int[] sel = this.getSelectedRows();
        JournalVolumeNode[] journals = new JournalVolumeNode[sel.length];
        int stubIndex = this.getModel().getColumnIndex(JournalTableHeader.STUB.getColumnName());
        for (int i = 0; i < journals.length; ++i) {
            JournalVolume journal = (JournalVolume)this.getModel().getValueAt(sel[i], stubIndex);
            journals[i] = (JournalVolumeNode)SystemRootNode.getInstance().getRefByStub(journal);
        }
        return journals;
    }

    private void refreshJournalsUtilization() {
        int aliasCol = this.getModel().getColumnIndex(JournalTableHeader.ALIAS.getColumnName());
        int i = this.getTable().getRowCount();
        while (i-- > 0) {
            VolumeManager.getInstance().refreshJournalUtilization((JournalVolumeNode)this.getModel().getValueAt(i, aliasCol));
        }
    }
}

