/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.dr.wizards.journal.SrJournalAliasAndVSwitchWizardPanel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrPercentTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.JFrame;

public class SrCreateJournalDlg
extends SrOKCancelDialog {
    private static final String SPACE = " ";
    private static final String SPACEANDCOMMA = " ;";
    private VolumeTreeNode m_selVolNode;
    private SrTextField myAliasTextField;
    private SrPercentTextField myThresholdTextField;
    private SrComboBox vSwitchCombo;

    public SrCreateJournalDlg(JFrame frm, String siteName, ClusterNode clusterNode, VolumeTreeNode volumeNode) {
        super(frm, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_DLG_TITLE_SITE) + SPACE + siteName + SPACEANDCOMMA + ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_DLG_TITLE_CLUSTER) + SPACE + clusterNode.getAlias() + SPACEANDCOMMA + ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_DLG_TITLE), clusterNode);
        this.m_selVolNode = volumeNode;
        SrJournalAliasAndVSwitchWizardPanel.JournalPropertyPanel panel = new SrJournalAliasAndVSwitchWizardPanel(clusterNode).getPropertyPanel();
        this.myAliasTextField = (SrTextField)panel.getProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_PANEL_ALIAS_KEY));
        this.myThresholdTextField = (SrPercentTextField)panel.getProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_PANEL_PERCENTAGE_THRESHOLD_KEY));
        this.vSwitchCombo = (SrComboBox)panel.getProperty(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_JOURNAL_PANEL_VSWITCH_KEY));
        this.addCenterPanel(panel);
        this.setOKAction();
        this.pack();
    }

    protected void setOKAction() {
        SrClientAction<Void, Void> myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                String alias = SrCreateJournalDlg.this.myAliasTextField.getText().trim();
                VSwitchNode vswitchNode = (VSwitchNode)SrCreateJournalDlg.this.vSwitchCombo.getSelectedItem();
                String threshold = ((String)SrCreateJournalDlg.this.myThresholdTextField.getValue()).trim();
                Set<SrFuture<Void>> retVal = Collections.singleton(VolumeManager.getInstance().createJournalVolume(alias, new Integer(threshold), SrCreateJournalDlg.this.m_selVolNode, vswitchNode));
                return retVal;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                String alias = SrCreateJournalDlg.this.myAliasTextField.getText().trim();
                if (alias.equals("")) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.CREATE_JOURNAL_ALIAS_IS_MISSING);
                }
                String threshold = ((String)SrCreateJournalDlg.this.myThresholdTextField.getValue()).trim();
                if (threshold.equals("")) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.CREATE_JOURNAL_THRESHOLD_IS_MISSING);
                }
                return null;
            }
        };
        this.myAliasTextField.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        this.myThresholdTextField.getInnerComponent().getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        this.setOKAction(myOKAction);
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void removeListeners() {
    }
}

