/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.SrMainTreeModel;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRConsistencyGroupManager;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.ExtendedPairNode;
import com.sanrad.nms.client.data.dr.SrCGPairsTableModel;
import com.sanrad.nms.client.data.dr.SrConsistencyGroupsTableHeader;
import com.sanrad.nms.client.data.dr.SrConsistencyGroupsTableModel;
import com.sanrad.nms.client.data.site.SiteManager;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.GenericTableCellRenderer;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrClientTablePanel;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteDRAction;
import com.sanrad.nms.client.gui.dr.SrConsistencyGroupPropertiesDialog;
import com.sanrad.nms.client.gui.dr.SrConsistencyGroupTablePopupMenu;
import com.sanrad.nms.client.gui.dr.pit.SrConsistencyGroupPiTsDialog;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.util.types.constants.CFStateConstant;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.SrSwingUtils;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrTableView;
import com.sanrad.swing.actions.View;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class SrConsistencyGroupsTablePanel
extends SrClientTablePanel {
    private int m_rowNodeIndex;
    private final View<ExtendedElementNode> myView = new SrTableView<ExtendedElementNode>((JTable)this.getTable()){

        @Override
        public Collection<ExtendedElementNode> getValue() {
            return Arrays.asList(SrConsistencyGroupsTablePanel.this.getSelectedNodes());
        }
    };
    private final SrClientAction abortReplicationAction = new SrClientAction<ExtendedElementNode, Void>(true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<ExtendedElementNode> arg) {
            String confirmTitle = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_ABORT_REPLICATE_CONFIRM_TITLE);
            String confirmMsg = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_ABORT_REPLICATE_CONFIRM_MSG);
            int answer = SrOptionPaneUtil.showYesNoConfirmDialog(ClientLoader.getMainFrame(), confirmMsg, confirmTitle);
            if (answer == 1) {
                return Collections.EMPTY_LIST;
            }
            ExtendedElementNode[] nodes = SrConsistencyGroupsTablePanel.this.getSelectedNodes();
            ArrayList ids = new ArrayList(nodes.length);
            for (ExtendedElementNode node : arg) {
                ids.add(node.getIdentifier());
                DRManager.getInstance().abortReplicationRequestNotify(node);
            }
            return Collections.singleton(ClientAOImpl.getInstance().abortReplicate(ids));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (ExtendedElementNode cgNode : SrConsistencyGroupsTablePanel.this.getSelectedGroupsNodes()) {
                if (!cgNode.isEmpty()) continue;
                return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_EMPTY_CG_MSG);
            }
            return null;
        }
    };
    private final DeleteAction myDeleteAction = new DeleteDRAction<ExtendedElementNode>(this.myView, (OperationController)StatusPanel.getInstance(), (DeleteAction.Confirmator)new DeleteAction.Confirmator<ExtendedElementNode>(){

        @Override
        protected String getMessage(ExtendedElementNode item) {
            return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_DELETE_CG_MSG_BOX_STRING) + item + "?";
        }

        @Override
        public String getTitle(ExtendedElementNode item) {
            return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_DELETE_CGS_MSG_BOX_TITLE);
        }
    }){

        @Override
        protected String derivedClientUpdateEnabled() {
            for (ExtendedElementNode cgNode : this.myView.getValue()) {
                if (DRReplicationStateConstant.INACTIVE.equals(cgNode.getReplicationState()) || cgNode.isEmpty()) continue;
                return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_CG_IS_ACTIVE_MSG);
            }
            return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_NON_EMPTY_CG_MSG);
        }
    };
    private final SrClientAction disasterOccurredAction = new SrClientAction<ExtendedElementNode, Void>(true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<ExtendedElementNode> arg) {
            SiteManager.getInstance().disasterOccurred(arg.toArray(new ExtendedElementNode[arg.size()]), ClientLoader.getMainFrame());
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (ExtendedElementNode cgNode : SrConsistencyGroupsTablePanel.this.getSelectedGroupsNodes()) {
                if (cgNode.isEmpty()) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_GROUP_NOT_EXISTS_ON_BOTH_CLUSTERS_MSG);
                }
                ClusterNode remoteClusterNode = cgNode.getRemoteCluster();
                if (cgNode.isPartial() && (remoteClusterNode == null || remoteClusterNode.getConnectedVSwitches().length == 0)) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_CANT_DISASTER_FAILOVER_WITHOUT_REMOTE_CONNECTED_VSWITCHES);
                }
                ClusterNode localClusterNode = cgNode.getLocalCluster();
                if (localClusterNode == null || localClusterNode.getConnectedVSwitches().length <= 0) continue;
                return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_CANT_DISASTER_FAILOVER_WITH_LOCAL_CONNECTED_VSWITCHES);
            }
            return null;
        }
    };
    public final SrClientAction plannedFailoverAction = new SrClientAction<ExtendedElementNode, Void>(true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<ExtendedElementNode> arg) {
            SiteManager.getInstance().plannedFailover(arg.toArray(new ExtendedElementNode[arg.size()]), ClientLoader.getMainFrame());
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (ExtendedElementNode cgNode : SrConsistencyGroupsTablePanel.this.getSelectedGroupsNodes()) {
                if (cgNode.isEmpty()) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_GROUP_NOT_EXISTS_ON_BOTH_CLUSTERS_MSG);
                }
                if (cgNode.isPartial() && (cgNode.getRemoteCluster() == null || cgNode.getLocalCluster() == null)) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_MISSING_SITE_MSG);
                }
                if (!DRModeConstant.NORMAL.equals(cgNode.getMode())) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_SWITCHED_MSG);
                }
                if (cgNode.getReplicationState().contains(DRReplicationStateConstant.PLANNED_FAILOVER)) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_FAILOVER_IN_PROGRESS_MSG);
                }
                for (DRASyncPairNode pair : cgNode.getPairs()) {
                    if (!DRInitialSyncStateConstant.IN_PROGRESS.equals(pair.getInitialSyncState())) continue;
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_INITIAL_SYNC_IN_PROGRESS_MSG);
                }
                if (!CFStateConstant.CF_WAIT.equals(cgNode.getControlFunctionState())) continue;
                return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_CF_IN_PROGRESS_MSG);
            }
            return null;
        }
    };
    private final SrClientAction fallbackAction = new SrClientAction<ExtendedElementNode, Void>(true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<ExtendedElementNode> arg) {
            SiteManager.getInstance().fallback(arg.toArray(new ExtendedElementNode[arg.size()]), ClientLoader.getMainFrame());
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (ExtendedElementNode cgNode : this.myView.getValue()) {
                if (cgNode.isEmpty()) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_GROUP_NOT_EXISTS_ON_BOTH_CLUSTERS_MSG);
                }
                if (cgNode.isPartial()) {
                    if (cgNode.getRemoteCluster() != null && cgNode.getLocalCluster() != null) continue;
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_MISSING_SITE_MSG);
                }
                if (!DRModeConstant.SWITCHED.equals(cgNode.getMode())) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_NOT_SWITCHED_MSG);
                }
                if (cgNode.getReplicationState().contains(DRReplicationStateConstant.FALLBACK)) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_FALLBACK_IN_PROGRESS_MSG);
                }
                for (DRASyncPairNode pair : cgNode.getPairs()) {
                    if (!DRInitialSyncStateConstant.IN_PROGRESS.equals(pair.getInitialSyncState())) continue;
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_INITIAL_SYNC_IN_PROGRESS_MSG);
                }
                if (!CFStateConstant.CF_WAIT.equals(cgNode.getControlFunctionState())) continue;
                return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_CF_IN_PROGRESS_MSG);
            }
            return null;
        }
    };
    public final SrClientAction propertiesAction = new SrClientAction<ExtendedElementNode, Void>(true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<ExtendedElementNode> arg) {
            for (final ExtendedElementNode node : arg) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SrConsistencyGroupPropertiesDialog dialog = new SrConsistencyGroupPropertiesDialog((JFrame)ClientLoader.getMainFrame(), node);
                        dialog.show();
                        Point prevDialogLocation = null;
                        if (prevDialogLocation != null) {
                            prevDialogLocation.x += 22;
                            prevDialogLocation.y += 22;
                            dialog.setLocation(prevDialogLocation);
                        } else {
                            prevDialogLocation = dialog.getLocation();
                        }
                    }
                });
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    private final SrClientAction startReplicationAction = new SrClientAction<ExtendedElementNode, Void>(true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<ExtendedElementNode> arg) {
            return DRManager.getInstance().startReplicate(arg.toArray(new ExtendedElementNode[arg.size()]), null);
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            DRConsistencyGroupManager manager = DRConsistencyGroupManager.getInstance();
            for (ExtendedElementNode cgNode : SrConsistencyGroupsTablePanel.this.getSelectedGroupsNodes()) {
                String errorMsg = manager.validateStartReplication(cgNode);
                if (errorMsg == null) continue;
                return errorMsg;
            }
            return null;
        }
    };
    public final AlarmAction myPropagatedAlarmsAction = new AlarmAction<ExtendedElementNode>(this.myView, false);
    public final AlarmAction mySpecificAlarmsAction = new AlarmAction<ExtendedElementNode>(this.myView, true);
    public final SrClientAction showPiTsAction = new SrClientAction<ExtendedElementNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_SHOW_PITS), null, true, true, this.myView, SrLicenseTreePath.GENERAL_PATH, false, false){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<ExtendedElementNode> arg) {
            Point prevDialogLocation = null;
            for (ExtendedElementNode selectedNode : arg) {
                SrConsistencyGroupPiTsDialog dialog = new SrConsistencyGroupPiTsDialog(selectedNode);
                dialog.show();
                if (prevDialogLocation != null) {
                    prevDialogLocation.x += 22;
                    prevDialogLocation.y += 22;
                    dialog.setLocation(prevDialogLocation);
                    continue;
                }
                prevDialogLocation = dialog.getLocation();
            }
            return Collections.EMPTY_SET;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };

    public SrConsistencyGroupsTablePanel() {
        super(SrConsistencyGroupsTableModel.getInstance());
        this.m_rowNodeIndex = this.getModel().getColumnIndex(SrConsistencyGroupsTableHeader.NODE.getColumnName());
        this.hideTableColumn(this.m_rowNodeIndex);
        int[] repIndeces = new int[]{this.getModel().getColumnIndex(SrConsistencyGroupsTableHeader.REPLICATION_POLICY_METHOD.getColumnName()), this.getModel().getColumnIndex(SrConsistencyGroupsTableHeader.REPLICATION_POLICY_RUN_EVERY.getColumnName())};
        this.addNewColumnGroup(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_COLUMN_REPLICATION_POLICY), repIndeces);
        TableColumn myColumn1 = this.getTable().getColumnModel().getColumn(repIndeces[0]);
        TableColumn myColumn2 = this.getTable().getColumnModel().getColumn(repIndeces[1]);
        myColumn1.setPreferredWidth(myColumn1.getPreferredWidth() - 10);
        myColumn2.setPreferredWidth(myColumn2.getPreferredWidth() - 10);
        int[] transIndeces = new int[]{this.getModel().getColumnIndex(SrConsistencyGroupsTableHeader.TRANSFER_POLICY_METHOD.getColumnName()), this.getModel().getColumnIndex(SrConsistencyGroupsTableHeader.TRANSFER_POLICY_RUN_EVERY.getColumnName())};
        this.addNewColumnGroup(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_COLUMN_TRANSFER_POLICY), transIndeces);
        this.getTable().setSelectionMode(2);
        this.startReplicationAction.addControllerAsListener(StatusPanel.getInstance());
        SrConsistencyGroupTablePopupMenu popup = new SrConsistencyGroupTablePopupMenu(this, this.showPiTsAction, this.disasterOccurredAction, this.startReplicationAction, this.abortReplicationAction, this.plannedFailoverAction, this.fallbackAction);
        this.setTablePopUpMenuObject(popup);
        CGTableCellRenderer renderer = new CGTableCellRenderer();
        this.setTablePanelCellRenderer(renderer);
        this.abortReplicationAction.addControllerAsListener(StatusPanel.getInstance());
    }

    private ExtendedElementNode getSelectedRowNode() {
        return (ExtendedElementNode)this.getModel().getRow(this.getTable().getSelectedRow()).get(this.m_rowNodeIndex);
    }

    public DeleteAction getDeleteAction() {
        return this.myDeleteAction;
    }

    private ArrayList getSelectedGroupsStub() {
        ArrayList listOfDeleteObjects = new ArrayList();
        int[] sel = this.getSelectedRows();
        if (sel != null && sel.length > 0) {
            int nodeColIndexInModel = this.getModel().getColumnIndex(SrConsistencyGroupsTableHeader.NODE.getColumnName());
            int nodeColIndx = this.m_table.convertColumnIndexToView(nodeColIndexInModel);
            for (int i = 0; i < sel.length; ++i) {
                ExtendedElementNode cgNode = (ExtendedElementNode)this.m_table.getValueAt(sel[i], nodeColIndx);
                listOfDeleteObjects.add(cgNode.getStub());
            }
        }
        return listOfDeleteObjects;
    }

    public ExtendedElementNode[] getSelectedGroupsNodes() {
        int aliasCol = this.getModel().getColumnIndex(SrConsistencyGroupsTableHeader.ALIAS.getColumnName());
        int[] rows = this.getTable().getSelectedRows();
        ExtendedElementNode[] retValues = new ExtendedElementNode[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            retValues[i] = (ExtendedElementNode)this.getModel().getValueAt(rows[i], aliasCol);
        }
        return retValues;
    }

    private ExtendedElementNode[] getSelectedNodes() {
        int nodeInx = this.getModel().getColumnIndex(SrConsistencyGroupsTableHeader.NODE.getColumnName());
        int[] selSet = this.getTable().getSelectedRows();
        ExtendedElementNode[] selectedCgs = new ExtendedElementNode[selSet.length];
        for (int i = 0; i < selSet.length; ++i) {
            selectedCgs[i] = (ExtendedElementNode)SrConsistencyGroupsTableModel.getInstance().getValueAt(selSet[i], nodeInx);
        }
        return selectedCgs;
    }

    public void showPairs() {
    }

    @Override
    protected void rowSelectionChanged(int[] rowIndices) {
        if (rowIndices != null && rowIndices.length > 0) {
            ExtendedElementNode cg = (ExtendedElementNode)this.getRow(rowIndices[0]).get(0);
            SrCGPairsTableModel.getInstance().initRows(cg);
        } else {
            SrCGPairsTableModel.getInstance().initRows(null);
        }
    }

    public SrClientAction getPropagatedAlarmsAction() {
        return this.myPropagatedAlarmsAction;
    }

    public SrClientAction getSpecificAlarmsAction() {
        return this.mySpecificAlarmsAction;
    }

    public void selectConsistencyGroups(Collection<? extends ExtendedElementNode> cgNodesToSelect) {
        int rowCount = this.getTable().getRowCount();
        int nodeColIndx = this.getModel().getColumnIndex(SrConsistencyGroupsTableHeader.NODE.getColumnName());
        HashSet<Integer> rows = new HashSet<Integer>(cgNodesToSelect.size());
        for (int i = 0; i < rowCount; ++i) {
            ExtendedElementNode node = (ExtendedElementNode)this.getTable().getModel().getValueAt(i, nodeColIndx);
            if (!cgNodesToSelect.contains(node)) continue;
            rows.add(i);
        }
        this.setSelectedRows(rows);
    }

    @Override
    protected Class getTableHeaderClass() {
        return SrConsistencyGroupsTableHeader.class;
    }

    @Override
    protected ClusterNode getClusterNode() {
        return null;
    }

    public static class CGTableCellRenderer
    extends GenericTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            GenericTableCellRenderer renderer = (GenericTableCellRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof ExtendedElementNode) {
                ExtendedElementNode cg;
                if (value instanceof ExtendedPairNode) {
                    renderer.setText("");
                    renderer.setIcon(null);
                }
                if (CFStateConstant.CF_WAIT.equals((cg = (ExtendedElementNode)value).getControlFunctionState())) {
                    this.setIcon(SrSwingUtils.horizontallyJoinTwoIcons(ClientImageObject.DR_HOURGLASS.getImageIcon(), (ImageIcon)this.getIcon(), 1));
                }
            }
            return renderer;
        }
    }

    private class SelectorAction
    extends SrClientAction<ExtendedElementNode, Void> {
        public SelectorAction(View<ExtendedElementNode> aView) {
            super(true, true, aView, SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ExtendedElementNode> aArg) {
            ClientLoader.getMainFrame().selectTreeNode((SrTreeNode)SrMainTreeModel.getInstance().getDRRootNode().getChildAt(0));
            SrConsistencyGroupsTablePanel.this.selectConsistencyGroups(aArg);
            return Collections.singleton(new CompleteFuture("SrConsistencyGroupsTablePanel.SelectorAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }
}

