/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.dr.ConsistencyGroupNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.MergePolicyNode;
import com.sanrad.nms.client.data.dr.TransferPolicyNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.dr.SrASyncPairPropertiesPanel;
import com.sanrad.nms.client.gui.dr.SrReplicationPropertiesPanel;
import com.sanrad.nms.client.gui.dr.wizards.SrPolicyParamsPanel;
import com.sanrad.nms.server.util.types.constants.PolicyTypeConstant;
import com.sanrad.swing.SrPropertyPanel;
import com.sanrad.swing.components.SrComponent;
import com.sanrad.swing.components.SrEnterTimeField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.components.SrWidget;
import java.awt.GridBagConstraints;
import javax.swing.BorderFactory;

public class SrConsistencyGrouprPropertiesPanel
extends SrPropertyPanel {
    public static final String KEY_CONSISTENCY_GROUP_PANEL_NAME = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CONSISTENCY_GROUP_PROPERTIES_PANEL_NAME);
    public static final String KEY_CONSISTENCY_GROUP_ALIAS_KEY = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CONSISTENCY_GROUP_PROPERTIES_ALIAS_KEY);
    public static final String KEY_CONSISTENCY_GROUP_PRIMARY_SITE_KEY = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CONSISTENCY_GROUP_PROPERTIES_PRIMARY_SITE_KEY);
    public static final String KEY_CONSISTENCY_GROUP_SECONDARY_SITE_KEY = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CONSISTENCY_GROUP_PROPERTIES_SECONDARY_SITE_KEY);
    public static final String KEY_CONSISTENCY_GROUP_NUM_OF_PAIR_KEY = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CONSISTENCY_GROUP_PROPERTIES_NUM_OF_PAIR_KEY);
    public static final String KEY_CONSISTENCY_GROUP_INITIAL_SYNC_KEY = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CONSISTENCY_GROUP_PROPERTIES_NITIAL_SYNC_KEY);
    public static final String KEY_CONSISTENCY_GROUP_GROUP_STATE_KEY = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CONSISTENCY_GROUP_PROPERTIES_GROUP_STATE_KEY);
    public static final String KEY_CONSISTENCY_GROUP_GROUP_MODE_KEY = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CONSISTENCY_GROUP_PROPERTIES_GROUP_MODE_KEY);
    private static final String LABEL_TRANFER_PANEL = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CONSISTENCY_GROUP_PROPERTIES_TRANSFER_TITLE_KEY);
    private static final String LABEL_TRANFER_POLICY = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_EXTENDED_PAIR_PROPERTIES_REPLICATION_POLICY_KEY);
    private static final String KEY_TRANFER_POLICY = LABEL_TRANFER_PANEL + "__" + LABEL_TRANFER_POLICY;
    private static final String LABEL_TRANFER_RUNEVERY = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_EXTENDED_PAIR_PROPERTIES_REPLICATION_PERIOD_KEY);
    private static final String KEY_TRANFER_RUNEVERY = LABEL_TRANFER_PANEL + "__" + LABEL_TRANFER_RUNEVERY;
    private static final String LABEL_TRANFER_STARTAT_DATE_KEY = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_EXTENDED_PAIR_PROPERTIES_REPLICATION_STARTING_REPLICATION_AT_KEY);
    private static final String KEY_TRANFER_STARTAT_DATE_KEY = LABEL_TRANFER_PANEL + "__" + LABEL_TRANFER_STARTAT_DATE_KEY;
    private static final String LABEL_MERGE_PANEL = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CONSISTENCY_GROUP_PROPERTIES_MERGE_TITLE_KEY);
    private static final String LABEL_MERGE_TYPE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_EXTENDED_PAIR_PROPERTIES_REPLICATION_TYPE_KEY);
    private static final String KEY_MERGE_TYPE = LABEL_MERGE_PANEL + "__" + LABEL_MERGE_TYPE;
    private ExtendedElementNode m_cgNode;
    private SrReplicationPropertiesPanel replicationPanel;
    private SrPropertyPanel transferPanel;

    public SrConsistencyGrouprPropertiesPanel(ExtendedElementNode cgNode) {
        super(KEY_CONSISTENCY_GROUP_PANEL_NAME);
        this.m_cgNode = cgNode;
        this.initComponents();
        this.updateFields();
    }

    private void initComponents() {
        if (this.m_cgNode instanceof ConsistencyGroupNode) {
            this.addProperty(KEY_CONSISTENCY_GROUP_ALIAS_KEY, new SrWidget(KEY_CONSISTENCY_GROUP_ALIAS_KEY, new SrTextField(((ConsistencyGroupNode)this.m_cgNode).getAlias()), true, false, true, true, null));
        }
        this.addProperty(KEY_CONSISTENCY_GROUP_PRIMARY_SITE_KEY, SrWidget.getReadOnlyWidget(KEY_CONSISTENCY_GROUP_PRIMARY_SITE_KEY, new SrTextField()));
        this.addProperty(KEY_CONSISTENCY_GROUP_SECONDARY_SITE_KEY, SrWidget.getReadOnlyWidget(KEY_CONSISTENCY_GROUP_SECONDARY_SITE_KEY, new SrTextField()));
        this.addProperty(KEY_CONSISTENCY_GROUP_NUM_OF_PAIR_KEY, SrWidget.getReadOnlyWidget(KEY_CONSISTENCY_GROUP_NUM_OF_PAIR_KEY, new SrTextField()));
        this.addProperty(KEY_CONSISTENCY_GROUP_INITIAL_SYNC_KEY, SrWidget.getReadOnlyWidget(KEY_CONSISTENCY_GROUP_INITIAL_SYNC_KEY, new SrTextField()));
        this.addProperty(KEY_CONSISTENCY_GROUP_GROUP_STATE_KEY, SrWidget.getReadOnlyWidget(KEY_CONSISTENCY_GROUP_GROUP_STATE_KEY, new SrTextField()));
        this.addProperty(KEY_CONSISTENCY_GROUP_GROUP_MODE_KEY, SrWidget.getReadOnlyWidget(KEY_CONSISTENCY_GROUP_GROUP_MODE_KEY, new SrTextField()));
        GridBagConstraints panelsConstraints = new GridBagConstraints();
        panelsConstraints.gridx = 0;
        panelsConstraints.gridy = 7;
        panelsConstraints.gridwidth = 3;
        panelsConstraints.gridheight = 2;
        this.replicationPanel = new SrReplicationPropertiesPanel();
        this.replicationPanel.setBorder(BorderFactory.createTitledBorder(SrASyncPairPropertiesPanel.KEY_REPLICATION));
        this.addPropertyPanel(this.replicationPanel, true, panelsConstraints);
        panelsConstraints.gridx = 3;
        panelsConstraints.gridy = 7;
        panelsConstraints.gridwidth = 1;
        panelsConstraints.gridheight = 1;
        this.transferPanel = new SrPropertyPanel(LABEL_TRANFER_PANEL);
        this.transferPanel.addProperty(LABEL_TRANFER_POLICY, SrWidget.getReadOnlyWidget(LABEL_TRANFER_POLICY, new SrTextField()));
        this.transferPanel.addProperty(LABEL_TRANFER_RUNEVERY, (SrComponent)new SrEnterTimeField());
        SrWidget startatLabel = this.transferPanel.createLabelWidget(LABEL_TRANFER_STARTAT_DATE_KEY);
        startatLabel.getConstraints().anchor = 18;
        startatLabel.getConstraints().fill = 0;
        this.transferPanel.addProperty(startatLabel, new SrWidget("", new SrPolicyParamsPanel.SrPolicyStartAtPanel()));
        this.transferPanel.setBorder(BorderFactory.createTitledBorder(LABEL_TRANFER_PANEL));
        this.addPropertyPanel(this.transferPanel, true, panelsConstraints);
        panelsConstraints.gridx = 3;
        panelsConstraints.gridy = 8;
        SrPropertyPanel mergePanel = new SrPropertyPanel(LABEL_MERGE_PANEL);
        mergePanel.addProperty(LABEL_MERGE_TYPE, SrWidget.getReadOnlyWidget(LABEL_MERGE_TYPE, new SrTextField()));
        mergePanel.setBorder(BorderFactory.createTitledBorder(LABEL_MERGE_PANEL));
        this.addPropertyPanel(mergePanel, true, panelsConstraints);
    }

    public void updateFields() {
        MergePolicyNode mergeNode;
        DRASyncPairNode[] pairs;
        if (this.m_cgNode instanceof ConsistencyGroupNode) {
            this.setPropertyValue(KEY_CONSISTENCY_GROUP_ALIAS_KEY, ((ConsistencyGroupNode)this.m_cgNode).getAlias());
        }
        if ((pairs = this.m_cgNode.getPairs()).length > 0) {
            this.setPropertyValue(KEY_CONSISTENCY_GROUP_PRIMARY_SITE_KEY, pairs[0].getPairPrimarySite());
            this.setPropertyValue(KEY_CONSISTENCY_GROUP_SECONDARY_SITE_KEY, pairs[0].getPairSecondarySite());
        } else {
            this.setPropertyValue(KEY_CONSISTENCY_GROUP_PRIMARY_SITE_KEY, null);
            this.setPropertyValue(KEY_CONSISTENCY_GROUP_SECONDARY_SITE_KEY, null);
        }
        this.setPropertyValue(KEY_CONSISTENCY_GROUP_NUM_OF_PAIR_KEY, new Integer(pairs.length));
        this.setPropertyValue(KEY_CONSISTENCY_GROUP_INITIAL_SYNC_KEY, this.m_cgNode.getInitialSyncState());
        this.setPropertyValue(KEY_CONSISTENCY_GROUP_GROUP_STATE_KEY, this.m_cgNode.getState());
        this.setPropertyValue(KEY_CONSISTENCY_GROUP_GROUP_MODE_KEY, this.m_cgNode.getMode());
        this.replicationPanel.updateFields(this.m_cgNode);
        TransferPolicyNode transferNode = this.m_cgNode.getTransferPolicy();
        if (transferNode != null) {
            this.setPropertyValue(KEY_TRANFER_POLICY, transferNode.getPolicyType());
            this.setPropertyValue(KEY_TRANFER_RUNEVERY, new Long(transferNode.getRunEvery()));
            this.setPropertyValue(KEY_TRANFER_STARTAT_DATE_KEY, new Long(transferNode.getStartAtDateAndTime()));
        }
        if ((mergeNode = this.m_cgNode.getMergePolicy()) != null) {
            this.setPropertyValue(KEY_MERGE_TYPE, mergeNode.getPolicyType());
        }
    }

    public ExtendedElementNode getConsistencyGroupNode() {
        return this.m_cgNode;
    }

    public PolicyTypeConstant getReplicationPolicyType() {
        return this.m_cgNode.getReplicationPolicy().getPolicyType();
    }

    public Long getReplicationRunEvery() {
        return this.replicationPanel.getReplicationRunEvery();
    }

    public Long getReplicationStartAt() {
        return this.replicationPanel.getReplicationStartAt();
    }

    public PolicyTypeConstant getTransferPolicyType() {
        return this.m_cgNode.getTransferPolicy().getPolicyType();
    }

    public Long getTransferRunEvery() {
        return new Long(((SrEnterTimeField)this.getProperty(KEY_TRANFER_RUNEVERY)).getTimeMinutes());
    }

    public Long getTransferStartAt() {
        return (Long)this.getPropertyVal(KEY_TRANFER_STARTAT_DATE_KEY);
    }

    public PolicyTypeConstant getMergePolicyType() {
        return this.m_cgNode.getMergePolicy().getPolicyType();
    }

    public String getAlias() {
        return (String)this.getPropertyVal(KEY_CONSISTENCY_GROUP_ALIAS_KEY);
    }
}

