/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.dr.ConsistencyGroupNode;
import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRConsistencyGroupManager;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.site.SiteManager;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.event.dr.DRAsyncPairEvent;
import com.sanrad.nms.client.event.dr.DRAsyncPairListener;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupEvent;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupListener;
import com.sanrad.nms.client.event.dr.DREvent;
import com.sanrad.nms.client.event.dr.DRListener;
import com.sanrad.nms.client.event.site.SiteEvent;
import com.sanrad.nms.client.event.site.SiteListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.dr.SrConsistencyGrouprPropertiesPanel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.util.types.constants.PolicyTypeConstant;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.StatusPanel;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JFrame;

public class SrConsistencyGroupPropertiesDialog
extends SrOKCancelDialog
implements DRConsistencyGroupListener,
SiteListener,
DRAsyncPairListener,
DRListener {
    private SrConsistencyGrouprPropertiesPanel myPropertiesPanel;

    public SrConsistencyGroupPropertiesDialog(JFrame frm, ExtendedElementNode cg) {
        super(frm, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CONSISTENCY_GROUP_PROPERTIES_DIALOG_TITLE), false);
        this.myPropertiesPanel = new SrConsistencyGrouprPropertiesPanel(cg);
        this.addCenterPanel(this.myPropertiesPanel);
        this.setOKAction();
        this.pack();
    }

    @Override
    public void addListeners() {
        DRConsistencyGroupManager.getInstance().addDRConsistencyGroupListener(this);
        SiteManager.getInstance().addSiteListener(this);
        DRASyncPairManager.getInstance().addDRAsyncPairListener(this);
        DRManager.getInstance().addDRListener(this);
    }

    @Override
    public void removeListeners() {
        DRConsistencyGroupManager.getInstance().removeDRConsistencyGroupListener(this);
        SiteManager.getInstance().removeSiteListener(this);
        DRASyncPairManager.getInstance().removeDRAsyncPairListener(this);
        DRManager.getInstance().removeDRListener(this);
    }

    protected void setOKAction() {
        SrClientAction<Void, Void> myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                return Collections.singleton(SrConsistencyGroupPropertiesDialog.this.changeGroupProperties());
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                return null;
            }
        };
        this.setOKAction(myOKAction);
    }

    private SrFuture<Void> changeGroupProperties() {
        HashMap<ClientParameterCode, Object> params = new HashMap<ClientParameterCode, Object>();
        ExtendedElementNode cgNode = this.myPropertiesPanel.getConsistencyGroupNode();
        if (cgNode instanceof ConsistencyGroupNode && !((ConsistencyGroupNode)cgNode).getAlias().equals(this.myPropertiesPanel.getAlias())) {
            params.put(ClientParameterCode.DR_CONSISTENCY_GROUP_ALIAS, this.myPropertiesPanel.getAlias());
        }
        if (this.myPropertiesPanel.getReplicationRunEvery().longValue() != cgNode.getReplicationPolicy().getRunEvery() || this.myPropertiesPanel.getReplicationStartAt().longValue() != cgNode.getReplicationPolicy().getStartAtDateAndTime()) {
            if (this.myPropertiesPanel.getReplicationRunEvery() <= 0L) {
                return new FailedFuture<Void>(new IllegalValueException("Replication period interval should be bigger than 0"), "SrConsistencyGroupPropertiesDialog.OKAction, replicationInterval<=0");
            }
            params.put(ClientParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_POLICY, this.createPolicyHashMap(this.myPropertiesPanel.getReplicationRunEvery(), this.myPropertiesPanel.getReplicationStartAt(), this.myPropertiesPanel.getReplicationPolicyType()));
        }
        if (this.myPropertiesPanel.getTransferRunEvery().longValue() != cgNode.getTransferPolicy().getRunEvery() || this.myPropertiesPanel.getTransferStartAt().longValue() != cgNode.getTransferPolicy().getStartAtDateAndTime()) {
            if (this.myPropertiesPanel.getTransferRunEvery() <= 0L) {
                return new FailedFuture<Void>(new IllegalValueException("Transfer period interval should be bigger than 0"), "SrConsistencyGroupPropertiesDialog.OKAction, transferInterval<=0");
            }
            params.put(ClientParameterCode.DR_CONSISTENCY_GROUP_TRANSFER_POLICY, this.createPolicyHashMap(this.myPropertiesPanel.getTransferRunEvery(), this.myPropertiesPanel.getTransferStartAt(), this.myPropertiesPanel.getTransferPolicyType()));
        }
        if (!params.isEmpty()) {
            return ClientAOImpl.getInstance().changeElements(Collections.singleton(this.myPropertiesPanel.getConsistencyGroupNode().getIdentifier()), params);
        }
        return new CompleteFuture<Void>("SrConsistencyGroupPropertiesDialog.changeGroupProperties()");
    }

    private HashMap createPolicyHashMap(Long runEvery, Long startAt, PolicyTypeConstant type) {
        HashMap<ClientParameterCode, Serializable> policies = new HashMap<ClientParameterCode, Serializable>();
        policies.put(ClientParameterCode.DR_POLICY_METHOD, type);
        policies.put(ClientParameterCode.DR_POLICY_RUN_EVERY, runEvery);
        policies.put(ClientParameterCode.DR_POLICY_START_AT_DATE_AND_TIME, startAt);
        return policies;
    }

    @Override
    public void consistencyGroupAliasChanged(DRConsistencyGroupEvent e) {
    }

    @Override
    public void consistencyGroupCreated(DRConsistencyGroupEvent e) {
    }

    @Override
    public void consistencyGroupRemoved(DRConsistencyGroupEvent e) {
        ExtendedElementNode myNode;
        ExtendedElementNode eventNode = e.getExtendedElementNode();
        if (eventNode == (myNode = this.myPropertiesPanel.getConsistencyGroupNode())) {
            String[] args = new String[]{myNode.toString()};
            String msg = ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_CONSISTENCY_GROUP_PROPERTIES_CG_DELETED_MSG, args);
            String title = ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_CONSISTENCY_GROUP_PROPERTIES_CG_DELETED_MSG_TITLE, args);
            SrOptionPaneUtil.showErrorMsg(this, msg, title);
            this.dispose();
        }
    }

    @Override
    public void consistencyGroupChanged(DRConsistencyGroupEvent e) {
    }

    @Override
    public void siteCreated(SiteEvent event) {
    }

    @Override
    public void sitePropertiesChanged(SiteEvent event) {
        ExtendedElementNode myNode = this.myPropertiesPanel.getConsistencyGroupNode();
        DRASyncPairNode[] pairs = myNode.getPairs();
        if (pairs.length > 0) {
            SiteNode site = event.getSiteNode();
            if (pairs[0].getPairPrimarySite() == site || pairs[0].getPairSecondarySite() == site) {
                this.myPropertiesPanel.updateFields();
            }
        }
    }

    @Override
    public void siteRemoved(SiteEvent event) {
    }

    @Override
    public void siteStatusChanged(SiteEvent event) {
    }

    @Override
    public void asyncPairChanged(DRAsyncPairEvent e) {
    }

    @Override
    public void asyncPairCreated(DRAsyncPairEvent e) {
    }

    @Override
    public void asyncPairRemoved(DRAsyncPairEvent e) {
    }

    public void success() {
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
        this.dispose();
    }

    @Override
    public void drDiscoveryStarted(DREvent e) {
        String msg = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_DR_DISCOVERY_START_ERROR_MSG);
        String title = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_DR_DISCOVERY_START_ERROR_TITLE);
        SrOptionPaneUtil.showErrorMsg(this, msg, title);
        this.dispose();
    }

    @Override
    public void drDiscoveryCompleted(DREvent e) {
    }

    @Override
    public void doOnCancel() {
    }
}

