/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.SrCGPairsTableHeader;
import com.sanrad.nms.client.data.dr.SrCGPairsTableModel;
import com.sanrad.nms.client.gui.GenericTableCellRenderer;
import com.sanrad.nms.client.gui.SrClientTablePanel;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteDRAction;
import com.sanrad.nms.client.gui.dr.SrASyncPairPropertiesDialog;
import com.sanrad.nms.client.gui.dr.SrPairActions;
import com.sanrad.nms.client.gui.dr.pit.SrPairPiTTableDialog;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrTableModel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.SrTableView;
import com.sanrad.swing.actions.View;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JFrame;
import javax.swing.JTable;

public class SrCGPairsTablePanel
extends SrClientTablePanel
implements SrPairActions {
    private final View<DRPairNode> myView = new SrTableView<DRPairNode>((JTable)this.getTable()){

        @Override
        public Collection<DRPairNode> getValue() {
            return Arrays.asList(SrCGPairsTablePanel.this.getSelectedPairsNodes());
        }
    };
    private final DeleteAction myDeleteAction = new DeleteDRAction<DRPairNode>(this.myView, StatusPanel.getInstance(), new DeleteAction.Confirmator());
    public final AlarmAction myPropagatedAlarmsAction = new AlarmAction<DRPairNode>(this.myView, false);
    public final AlarmAction mySpecificAlarms = new AlarmAction<DRPairNode>(this.myView, true);
    public final SrClientAction showPiTsAction = new SrClientAction<DRPairNode, Void>("", null, true, true, this.myView, SrLicenseTreePath.GENERAL_PATH, false, false){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<DRPairNode> arg) {
            Point prevDialogLocation = null;
            for (DRPairNode selectedNode : arg) {
                SrPairPiTTableDialog dialog = new SrPairPiTTableDialog((DRASyncPairNode)selectedNode);
                dialog.show();
                if (prevDialogLocation != null) {
                    prevDialogLocation.x += 22;
                    prevDialogLocation.y += 22;
                    dialog.setLocation(prevDialogLocation);
                    continue;
                }
                prevDialogLocation = dialog.getLocation();
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };

    public SrCGPairsTablePanel() {
        super(SrCGPairsTableModel.getInstance());
        this.hideTableColumn(SrCGPairsTableHeader.NODE.getColumnName());
        this.getTable().setSelectionMode(2);
        SrCGPairsTableRenderer renderer = new SrCGPairsTableRenderer();
        this.setTablePanelCellRenderer(renderer);
    }

    @Override
    public DeleteAction getDeleteAction() {
        return this.myDeleteAction;
    }

    public void properties() {
        DRPairNode[] selectedNodes = this.getSelectedPairsNodes();
        Point prevDialogLocation = null;
        for (int i = 0; i < selectedNodes.length; ++i) {
            SrASyncPairPropertiesDialog dialog = new SrASyncPairPropertiesDialog((JFrame)ClientLoader.getMainFrame(), selectedNodes[i]);
            dialog.show();
            if (prevDialogLocation != null) {
                prevDialogLocation.x += 22;
                prevDialogLocation.y += 22;
                dialog.setLocation(prevDialogLocation);
                continue;
            }
            prevDialogLocation = dialog.getLocation();
        }
    }

    public SrClientAction getPropagatedAlarmsAction() {
        return this.myPropagatedAlarmsAction;
    }

    public SrClientAction getSpecificAlarmsAction() {
        return this.mySpecificAlarms;
    }

    public void startInitialSync() {
        DRPairNode[] nodes = this.getSelectedPairsNodes();
        ArrayList<String> ids = new ArrayList<String>(nodes.length);
        for (DRPairNode node : nodes) {
            ids.add((String)node.getIdentifier());
        }
        SrClientAction.blockActions(Collections.singleton(ClientAOImpl.getInstance().startInitialSync(ids)), StatusPanel.getInstance());
    }

    public void endInitialSync() {
        ArrayList<String> ids = new ArrayList<String>();
        for (DRPairNode node : this.getSelectedPairsNodes()) {
            ids.add((String)node.getIdentifier());
        }
        SrClientAction.blockActions(Collections.singleton(ClientAOImpl.getInstance().endInitialSync(ids)), StatusPanel.getInstance());
    }

    public void abortInitialSync() {
        ArrayList<String> ids = new ArrayList<String>();
        for (DRPairNode node : this.getSelectedPairsNodes()) {
            ids.add((String)node.getIdentifier());
        }
        SrClientAction.blockActions(Collections.singleton(ClientAOImpl.getInstance().abortInitialSync(ids)), StatusPanel.getInstance());
    }

    public void abortReplication() {
    }

    public void disasterOccurred() {
    }

    public void fallback() {
    }

    public void plannedFailover() {
    }

    public void startReplication() {
    }

    @Override
    public DRPairNode[] getSelectedPairsNodes() {
        ArrayList<DRPairNode> list = new ArrayList<DRPairNode>();
        int[] sel = this.getSelectedRows();
        int nodeColIndx = this.getModel().getColumnIndex(SrCGPairsTableHeader.NODE.getColumnName());
        for (int i = 0; i < sel.length; ++i) {
            DRPairNode pairNode = (DRPairNode)this.getModel().getValueAt(sel[i], nodeColIndx);
            list.add(pairNode);
        }
        DRPairNode[] nodes = new DRPairNode[list.size()];
        return list.toArray(nodes);
    }

    public void showCGParentPiTs() {
    }

    @Override
    protected Class getTableHeaderClass() {
        return SrCGPairsTableHeader.class;
    }

    @Override
    protected ClusterNode getClusterNode() {
        return null;
    }

    private static class SrCGPairsTableRenderer
    extends GenericTableCellRenderer {
        private SrCGPairsTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int nodeIndexInModel = ((SrTableModel)table.getModel()).getColumnIndex(SrCGPairsTableHeader.NODE.getColumnName());
            int nodeIndex = table.convertColumnIndexToView(nodeIndexInModel);
            DRPairNode node = (DRPairNode)table.getValueAt(row, nodeIndex);
            if (DRReplicationStateConstant.INACTIVE.equals(node.getReplicationState())) {
                this.setForeground(LookAndFill.TABLE_INACTIVE_LINE_FOREGROUND);
            } else if (isSelected) {
                this.setForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
            } else {
                this.setForeground(LookAndFill.TABLE_FOREGROUND);
            }
            if (isSelected) {
                this.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
            } else {
                this.setBackground(LookAndFill.TABLE_BACKGROUND);
            }
            return this;
        }
    }
}

