/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.dr;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.site.SiteManager;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.dr.DRAsyncPairEvent;
import com.sanrad.nms.client.event.dr.DRAsyncPairListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.dr.SrASyncPairPropertiesPanel;
import com.sanrad.nms.client.gui.dr.SrSyncPairPropertiesDialog;
import com.sanrad.nms.client.gui.dr.wizards.SrMsgAndGoWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.snapshot.SnapshotWizardContextKeys;
import com.sanrad.nms.client.gui.dr.wizards.snapshot.SrPreSnapshotWizardPanel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.wizard.SrConfirmWizardPanel;
import com.sanrad.swing.wizard.SrHiddenWizardPanel;
import com.sanrad.swing.wizard.SrWizardFrame;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SrASyncPairPropertiesDialog
extends SrSyncPairPropertiesDialog
implements DRAsyncPairListener {
    private SnapshotVolumeNode m_primarySnapshotFromWizard = null;
    private SnapshotVolumeNode m_secondarySnapshotFromWizard = null;
    private SrWizardFrame m_createSnapshotWiz = null;
    private static final String m_endMessage = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_SNAPSHOT_WIZARD_END_MSG);
    private static final String m_openMessage = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_SNAPSHOT_WIZARD_OPENING_MSG);
    private static final String m_cancelMessage = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_SNAPSHOT_WIZARD_CANCEL_MSG);
    private static final String m_wizTitle = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_SNAPSHOT_WIZARD_TITLE);
    private SrASyncPairPropertiesPanel myPropertiesPanel;

    public SrASyncPairPropertiesDialog(JFrame frm, DRPairNode pair) {
        super(frm, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_ASYNC_PAIR_PROPERTIES_DIALOG_TITLE), pair);
        this.myPropertiesPanel = new SrASyncPairPropertiesPanel(pair);
        this.addCenterPanel(this.myPropertiesPanel);
        this.setOKAction();
        this.pack();
    }

    @Override
    public void addListeners() {
        DRASyncPairManager.getInstance().addDRAsyncPairListener(this);
        SiteManager.getInstance().addSiteListener(this);
        DRManager.getInstance().addDRListener(this);
    }

    @Override
    public void removeListeners() {
        DRASyncPairManager.getInstance().removeDRAsyncPairListener(this);
        SiteManager.getInstance().removeSiteListener(this);
        DRManager.getInstance().removeDRListener(this);
    }

    @Override
    protected void setOKAction() {
        SrClientAction<Void, Void> myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                return SrASyncPairPropertiesDialog.this.changePairProperties();
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                return null;
            }
        };
        this.setOKAction(myOKAction);
    }

    private Collection<SrFuture<Void>> changePairProperties() {
        HashMap<ClientParameterCode, DRPairInitialSyncTypeConstant> changedParams = new HashMap<ClientParameterCode, DRPairInitialSyncTypeConstant>();
        DRPairInitialSyncTypeConstant newInitialSyncType = this.myPropertiesPanel.getInitialSyncType();
        if (newInitialSyncType != null && !newInitialSyncType.equals(this.m_pair.getInitialSyncType())) {
            changedParams.put(ClientParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, newInitialSyncType);
            if (DRPairInitialSyncTypeConstant.NONE.equals(this.m_pair.getInitialSyncType())) {
                if (this.m_primarySnapshotFromWizard == null && this.m_secondarySnapshotFromWizard == null) {
                    this.initSnapshotWizard();
                    this.setWaitCursor();
                    this.m_createSnapshotWiz.runWizard();
                    return Collections.EMPTY_LIST;
                }
                if (this.m_primarySnapshotFromWizard != null) {
                    changedParams.put(ClientParameterCode.DR_ASYNC_PAIR_PRIMARY_SNAPSHOT_VOLUME, (DRPairInitialSyncTypeConstant)this.m_primarySnapshotFromWizard.getIdentifier());
                }
                if (this.m_secondarySnapshotFromWizard != null) {
                    changedParams.put(ClientParameterCode.DR_ASYNC_PAIR_SECONDARY_SNAPSHOT_VOLUME, (DRPairInitialSyncTypeConstant)this.m_secondarySnapshotFromWizard.getIdentifier());
                }
            }
        }
        if (!changedParams.isEmpty()) {
            return Collections.singleton(ClientAOImpl.getInstance().changeElements(Collections.singleton(this.m_pair.getIdentifier()), changedParams));
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void asyncPairCreated(DRAsyncPairEvent e) {
    }

    @Override
    public void asyncPairRemoved(DRAsyncPairEvent e) {
        if (e.getPair() == this.m_pair) {
            String msg = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_PAIR_WAS_DELETED_MSG);
            String title = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_PAIR_WAS_DELETED_MSG_TITLE);
            JOptionPane.showMessageDialog(this, msg, title, 0);
            this.dispose();
        }
    }

    @Override
    public void asyncPairChanged(DRAsyncPairEvent e) {
    }

    private void initSnapshotWizard() {
        this.m_createSnapshotWiz = new SrWizardFrame(null, m_wizTitle, new SnapshotStartWizardPanel()){

            @Override
            protected String getClosingMessage() {
                return m_cancelMessage;
            }

            @Override
            protected String getFinishMessage() {
                return null;
            }
        };
        this.m_createSnapshotWiz.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SrASyncPairPropertiesDialog.this.setDefaultCursor();
                SrASyncPairPropertiesDialog.this.m_primarySnapshotFromWizard = null;
                SrASyncPairPropertiesDialog.this.m_secondarySnapshotFromWizard = null;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                SrASyncPairPropertiesDialog.this.setDefaultCursor();
                SrASyncPairPropertiesDialog.this.m_primarySnapshotFromWizard = null;
                SrASyncPairPropertiesDialog.this.m_secondarySnapshotFromWizard = null;
            }
        });
    }

    private class SnapshotFinishWizardPanel
    extends SrMsgAndGoWizardPanel {
        SnapshotFinishWizardPanel() {
            super(m_endMessage);
        }

        @Override
        public boolean canFinish() {
            return true;
        }

        @Override
        public void display() {
            this.setBackButtonEnabled(false);
            this.setNextButtonEnabled(false);
            this.setCancelButtonEnabled(true);
        }

        @Override
        public void finish() {
            SrASyncPairPropertiesDialog.this.changePairProperties();
        }

        @Override
        public boolean validateFinish(List list) {
            return true;
        }
    }

    private class AfterSecSnapshotCreationWizardPanel
    extends SrHiddenWizardPanel {
        private AfterSecSnapshotCreationWizardPanel() {
        }

        @Override
        public WizardPanel next() {
            SrASyncPairPropertiesDialog.this.m_secondarySnapshotFromWizard = (SnapshotVolumeNode)this.wizardContext.getAttribute(SnapshotWizardContextKeys.CREATED_SNAPSHOT);
            this.wizardContext.setAttribute(SnapshotWizardContextKeys.CREATED_SNAPSHOT, null, this);
            VolumeTreeNode priVolume = SrASyncPairPropertiesDialog.this.m_pair.getPairPrimaryVolume();
            if (priVolume != null && DRModeConstant.SWITCHED.equals(SrASyncPairPropertiesDialog.this.m_pair.getMode())) {
                return new PreNextSnapshotWizardPanel();
            }
            return new SnapshotFinishWizardPanel();
        }

        @Override
        public void removeListeners() {
        }
    }

    private class AfterPrimSnapshotCreationWizardPanel
    extends SrHiddenWizardPanel {
        private AfterPrimSnapshotCreationWizardPanel() {
        }

        @Override
        public WizardPanel next() {
            SrASyncPairPropertiesDialog.this.m_primarySnapshotFromWizard = (SnapshotVolumeNode)this.wizardContext.getAttribute(SnapshotWizardContextKeys.CREATED_SNAPSHOT);
            this.wizardContext.setAttribute(SnapshotWizardContextKeys.CREATED_SNAPSHOT, null, this);
            VolumeTreeNode secondaryVolume = SrASyncPairPropertiesDialog.this.m_pair.getPairSecondaryVolume();
            if (secondaryVolume != null && DRModeConstant.NORMAL.equals(SrASyncPairPropertiesDialog.this.m_pair.getMode())) {
                return new PreNextSnapshotWizardPanel();
            }
            return new SnapshotFinishWizardPanel();
        }

        @Override
        public void removeListeners() {
        }
    }

    private class PreNextSnapshotWizardPanel
    extends SrConfirmWizardPanel {
        private PreNextSnapshotWizardPanel() {
        }

        @Override
        public WizardPanel next() {
            if (this.isConfirmed()) {
                if (DRModeConstant.NORMAL.equals(SrASyncPairPropertiesDialog.this.m_pair.getMode())) {
                    VolumeTreeNode secondaryVolume = SrASyncPairPropertiesDialog.this.m_pair.getPairSecondaryVolume();
                    this.wizardContext.setAttribute(SnapshotWizardContextKeys.NEXT_OUTER_WIZARD_PANEL, new AfterSecSnapshotCreationWizardPanel(), this);
                    this.wizardContext.setAttribute(SnapshotWizardContextKeys.PARAMS_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_SECONDARY_SNAPSHOT_PARAMS_DESC), this);
                    this.wizardContext.setAttribute(SnapshotWizardContextKeys.SELECT_SNAPSHOT_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_SECONDARY_SNAPSHOT_SELECT_DESC), this);
                    this.wizardContext.setAttribute(SnapshotWizardContextKeys.CREATE_VOLUME_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_SECONDARY_SNAPSHOT_CREATE_VOLUME_DESC), this);
                    this.wizardContext.setAttribute(SnapshotWizardContextKeys.CREATE_VOLUME_NO_RESOURCE_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_SECONDARY_SNAPSHOT_CREATE_VOLUME_NO_RESOURCE_DESC), this);
                    return new SrPreSnapshotWizardPanel(secondaryVolume);
                }
                VolumeTreeNode primaryVolume = SrASyncPairPropertiesDialog.this.m_pair.getPairPrimaryVolume();
                this.wizardContext.setAttribute(SnapshotWizardContextKeys.NEXT_OUTER_WIZARD_PANEL, new AfterPrimSnapshotCreationWizardPanel(), this);
                this.wizardContext.setAttribute(SnapshotWizardContextKeys.PARAMS_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_PRIMARY_SNAPSHOT_PARAMS_DESC), this);
                this.wizardContext.setAttribute(SnapshotWizardContextKeys.SELECT_SNAPSHOT_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_PRIMARY_SNAPSHOT_SELECT_DESC), this);
                this.wizardContext.setAttribute(SnapshotWizardContextKeys.CREATE_VOLUME_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_PRIMARY_SNAPSHOT_CREATE_VOLUME_DESC), this);
                this.wizardContext.setAttribute(SnapshotWizardContextKeys.CREATE_VOLUME_NO_RESOURCE_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_PRIMARY_SNAPSHOT_CREATE_VOLUME_NO_RESOURCE_DESC), this);
                return new SrPreSnapshotWizardPanel(primaryVolume);
            }
            return new SnapshotFinishWizardPanel();
        }

        @Override
        public void initDisplay() {
            String question;
            this.setBackPanel(this.wizardContext.getWizardPanel(SrPreSnapshotWizardPanel.class));
            if (DRModeConstant.NORMAL.equals(SrASyncPairPropertiesDialog.this.m_pair.getMode())) {
                VolumeTreeNode secondaryVolume = SrASyncPairPropertiesDialog.this.m_pair.getPairSecondaryVolume();
                question = ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_SNAPSHOT_WIZARD_SEC_SNAP_QUESTION, secondaryVolume.getAlias());
            } else {
                VolumeTreeNode primaryVolume = SrASyncPairPropertiesDialog.this.m_pair.getPairPrimaryVolume();
                question = ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_PAIR_PROPERTIES_SNAPSHOT_WIZARD_PRIM_SNAP_QUESTION, primaryVolume.getAlias());
            }
            this.m_lbl.setText(question);
        }

        @Override
        protected String getQuestionString() {
            return "";
        }
    }

    private class SnapshotStartWizardPanel
    extends SrMsgAndGoWizardPanel {
        private WizardPanel nextPanel;

        SnapshotStartWizardPanel() {
            super(m_openMessage);
            this.nextPanel = null;
        }

        @Override
        public void display() {
            this.setBackButtonEnabled(false);
        }

        @Override
        public WizardPanel next() {
            VolumeTreeNode primaryVolume = SrASyncPairPropertiesDialog.this.m_pair.getPairPrimaryVolume();
            VolumeTreeNode secondaryVolume = SrASyncPairPropertiesDialog.this.m_pair.getPairSecondaryVolume();
            if (secondaryVolume == null || primaryVolume != null && DRModeConstant.NORMAL.equals(SrASyncPairPropertiesDialog.this.m_pair.getMode())) {
                this.wizardContext.setAttribute(SnapshotWizardContextKeys.NEXT_OUTER_WIZARD_PANEL, new AfterPrimSnapshotCreationWizardPanel(), this);
                this.wizardContext.setAttribute(SnapshotWizardContextKeys.PARAMS_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_PRIMARY_SNAPSHOT_PARAMS_DESC), this);
                this.wizardContext.setAttribute(SnapshotWizardContextKeys.SELECT_SNAPSHOT_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_PRIMARY_SNAPSHOT_SELECT_DESC), this);
                this.wizardContext.setAttribute(SnapshotWizardContextKeys.CREATE_VOLUME_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_PRIMARY_SNAPSHOT_CREATE_VOLUME_DESC), this);
                this.wizardContext.setAttribute(SnapshotWizardContextKeys.CREATE_VOLUME_NO_RESOURCE_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_PRIMARY_SNAPSHOT_CREATE_VOLUME_NO_RESOURCE_DESC), this);
                return new SrPreSnapshotWizardPanel(primaryVolume);
            }
            if (primaryVolume == null || secondaryVolume != null && DRModeConstant.SWITCHED.equals(SrASyncPairPropertiesDialog.this.m_pair.getMode())) {
                this.wizardContext.setAttribute(SnapshotWizardContextKeys.NEXT_OUTER_WIZARD_PANEL, new AfterSecSnapshotCreationWizardPanel(), this);
                this.wizardContext.setAttribute(SnapshotWizardContextKeys.PARAMS_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_SECONDARY_SNAPSHOT_PARAMS_DESC), this);
                this.wizardContext.setAttribute(SnapshotWizardContextKeys.SELECT_SNAPSHOT_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_SECONDARY_SNAPSHOT_SELECT_DESC), this);
                this.wizardContext.setAttribute(SnapshotWizardContextKeys.CREATE_VOLUME_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_SECONDARY_SNAPSHOT_CREATE_VOLUME_DESC), this);
                this.wizardContext.setAttribute(SnapshotWizardContextKeys.CREATE_VOLUME_NO_RESOURCE_DESCRIPTION, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_WIZ_SECONDARY_SNAPSHOT_CREATE_VOLUME_NO_RESOURCE_DESC), this);
                return new SrPreSnapshotWizardPanel(secondaryVolume);
            }
            throw new IllegalStateException("Empty pair (no volumes)");
        }
    }
}

