/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.conf.dialogs;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.login.UsersManager;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.security.StringCodec;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.OKCancelDialog;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrScrollPane;
import com.sanrad.swing.SrTabbedPane;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrPasswordTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.ListModel;

public class EmailParametersConfigDialog
extends OKCancelDialog {
    private SrTextField mailServerFld;
    private SrClientLabel mailServerLbl;
    private SrClientLabel fromAddressLbl;
    private SrTextField fromAddressFld;
    private JList toAddressList;
    private SrTextField userNameFld;
    private SrClientLabel userNameLbl;
    private SrPasswordTextField passwordFld;
    private SrClientLabel passwordLbl;
    private static SrLogger theLogger = SrLogger.getLogger();
    private String originalFromAddress;
    private String originalToAddress;
    private String originalMailServer;
    private String originalUserName;
    private String originalPassword;
    private String codecKey;
    private final String DELIMITER = ",";

    public EmailParametersConfigDialog(JFrame owner) {
        super(owner, "Email Configuration", false);
        this.initComponents();
        this.fixSizes();
        this.setSizeAndMoveToCenter(300, 300);
        this.setOKAction(new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                String newUserName;
                String newMailServer;
                String newToAddressList;
                HashMap<ClientParameterCode, String> map = new HashMap<ClientParameterCode, String>(3);
                String newFromAddress = EmailParametersConfigDialog.this.fromAddressFld.getText().trim();
                if (!newFromAddress.equalsIgnoreCase(EmailParametersConfigDialog.this.originalFromAddress)) {
                    map.put(ClientParameterCode.EMAIL_CONTACT_FROM_ADDRESS, newFromAddress);
                }
                if (!(newToAddressList = EmailParametersConfigDialog.this.getToAddressList()).equalsIgnoreCase(EmailParametersConfigDialog.this.originalToAddress)) {
                    map.put(ClientParameterCode.EMAIL_CONTACT_TO_ADDRESS, newToAddressList);
                }
                if (!(newMailServer = EmailParametersConfigDialog.this.mailServerFld.getText().trim()).equalsIgnoreCase(EmailParametersConfigDialog.this.originalMailServer)) {
                    map.put(ClientParameterCode.EMAIL_CONTACT_SMTP_HOST, newMailServer);
                }
                if (!(newUserName = EmailParametersConfigDialog.this.userNameFld.getText().trim()).equalsIgnoreCase(EmailParametersConfigDialog.this.originalUserName)) {
                    map.put(ClientParameterCode.EMAIL_CONTACT_SMTP_USER, newUserName);
                }
                String newPassword = new String(EmailParametersConfigDialog.this.passwordFld.getPassword());
                newPassword = StringCodec.encryptString(EmailParametersConfigDialog.this.codecKey, newPassword);
                if (!newPassword.equalsIgnoreCase(EmailParametersConfigDialog.this.originalPassword)) {
                    map.put(ClientParameterCode.EMAIL_CONTACT_SMTP_PASSWORD, newPassword);
                }
                Vector<SrFuture<Void>> retVal = new Vector<SrFuture<Void>>(1);
                if (!map.isEmpty()) {
                    ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
                    retVal.add(AlarmsManager.getInstance().setEmailContactParameters(clusterNode, map));
                }
                return retVal;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                return null;
            }
        });
    }

    protected void initComponents() {
        SrTabbedPane tabs = new SrTabbedPane();
        SrPanel generalPanel = this.createGeneralTab();
        SrPanel destPanel = this.createDestTab();
        tabs.addTab("General", generalPanel);
        tabs.addTab("Destination", destPanel);
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)tabs, "Center");
        this.addCenterPanel(mainPanel);
        this.setComponentBgColor(this.buttonsPanel);
        this.readDataFromServer();
    }

    private void readDataFromServer() {
        AlarmsManager alarmMgr = AlarmsManager.getInstance();
        HashMap parameters = alarmMgr.getEmailContactParameters(SystemRootNode.getInstance().getCurrentClusterNode());
        Object fromAddress = parameters.get(ClientParameterCode.EMAIL_CONTACT_FROM_ADDRESS);
        Object toAddressList = parameters.get(ClientParameterCode.EMAIL_CONTACT_TO_ADDRESS);
        Object smtpHost = parameters.get(ClientParameterCode.EMAIL_CONTACT_SMTP_HOST);
        Object smtpUser = parameters.get(ClientParameterCode.EMAIL_CONTACT_SMTP_USER);
        Object smtpPassword = parameters.get(ClientParameterCode.EMAIL_CONTACT_SMTP_PASSWORD);
        if (fromAddress != null) {
            this.fromAddressFld.setText(fromAddress.equals("") ? ClientLoader.PRODUCT_NAME : (String)fromAddress);
            this.originalFromAddress = (String)fromAddress;
        } else {
            this.fromAddressFld.setText(ClientLoader.PRODUCT_NAME);
        }
        if (smtpHost != null) {
            this.mailServerFld.setText((String)smtpHost);
            this.originalMailServer = (String)smtpHost;
        }
        if (smtpUser != null) {
            this.userNameFld.setText((String)smtpUser);
        }
        if (smtpPassword != null) {
            smtpPassword = this.decryptPassword((String)smtpPassword);
            this.passwordFld.setText((String)smtpPassword);
        }
        if (toAddressList != null) {
            Vector toList = this.parseToAddressList((String)toAddressList);
            this.addToList(toList);
            this.originalToAddress = (String)toAddressList;
        }
    }

    private String decryptPassword(String password) {
        this.codecKey = UsersManager.getInstance().getKey();
        return StringCodec.decryptString(this.codecKey, password);
    }

    private Vector parseToAddressList(String toList) {
        StringTokenizer tokenizer = new StringTokenizer(toList, ",");
        Vector<String> toAddresses = new Vector<String>();
        while (tokenizer.hasMoreTokens()) {
            toAddresses.addElement(tokenizer.nextToken());
        }
        return toAddresses;
    }

    private void addToList(Vector toAddressVec) {
        DefaultListModel model = (DefaultListModel)this.toAddressList.getModel();
        for (int i = 0; i < toAddressVec.size(); ++i) {
            model.addElement(toAddressVec.get(i));
        }
    }

    protected void fixSizes() {
        Dimension dim = this.fromAddressLbl.getPreferredSize();
        this.mailServerLbl.setPreferredSize(dim);
        this.userNameLbl.setPreferredSize(dim);
        this.passwordLbl.setPreferredSize(dim);
    }

    private SrPanel createGeneralTab() {
        SrPanel generalPanel = new SrPanel();
        generalPanel.setLayout(new GridLayout(4, 1));
        this.mailServerFld = new SrTextField(15);
        this.mailServerLbl = new SrClientLabel("Mail Server:");
        SrPanel mailServerPanel = this.createSrPanel(this.mailServerLbl, this.mailServerFld);
        this.fromAddressFld = new SrTextField(15);
        this.fromAddressLbl = new SrClientLabel("From Address:");
        SrPanel fromAddressPanel = this.createSrPanel(this.fromAddressLbl, this.fromAddressFld);
        this.userNameLbl = new SrClientLabel("User Name: ");
        this.userNameFld = new SrTextField(15);
        SrPanel userNamePanel = this.createSrPanel(this.userNameLbl, this.userNameFld);
        this.passwordLbl = new SrClientLabel("Password: ");
        this.passwordFld = new SrPasswordTextField(15);
        SrPanel passwordPanel = this.createSrPanel(this.passwordLbl, this.passwordFld);
        generalPanel.add(mailServerPanel);
        generalPanel.add(fromAddressPanel);
        generalPanel.add(userNamePanel);
        generalPanel.add(passwordPanel);
        return generalPanel;
    }

    private void openAddAddressDialog() {
        new NewAddressDialog(this).show();
    }

    private void removeSelectedNames() {
        int[] selected = this.toAddressList.getSelectedIndices();
        for (int i = selected.length - 1; i >= 0; --i) {
            ((DefaultListModel)this.toAddressList.getModel()).removeElementAt(selected[i]);
        }
    }

    private String getToAddressList() {
        ListModel model = this.toAddressList.getModel();
        StringBuffer buffer = new StringBuffer();
        int size = model.getSize();
        if (size == 0) {
            return "";
        }
        for (int i = 0; i < size; ++i) {
            buffer.append(model.getElementAt(i));
            buffer.append(",");
        }
        return buffer.substring(0, buffer.length() - 1);
    }

    private SrPanel createDestTab() {
        this.toAddressList = new JList(new DefaultListModel());
        this.toAddressList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean iss, boolean chf) {
                this.setText(value.toString());
                this.handleSelection(iss);
                return this;
            }

            private void handleSelection(boolean isSelected) {
                if (isSelected) {
                    this.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
                    this.setForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
                    return;
                }
                this.setBackground(LookAndFill.LIST_BACKGROUND_COLOR);
                this.setForeground(LookAndFill.LIST_FORGROUND_COLOR);
            }
        });
        SrScrollPane scroll = new SrScrollPane(this.toAddressList);
        scroll.getViewport().setBackground(LookAndFill.LIST_BACKGROUND_COLOR);
        JButton addBtn = new JButton("Add...");
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmailParametersConfigDialog.this.openAddAddressDialog();
            }
        });
        JButton removeBtn = new JButton("Remove");
        removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmailParametersConfigDialog.this.removeSelectedNames();
            }
        });
        SrPanel destPanel = new SrPanel();
        destPanel.setLayout(new BorderLayout());
        SrPanel btnPanel = new SrPanel();
        btnPanel.setLayout(new FlowLayout(0));
        btnPanel.add(addBtn);
        btnPanel.add(removeBtn);
        destPanel.add((Component)btnPanel, "South");
        destPanel.add((Component)scroll, "Center");
        return destPanel;
    }

    @Override
    public void doOnCancel() {
    }

    private void addAddressToList(String address) {
        ((DefaultListModel)this.toAddressList.getModel()).addElement(address);
        this.toAddressList.repaint();
    }

    @Override
    public void removeListeners() {
    }

    class NewAddressDialog
    extends OKCancelDialog {
        private SrTextField addressField;
        private SrClientLabel addressLbl;

        public NewAddressDialog(JDialog myOwner) {
            super(myOwner, "Add Address", true);
            this.layoutComponents();
            this.setSizeAndMoveToCenter(250, 150);
            MyOKAction myOKAction = new MyOKAction();
            this.addressField.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
            this.setOKAction(myOKAction);
        }

        private void layoutComponents() {
            this.addressField = new SrTextField(15);
            this.addressLbl = new SrClientLabel("Address: ");
            SrPanel addressPanel = this.createSrPanel(this.addressLbl, this.addressField);
            SrPanel mainPanel = new SrPanel();
            mainPanel.setLayout(new BorderLayout());
            mainPanel.add((Component)addressPanel, "Center");
            this.addCenterPanel(mainPanel);
            this.setComponentBgColor(this.buttonsPanel);
        }

        private boolean isLegalAddress(String address) {
            int indexOfAt = address.indexOf("@");
            return indexOfAt != -1 && indexOfAt != 0 && indexOfAt != address.length() - 1;
        }

        @Override
        public void doOnCancel() {
        }

        @Override
        public void removeListeners() {
        }

        private class MyOKAction
        extends SrClientAction<Void, Void> {
            public MyOKAction() {
                super(SrLicenseTreePath.GENERAL_PATH);
            }

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                EmailParametersConfigDialog.this.addAddressToList(NewAddressDialog.this.addressField.getText().trim());
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                if (!NewAddressDialog.this.isLegalAddress(NewAddressDialog.this.addressField.getText().trim())) {
                    return "You must enter a valid email address!";
                }
                return null;
            }
        }
    }
}

