/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.components;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.components.SrLicensedComponent;
import com.sanrad.nms.server.license.LicenseManager;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;

public class ClientComponentsUtil {
    public static final String LICENSE_BLOCK_TOOL_TIP = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.LICENSE_OPERATION_BLOCK);
    private static final String DISALLOWED_CHARS_REGEX = "[[' '][&][#][+][-][!][\\*]]";

    private ClientComponentsUtil() {
    }

    public static void checkLicenseAvailability(Container parent, SrBITSConstant vswitchCapability) {
        LicenseManager mgr = LicenseManager.getInstance();
        Component[] comps = parent.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Container)) continue;
            if (comps[i] instanceof SrLicensedComponent) {
                SrLicenseTreePath[] invisiblePaths;
                boolean isDisabledByLicenseCheck;
                SrLicensedComponent clientComp = (SrLicensedComponent)((Object)comps[i]);
                boolean prevEnabledState = comps[i].isEnabled();
                comps[i].setEnabled(mgr.isEnabled(clientComp.getLicensePath(), vswitchCapability) && comps[i].isEnabled());
                comps[i].setVisible(mgr.isVisible(clientComp.getLicensePath(), vswitchCapability) && comps[i].isVisible());
                boolean bl = isDisabledByLicenseCheck = prevEnabledState && !comps[i].isEnabled();
                if (isDisabledByLicenseCheck && comps[i] instanceof JComponent) {
                    ((JComponent)comps[i]).setToolTipText(LICENSE_BLOCK_TOOL_TIP);
                }
                if ((invisiblePaths = clientComp.getInvisiblePaths()) != null) {
                    int j = invisiblePaths.length;
                    while (j-- > 0) {
                        boolean visible = mgr.isVisible(invisiblePaths[j], vswitchCapability);
                        if (!visible) continue;
                        comps[i].setVisible(false);
                        break;
                    }
                }
            }
            if (!comps[i].isVisible()) continue;
            ClientComponentsUtil.checkLicenseAvailability((Container)comps[i], vswitchCapability);
        }
    }

    public static String filterVolumeAliasChars(String aOrigString) {
        String newAlias = aOrigString.replaceAll(DISALLOWED_CHARS_REGEX, ".");
        newAlias = newAlias.replaceAll("(\\.)+", ".");
        return newAlias;
    }
}

