/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.cluster.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.site.SiteManager;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.SrSystemObjectComboBox;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.ComponentHandler;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class NewClusterDialog
extends SrOKCancelDialog<SiteNode> {
    private static final String theDlgTitle = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_NEW_CLUSTER_DLG_TITLE);
    private static final String theAliasLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_NEW_CLUSTER_DLG_ALIAS_LABEL);
    private static final String theContextComboLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_NEW_CLUSTER_DLG_CONTEX_COMBO_LABEL);
    protected SiteNode parent;
    protected JTextField aliasFld;
    private SrPanel myMainPanel = new SrPanel();
    private SrLabelField myAliasLbl;
    private ComponentHandler myCompHandler;

    public NewClusterDialog(JFrame owner, SiteNode parent) {
        super(owner, theDlgTitle, true, SystemRootNode.getInstance().getClusterNodeOfSource(parent));
        this.parent = parent;
        this.myCompHandler = new ComponentHandler(this.myMainPanel);
        this.initialize();
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setOKAction();
        this.setTopContextBoxSelection(parent);
        this.show();
    }

    private void initialize() {
        this.myMainPanel.setLayout(new GridLayout(2, 1));
        this.setComponentBgColor(this.myMainPanel);
        SrPanel aliasPanel = new SrPanel();
        this.setComponentBgColor(aliasPanel);
        aliasPanel.setLayout(new FlowLayout(0));
        this.aliasFld = new JTextField(10);
        this.aliasFld.setFont(LookAndFill.GENERAL_FONT);
        this.myAliasLbl = new SrLabelField(theAliasLabel);
        this.myAliasLbl.setFont(LookAndFill.GENERAL_FONT);
        aliasPanel.add(this.myAliasLbl);
        aliasPanel.add(this.aliasFld);
        this.myMainPanel.add(aliasPanel);
        this.setComponentBgColor(this.buttonsPanel);
        this.addCenterPanel(this.myMainPanel);
        SrSystemObjectComboBox.SingleTypeProperties nodeProperties = new SrSystemObjectComboBox.SingleTypeProperties(SiteNode.class){

            @Override
            public Icon getNodeIcon(SrTreeNode aNode) {
                if (aNode.equals(SystemRootNode.getInstance())) {
                    return null;
                }
                return super.getNodeIcon(aNode);
            }

            @Override
            public String getTextForNode(SrTreeNode aNode) {
                if (aNode.equals(SystemRootNode.getInstance())) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_SYS_OBJ_COMBO_SYS_ROOT_TEXT);
                }
                return super.getTextForNode(aNode);
            }
        };
        this.addTopContextBox(theContextComboLabel, new SrSystemObjectComboBox(SystemRootNode.getInstance(), SiteNode.class, nodeProperties, true){

            @Override
            protected int getIndentationForNode(Object aNode) {
                int indentationFromRoot = super.getIndentationForNode(aNode);
                return indentationFromRoot > 0 ? indentationFromRoot - 1 : 0;
            }
        }, null);
    }

    @Override
    protected void systemNodeSelected(SiteNode aSysNode) {
        this.parent = aSysNode;
        if (aSysNode == null) {
            this.myCompHandler.setAllEnabled(false);
        } else {
            this.myCompHandler.revertEnabledState();
        }
    }

    @Override
    public void doOnCancel() {
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
    }

    protected void setOKAction() {
        SrClientAction<Void, Void> myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                String alias = NewClusterDialog.this.aliasFld.getText();
                String msg = ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_NEW_CLUSTER_DLG_STATUS_BAR_MSG_FORMAT, alias);
                StatusPanel.getInstance().setText(msg, this);
                return Collections.singleton(SiteManager.getInstance().addCluster(alias, NewClusterDialog.this.parent));
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                String alias = NewClusterDialog.this.aliasFld.getText();
                if (alias == null || alias.trim().equals("")) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_CLUSTER_DLG_ALIAS_MISSING);
                }
                if (NewClusterDialog.this.getTopContextBoxSelection() == null) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_CLUSTER_DLG_LOCATION_MISSING);
                }
                return null;
            }
        };
        this.aliasFld.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        this.setOKAction(myOKAction);
    }

    @Override
    public void fail(String msg) {
        super.fail(msg);
        this.aliasFld.grabFocus();
    }

    @Override
    protected void setClusterTitle() {
    }

    @Override
    public void removeListeners() {
    }
}

