/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.cluster.dialogs;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.cluster.dialogs.SrNeighborsTableModel;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.vswitch.VSwitchEvent;
import com.sanrad.nms.client.event.vswitch.VSwitchListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelFrame;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.cluster.dialogs.SrNeighborsTablePanel;
import com.sanrad.nms.client.gui.components.SrClientCheckBox;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.StorageSize;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class ClusterPropertiesDialog
extends SrOKCancelFrame
implements VSwitchListener {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static final String SECONDS_TEXT = "sec.";
    private static final String KEEP_ALIVE_INTERVAL_TEXT = "Keep-alive Interval";
    private static final String SUSPICIOUS_INTERVAL_TEXT = "Suspicious Interval";
    private static final String FAULTY_INTERVAL_TEXT = "Faulty Interval";
    private JTabbedPane tabsPanel;
    private SrClientLabel aliasLbl;
    private SrClientLabel totalCapacityLbl;
    private SrClientLabel accessibleSpaceLbl;
    private SrClientLabel keepAliveLbl;
    private SrClientLabel suspiciousIntervalLbl;
    private SrClientLabel faultyIntervalLbl;
    private SrTextField aliasFld;
    private SrTextField totalCapacityFld;
    private SrTextField accessibleSpaceFld;
    private SrIntegerTextField keepAliveFld;
    private SrIntegerTextField suspiciousIntervalFld;
    private SrIntegerTextField faultyIntervalFld;
    private ClusterNode clusterNode;
    private SrNeighborsTableModel neighborsTableModel;
    private SrClientLabel failoverEnableLbl;
    private SrClientCheckBox failoverEnableFld;
    private SrClientLabel takeoverStateLbl;
    private SrTextField takeoverStateFld;

    public ClusterPropertiesDialog(JFrame owner, ClusterNode node) {
        super(owner, "Properties", node);
        this.clusterNode = node;
        this.initComponents();
        this.fixSizes();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ClusterPropertiesDialog.this.clusterNode.setUserObject(null);
            }
        });
        this.setSize(440, 400);
        new ClusterPropertiesRetriever(this, this.clusterNode).start();
    }

    private void setData(Vector nbrs) {
        this.neighborsTableModel.init(nbrs);
        this.failoverEnableFld.setEnabled(this.neighborsTableModel.getRowCount() > 1);
    }

    private void fixSizes() {
        Dimension dim = this.keepAliveLbl.getPreferredSize();
        this.faultyIntervalLbl.setPreferredSize(dim);
        this.suspiciousIntervalLbl.setPreferredSize(dim);
        this.aliasLbl.setPreferredSize(dim);
        this.totalCapacityLbl.setPreferredSize(dim);
        this.accessibleSpaceLbl.setPreferredSize(dim);
        this.failoverEnableLbl.setPreferredSize(dim);
        this.takeoverStateLbl.setPreferredSize(dim);
        dim = this.keepAliveFld.getPreferredSize();
        this.suspiciousIntervalFld.setPreferredSize(dim);
        this.totalCapacityFld.setPreferredSize(dim);
        this.accessibleSpaceFld.setPreferredSize(dim);
        this.aliasFld.setPreferredSize(dim);
    }

    @Override
    public void addListeners() {
        VSwitchManager.getInstance().addVSwitchListener(this);
    }

    @Override
    public void removeListeners() {
        VSwitchManager.getInstance().removeVSwitchListener(this);
        this.neighborsTableModel.removeListeners();
    }

    private void initComponents() {
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        this.tabsPanel = new JTabbedPane();
        SrPanel generalPanel = this.createGeneralPanel();
        SrPanel neighborsPanel = this.createNeighborsPanel();
        this.tabsPanel.addTab("General", generalPanel);
        this.tabsPanel.addTab("Neighbors", neighborsPanel);
        this.tabsPanel.setBackground(LookAndFill.DIALOG_COLOR);
        mainPanel.add((Component)this.tabsPanel, "Center");
        this.addCenterPanel(mainPanel);
        this.buttonsPanel.setBackground(LookAndFill.DIALOG_COLOR);
    }

    private SrPanel createNeighborsPanel() {
        SrPanel panel = new SrPanel();
        panel.setLayout(new BorderLayout());
        this.neighborsTableModel = new SrNeighborsTableModel();
        SrNeighborsTablePanel table = new SrNeighborsTablePanel(this.neighborsTableModel);
        panel.add((Component)table, "Center");
        return panel;
    }

    private SrPanel createGeneralPanel() {
        SrPanel genPanel = new SrPanel();
        genPanel.setLayout(new GridLayout(10, 1));
        this.aliasLbl = new SrClientLabel("Alias: ");
        this.aliasFld = new SrTextField();
        this.aliasFld.setText(this.clusterNode.getAlias());
        SrPanel aliasPanel = this.createSrPanel(this.aliasLbl, this.aliasFld);
        this.totalCapacityLbl = new SrClientLabel("Total Capacity: ");
        this.totalCapacityFld = new SrTextField();
        String totCapacity = StorageSize.getSizeAsString(this.clusterNode.getTotalCapacity());
        this.totalCapacityFld.setText(totCapacity);
        this.totalCapacityFld.setEnabled(false);
        SrPanel totalCapacityPanel = this.createSrPanel(this.totalCapacityLbl, this.totalCapacityFld);
        this.accessibleSpaceLbl = new SrClientLabel("Accessible Space: ");
        this.accessibleSpaceFld = new SrTextField();
        String accessibleSpace = StorageSize.getSizeAsString(this.clusterNode.getAccessibleSpace());
        this.accessibleSpaceFld.setText(accessibleSpace);
        this.accessibleSpaceFld.setEnabled(false);
        SrPanel accesibleSpacePanel = this.createSrPanel(this.accessibleSpaceLbl, this.accessibleSpaceFld);
        String notAvailable = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_NOT_AVAILABLE_VALUE);
        this.keepAliveLbl = new SrClientLabel("Keep-alive Interval: ");
        this.keepAliveFld = new SrIntegerTextField();
        Integer keepAlive = this.clusterNode.getKeepAlive();
        this.keepAliveFld.setText(keepAlive == null ? notAvailable : keepAlive.toString());
        this.keepAliveFld.setEnabled(keepAlive != null);
        SrPanel keepAlivePanel = this.createSrPanel(this.keepAliveLbl, this.keepAliveFld);
        SrClientLabel keepAliveUnitsLbl = new SrClientLabel(SECONDS_TEXT);
        keepAlivePanel.add(keepAliveUnitsLbl);
        this.suspiciousIntervalLbl = new SrClientLabel("Suspicious Interval: ");
        this.suspiciousIntervalFld = new SrIntegerTextField();
        Integer suspiciousInterval = this.clusterNode.getSuspiciousInterval();
        this.suspiciousIntervalFld.setText(suspiciousInterval == null ? notAvailable : suspiciousInterval.toString());
        this.suspiciousIntervalFld.setEnabled(suspiciousInterval != null);
        SrPanel suspiciousIntervalPanel = this.createSrPanel(this.suspiciousIntervalLbl, this.suspiciousIntervalFld);
        SrClientLabel suspiciousIntervalUnitsLbl = new SrClientLabel(SECONDS_TEXT);
        suspiciousIntervalPanel.add(suspiciousIntervalUnitsLbl);
        this.faultyIntervalLbl = new SrClientLabel("Faulty Interval: ");
        this.faultyIntervalFld = new SrIntegerTextField();
        Integer faultyInterval = this.clusterNode.getFaultyInterval();
        this.faultyIntervalFld.setText(faultyInterval == null ? "N/A" : faultyInterval.toString());
        this.faultyIntervalFld.setEnabled(faultyInterval != null);
        SrPanel faultyIntervalPanel = this.createSrPanel(this.faultyIntervalLbl, this.faultyIntervalFld);
        SrClientLabel faultyIntervalUnitsLbl = new SrClientLabel(SECONDS_TEXT);
        faultyIntervalPanel.add(faultyIntervalUnitsLbl);
        this.failoverEnableLbl = new SrClientLabel("Failover: ");
        this.failoverEnableFld = new SrClientCheckBox();
        Boolean failoverEnable = this.clusterNode.isFailoverEnable();
        this.failoverEnableFld.setSelected(failoverEnable == null ? false : failoverEnable);
        this.failoverEnableFld.setEnabled(failoverEnable != null);
        SrPanel failoverEnablePanel = this.createSrPanel(this.failoverEnableLbl, this.failoverEnableFld);
        this.failoverEnableFld.setEnabled(false);
        this.takeoverStateLbl = new SrClientLabel("Takeover state: ");
        this.takeoverStateFld = new SrTextField();
        this.takeoverStateFld.setValue(this.clusterNode.getTakeoverState());
        this.takeoverStateFld.setEnabled(false);
        SrPanel takeoverStatePanel = this.createSrPanel(this.takeoverStateLbl, this.takeoverStateFld);
        genPanel.add(new SrPanel());
        genPanel.add(aliasPanel);
        genPanel.add(accesibleSpacePanel);
        genPanel.add(totalCapacityPanel);
        genPanel.add(keepAlivePanel);
        genPanel.add(suspiciousIntervalPanel);
        genPanel.add(faultyIntervalPanel);
        genPanel.add(takeoverStatePanel);
        genPanel.add(new SrPanel());
        return genPanel;
    }

    @Override
    protected void doOnOK() {
        SrFuture<Void> future;
        Object clusterAlias;
        boolean valid;
        HashMap<ClientParameterCode, Object> params = new HashMap<ClientParameterCode, Object>();
        String alias = this.aliasFld.getText();
        if (!alias.equals(this.clusterNode.getAlias())) {
            if (alias.trim().equals("")) {
                this.fail("Alias cannot be empty. Please insert a new value.");
            } else {
                params.put(ClientParameterCode.CLUSTER_ALIAS, alias);
            }
        }
        String keepAlive = this.keepAliveFld.getText();
        String susInterval = this.suspiciousIntervalFld.getText();
        String faultyInterval = this.faultyIntervalFld.getText();
        if (this.keepAliveFld.isEnabled() && this.suspiciousIntervalFld.isEnabled() && this.faultyIntervalFld.isEnabled() && (valid = this.validate(keepAlive, susInterval, faultyInterval))) {
            if (Integer.parseInt(keepAlive) != this.clusterNode.getKeepAlive()) {
                params.put(ClientParameterCode.KEEP_ALIVE, new Integer(keepAlive));
            }
            if (this.clusterNode.getSuspiciousInterval() != Integer.parseInt(susInterval)) {
                params.put(ClientParameterCode.SUSPICIOUS_INTERVAL, new Integer(susInterval));
            }
            if (this.clusterNode.getFaultyInterval() != Integer.parseInt(faultyInterval)) {
                params.put(ClientParameterCode.FAULTY_INTERVAL, new Integer(faultyInterval));
            }
        }
        if (this.failoverEnableFld.isEnabled() && this.clusterNode.isFailoverEnable().booleanValue() != this.failoverEnableFld.isSelected()) {
            params.put(ClientParameterCode.FAILOVER_ENABLE, new Boolean(this.failoverEnableFld.isSelected()));
        }
        if ((clusterAlias = params.remove(ClientParameterCode.CLUSTER_ALIAS)) != null && (future = ClusterManager.getInstance().setAlias(this.clusterNode, (String)clusterAlias)) != null) {
            SrClientAction.blockActions(Collections.singleton(future), this);
        }
        if (!params.isEmpty()) {
            SrClientAction.blockActions(Collections.singleton(VSwitchManager.getInstance().editAllVSwitchesInCluster(this.clusterNode, params)), this);
        }
    }

    private boolean validate(String keepAlive, String suspiciousInterval, String faultyInterval) {
        try {
            int ka = Integer.parseInt(keepAlive);
            int si = Integer.parseInt(suspiciousInterval);
            int fi = Integer.parseInt(faultyInterval);
            if (ka < si) {
                if (si < fi) {
                    return true;
                }
                this.fail("Faulty Interval should be bigger than Suspicious Interval. Please insert a new value.");
                return false;
            }
            this.fail("Suspicious Interval should be bigger than Keep-alive Interval. Please insert a new value.");
            return false;
        }
        catch (NumberFormatException nfe) {
            theLogger.trace(SrLogCategories.LEGACY, nfe);
            this.fail("All fields: Keep-alive Interval; Faulty Interval; Suspicious Interval; must have a value. Please insert a new value.");
            return false;
        }
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void vSwitchCreated(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRemoved(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRediscovered(VSwitchEvent e) {
    }

    @Override
    public void vSwitchPropertiesChanged(VSwitchEvent e) {
        RemoteObject stub = e.getStub();
        SrTreeNode vs = SystemRootNode.getInstance().getRefByStub(stub);
        if (vs != null) {
            VSwitchNode node = (VSwitchNode)vs;
            Integer ka = node.getKeepAlive();
            Integer si = node.getSuspiciousInterval();
            Integer fi = node.getFaultyInterval();
            Boolean failoverEnable = node.isFailoverEnable();
            if (ka != null) {
                this.keepAliveFld.setText(ka.toString());
            }
            if (si != null) {
                this.suspiciousIntervalFld.setText(si.toString());
            }
            if (fi != null) {
                this.faultyIntervalFld.setText(fi.toString());
            }
            if (failoverEnable != null) {
                this.failoverEnableFld.setSelected(failoverEnable);
            }
            if (failoverEnable != null && node.getTakeoverState() != null) {
                String takeoverState = node.getTakeoverState().toString();
                this.takeoverStateFld.setText(takeoverState);
            }
            this.repaint();
        }
    }

    @Override
    public void resetVSwitchStarted(VSwitchEvent e) {
    }

    class ClusterPropertiesRetriever
    extends Thread {
        private ClusterPropertiesDialog dialog;
        private ClusterNode node;

        public ClusterPropertiesRetriever(ClusterPropertiesDialog dialog, ClusterNode node) {
            this.dialog = dialog;
            this.node = node;
        }

        @Override
        public void run() {
            ClusterManager clusterManager = ClusterManager.getInstance();
            Vector nbrs = clusterManager.getAllNeighbors(this.node);
            theLogger.trace(SrLogCategories.LEGACY, "ClusterPropertiesRetriever:: neighbors size = ", nbrs.size());
            this.dialog.setData(nbrs);
        }
    }
}

