/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.cluster;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.SrMainTreeModel;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrMainTreePanel;
import com.sanrad.nms.client.gui.SrPopupMenu;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.EmptyAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.server.license.SrFeatureNameConstant;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.TreeView;
import com.sanrad.swing.components.SrMenu;
import com.sanrad.swing.components.SrMenuItem;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;

public class ClusterPopupMenu
extends SrPopupMenu
implements Comparator {
    private static SrLogger theLogger = SrLogger.getLogger();
    public static final SrLicenseTreePath createStoragePath = new SrLicenseTreePath(SrLicenseTreePath.STORAGE_PATH, SrFeatureNameConstant.CREATE);
    private SrMenu m_moveItem;

    public ClusterPopupMenu(SrMainTreePanel workWith) {
        super(workWith);
        SrMenu newItem = this.createNewItemsMenu();
        this.add(newItem);
        EmptyAction emptyAction = new EmptyAction(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_MOVE_CLUSTER_OR_VSWITCH_TO_SITE_POPUP_LABEL), false, true, SrLicenseTreePath.GDR_PATH);
        this.m_moveItem = new SrMenu(emptyAction);
        this.add(this.m_moveItem);
        SrMenuItem accessListItem = this.createAccessListMenuItem();
        this.add(accessListItem);
        SrMenuItem storageDiscoveryItem = this.createStorageDiscoveryMenuItem();
        SrMenuItem rediscoverItem = this.createRediscoverMenuItem();
        this.addSeparator();
        this.add(rediscoverItem);
        this.add(storageDiscoveryItem);
        this.add(new SrMenuItem(workWith.attachRaidActionForCluster));
        this.addSeparator();
        SrMenu myIscsiMenu = this.createIscsiMenu();
        this.add(myIscsiMenu);
        SrMenuItem radiusItem = this.createRadiusMenuItem();
        SrMenuItem isnsItem = this.createIsnsMenuItem();
        this.add(radiusItem);
        this.add(isnsItem);
        this.addSeparator();
        this.add(new SrMenuItem(this.myWorkWith.mySynchronizeCluster));
        this.addSeparator();
        this.add(this.alarmsMenu);
        this.addSeparator();
        this.add(this.createRenameMenuItem());
        this.add(this.getDeleteItem());
        this.addSeparator();
        this.add(ClusterPopupMenu.createPropertiesItem(this.myWorkWith.openClusterPropertiesAction));
    }

    protected SrMenu createIscsiMenu() {
        SrMenu iscsiMenu = new SrMenu(new SrPopupMenu.IscsiMenuAction<ClusterNode>(new TreeView<ClusterNode>(this.myWorkWith.getTreeObject(), ClusterNode.class)){

            @Override
            protected String derivedClientUpdateEnabled() {
                ClusterNode cluster = (ClusterNode)this.myView.getValue().iterator().next();
                if (SrMainTreeModel.getInstance().getNumberOfVswitches(cluster) == 0) {
                    return SrMainTreePanel.THE_CLUSTER_CONTAINS_NO_V_SWITCHES;
                }
                return cluster.getInDiscoveryTooltip();
            }
        });
        iscsiMenu.add(this.m_iscsiRemoteTargetShowItem);
        iscsiMenu.add(this.m_iscsiRemoteDiscoveryPortalsShowItem);
        this.m_iscsiSessionsMenu.add(this.m_iscsiSessionsShowItem);
        this.m_iscsiSessionsMenu.add(this.m_iscsiSessionsStatisticsItem);
        iscsiMenu.add(this.m_iscsiSessionsMenu);
        iscsiMenu.add(this.m_iscsiConnectionsItem);
        this.m_iscsiConnectedInitiatorsMenu.add(this.m_iscsiConnectedInitiatorsShowItem);
        this.m_iscsiConnectedInitiatorsMenu.add(this.m_iscsiConnectedInitiatorsStatisticsItem);
        iscsiMenu.add(this.m_iscsiConnectedInitiatorsMenu);
        return iscsiMenu;
    }

    private SrMenuItem createAccessListMenuItem() {
        return new SrMenuItem(this.myWorkWith.accessListAction);
    }

    private SrMenuItem createIsnsMenuItem() {
        return new SrMenuItem(this.myWorkWith.isnsAction);
    }

    private SrMenuItem createRadiusMenuItem() {
        return new SrMenuItem(this.myWorkWith.radiusAction);
    }

    private SrMenuItem createRenameMenuItem() {
        SrMenuItem renameItem = new SrMenuItem(this.myWorkWith.startEditAction);
        renameItem.setItemText("Rename");
        return renameItem;
    }

    private SrMenuItem createRediscoverMenuItem() {
        return new SrMenuItem(this.myWorkWith.rediscoverClusterAction);
    }

    private SrMenuItem createStorageDiscoveryMenuItem() {
        return new SrMenuItem(this.myWorkWith.storageDiscoveryAction);
    }

    private SrMenu createNewItemsMenu() {
        SrMenu newItem = new SrMenu("New");
        SrMenuItem newTargetItem = new SrMenuItem(this.myWorkWith.newTargetAction);
        newTargetItem.setItemText("Target...");
        SrMenuItem m_newRemoteTargetItem = new SrMenuItem(this.myWorkWith.newRemoteTargetAction);
        SrMenuItem newIdItem = new SrMenuItem(this.myWorkWith.newIdentityAction);
        newIdItem.setItemText("Host Group...");
        newItem.add(new SrMenuItem(new SrMainTreePanel.NewVswitchAction(this.myWorkWith, true, false)));
        newItem.add(new SrMenuItem(new SrMainTreePanel.NewVswitchAction(this.myWorkWith, false, false)));
        newItem.add(newIdItem);
        newItem.add(newTargetItem);
        newItem.add(m_newRemoteTargetItem);
        return newItem;
    }

    public void buildMoveSubMenu() {
        ClusterNode currentClusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
        SiteNode currentSiteNode = (SiteNode)currentClusterNode.getParent();
        SiteNode[] siteNodes = SystemRootNode.getInstance().getSiteNodes();
        ArrayList<SiteNode> siteList = new ArrayList<SiteNode>();
        int i = siteNodes.length;
        while (i-- > 0) {
            siteList.add(siteNodes[i]);
        }
        siteList.add(SystemRootNode.getInstance());
        siteList.remove(currentSiteNode);
        int size = siteList.size();
        if (size > 0) {
            Collections.sort(siteList, this);
            for (int i2 = 0; i2 < size; ++i2) {
                SiteNode destinationSite = (SiteNode)siteList.get(i2);
                SrMenuItem item = new SrMenuItem(new ClusterMoveAction(currentClusterNode, destinationSite));
                if (destinationSite.equals(SystemRootNode.getInstance())) {
                    item.setForeground(Color.BLUE);
                }
                this.m_moveItem.add(item);
            }
            this.m_moveItem.setEnabled(true);
        } else {
            this.m_moveItem.setEnabled(false);
        }
    }

    @Override
    public AlarmAction getSpecificAlarmAction() {
        return this.myWorkWith.myOpenSpecificAlarmsAction;
    }

    @Override
    public AlarmAction getPropagatedAlarmAction() {
        return this.myWorkWith.myOpenPropagatedAlarmsAction;
    }

    @Override
    protected DeleteAction getDeleteAction() {
        return this.myWorkWith.myRemoveClusterAction;
    }

    public int compare(Object o1, Object o2) {
        String s1 = o1.toString();
        String s2 = o2.toString();
        return s1.compareToIgnoreCase(s2);
    }

    @Override
    protected void innerReset() {
        this.m_moveItem.removeAll();
    }

    public class ClusterMoveAction
    extends SrClientAction<Void, Void> {
        private ClusterNode m_currentClusterNode;
        private SiteNode myDestinationSiteNode;

        public ClusterMoveAction(ClusterNode currentClusterNode, SiteNode destinationSiteNode) {
            super(SrLicenseTreePath.GENERAL_PATH);
            if (currentClusterNode == null) {
                throw new IllegalArgumentException("ClusterPopupMenu received null as currentClusterNode");
            }
            this.m_currentClusterNode = currentClusterNode;
            this.myDestinationSiteNode = destinationSiteNode;
            this.setConnectionErrorMessage("Failed to move Cluster " + this.m_currentClusterNode);
            this.setName(destinationSiteNode.toString());
            this.updateEnabled();
            this.addControllerAsListener(StatusPanel.getInstance());
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            StatusPanel.getInstance().setText("Moving cluster " + this.m_currentClusterNode + " to site " + this.myDestinationSiteNode, this);
            theLogger.trace(SrLogCategories.LEGACY, "Try to move cluster: ", this.m_currentClusterNode, " to site: ", this.myDestinationSiteNode);
            return Collections.singleton(ClientAOImpl.getInstance().moveToSite((CommKeyClassId)this.m_currentClusterNode.getIdentifier(), (CommKeyClassId)this.myDestinationSiteNode.getIdentifier()));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            if (this.m_currentClusterNode == null) {
                return "No cluster is selected (initially)";
            }
            String currentClusterAlias = this.m_currentClusterNode.getAlias();
            Enumeration<TreeNode> e = this.myDestinationSiteNode.children();
            while (e.hasMoreElements()) {
                TreeNode child = e.nextElement();
                if (!(child instanceof ClusterNode) || !currentClusterAlias.equals(((ClusterNode)child).getAlias())) continue;
                return "Container " + this.myDestinationSiteNode + " already has a cluster with alias " + currentClusterAlias;
            }
            return null;
        }
    }
}

