/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.alarm.dialogs;

import com.sanrad.nms.client.data.alarm.SrHistoryAlarmsTableModel;
import com.sanrad.nms.client.event.alarm.HistoryAlarmsTableModelEvent;
import com.sanrad.nms.client.event.alarm.HistoryAlarmsTableModelListener;
import com.sanrad.nms.client.gui.alarm.SrHistoryAlarmsTablePanel;
import com.sanrad.nms.client.gui.alarm.dialogs.AlarmsDialog;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class HistoryAlarmsDialog
extends AlarmsDialog
implements ActionListener,
HistoryAlarmsTableModelListener {
    private static final String PREVIOUS = "< Previous";
    private static final String NEXT = "Next >";
    private JLabel loadingLbl;
    private SrHistoryAlarmsTableModel model;
    private JButton next;
    private JButton previous;

    public HistoryAlarmsDialog(JFrame owner) {
        super((Window)owner, "Alarms History");
        this.model.initialize();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                HistoryAlarmsDialog.this.exit();
            }
        });
    }

    public void initialize() {
        this.model.initialize();
        this.m_pane.clear();
    }

    public void setButtonsEnable() {
        this.next.setEnabled(this.model.hasNext());
        this.previous.setEnabled(this.model.hasPrevious());
    }

    @Override
    protected void exit() {
        this.setVisible(false);
    }

    @Override
    protected void initComponents() {
    }

    @Override
    protected SrPanel createTablePanel() {
        this.model = new SrHistoryAlarmsTableModel();
        this.model.addHistoryAlarmsTableModelListener(this);
        SrHistoryAlarmsTablePanel pan = new SrHistoryAlarmsTablePanel(this.model);
        pan.addAlarmsTableListener(this.m_pane);
        this.table = pan.getTable();
        pan.getScrollPane().getViewport().setBackground(LookAndFill.TABLE_SCROLL_BACKGROUND_COLOR);
        return pan;
    }

    @Override
    protected SrPanel createButtonsPanel() {
        SrPanel panel = super.createButtonsPanel();
        this.previous = new JButton(PREVIOUS);
        this.previous.addActionListener(this);
        this.previous.setActionCommand(PREVIOUS);
        this.next = new JButton(NEXT);
        this.next.setActionCommand(NEXT);
        this.next.addActionListener(this);
        this.next.setPreferredSize(this.previous.getPreferredSize());
        this.buttonsPanel.add((Component)this.next, 0);
        this.buttonsPanel.add((Component)this.previous, 0);
        return panel;
    }

    @Override
    protected SrPanel createLabelPanel() {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        this.loadingLbl = new JLabel("");
        panel.add(this.loadingLbl);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        boolean forward = true;
        if (command.equalsIgnoreCase(PREVIOUS)) {
            forward = false;
        } else if (command.equalsIgnoreCase(NEXT)) {
            forward = true;
        }
        ((SrHistoryAlarmsTableModel)this.table.getModel()).addAlarms(forward);
    }

    @Override
    public void loadingHistoryAlarms(HistoryAlarmsTableModelEvent e) {
        this.disableButtonAndDisplayMsg("Loading History Alarms, Please wait...");
    }

    @Override
    public void historyAlarmsLoaded(HistoryAlarmsTableModelEvent e) {
        this.loadingLbl.setText("");
        this.setButtonsEnable();
    }

    @Override
    public void serverConnectionError(HistoryAlarmsTableModelEvent aEvent) {
        this.disableButtonAndDisplayMsg("Can not load history alarms, the connection to the server is inactive.");
    }

    private void disableButtonAndDisplayMsg(String aMsg) {
        this.loadingLbl.setText(aMsg);
        this.m_pane.clear();
        this.next.setEnabled(false);
        this.previous.setEnabled(false);
    }
}

