/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.alarm.dialogs;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.gui.alarm.dialogs.FilteredAlarmsDialog;
import java.awt.Window;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;

public class FilteredAlarmsDialogsPool {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static FilteredAlarmsDialogsPool instance;
    private HashMap<MatchedDialog, FilteredAlarmsDialog> myMatchedToDialogMap = new HashMap();

    protected FilteredAlarmsDialogsPool() {
    }

    public static synchronized FilteredAlarmsDialogsPool getInstance() {
        if (instance == null) {
            instance = new FilteredAlarmsDialogsPool();
        }
        return instance;
    }

    public FilteredAlarmsDialog getFilteredDialog(Window owner, List<? extends SrTreeNode> nodes, boolean specific) {
        SrTreeNode node = nodes.get(nodes.size() - 1);
        MatchedDialog key = new MatchedDialog(node, specific);
        FilteredAlarmsDialog existDialog = this.myMatchedToDialogMap.get(key);
        if (existDialog != null) {
            return existDialog;
        }
        FilteredAlarmsDialog dialog = new FilteredAlarmsDialog(owner, nodes, specific);
        this.myMatchedToDialogMap.put(key, dialog);
        return dialog;
    }

    public FilteredAlarmsDialog getFilteredDialog(JFrame owner, Object[] nodes, boolean specific) {
        Object node = nodes[nodes.length - 1];
        FilteredAlarmsDialog existDialog = this.myMatchedToDialogMap.get(new MatchedDialog(node, specific));
        if (existDialog != null) {
            return existDialog;
        }
        Vector<Object> toShow = new Vector<Object>();
        for (int i = 0; i < nodes.length; ++i) {
            toShow.addElement(nodes[i]);
        }
        FilteredAlarmsDialog dialog = new FilteredAlarmsDialog((Window)owner, toShow, specific);
        this.myMatchedToDialogMap.put(new MatchedDialog(node, specific), dialog);
        return dialog;
    }

    public void removeAlarmsDialog(SrTreeNode node, boolean specific) {
        this.myMatchedToDialogMap.remove(new MatchedDialog(node, specific));
    }

    public void disposeAll() {
        for (FilteredAlarmsDialog dialog : this.myMatchedToDialogMap.values()) {
            dialog.dispose();
        }
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    class MatchedDialog {
        Object node;
        boolean specific;

        public MatchedDialog(Object node, boolean specific) {
            this.node = node;
            this.specific = specific;
        }

        public boolean equals(Object o) {
            MatchedDialog md = (MatchedDialog)o;
            return md.node.equals(this.node) && md.specific == this.specific;
        }

        public int hashCode() {
            return this.node.hashCode();
        }
    }
}

