/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.alarm.dialogs;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationAdapter;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.comm.CommunicationEventService;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.alarm.SrFilteredAlarmsTableModel;
import com.sanrad.nms.client.gui.alarm.SrAlarmsTablePanel;
import com.sanrad.nms.client.gui.alarm.dialogs.CurrentAlarmsDialog;
import com.sanrad.nms.client.gui.alarm.dialogs.FilteredAlarmsDialogsPool;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import java.awt.Window;
import java.util.List;
import javax.swing.JFrame;

public class FilteredAlarmsDialog
extends CurrentAlarmsDialog {
    private SrTreeNode[] nodes;
    private SrFilteredAlarmsTableModel model;
    private DiscoveryMonitor m_discoveryMonitor = new DiscoveryMonitor();
    private boolean specific;
    private static SrLogger theLogger = SrLogger.getLogger();

    public FilteredAlarmsDialog(Window owner, List<? extends SrTreeNode> nodes, boolean specific) {
        super(owner);
        this.specific = specific;
        this.nodes = new SrTreeNode[nodes.size()];
        this.nodes = nodes.toArray(this.nodes);
        this.setDialogTitle(specific);
        this.setDefaultCloseOperation(2);
        this.model.addNodes(this.nodes);
        CommunicationEventService.getInstance().addCommunicationListener(this.m_discoveryMonitor);
    }

    private void setDialogTitle(boolean specific) {
        String name = "";
        if (this.nodes.length > 0) {
            name = this.nodes[this.nodes.length - 1].toString();
        }
        if (specific) {
            this.setTitle("Specific Alarms For - " + name);
        } else {
            this.setTitle("Propagated Alarms For - " + name);
        }
    }

    @Override
    public void dispose() {
        FilteredAlarmsDialogsPool.getInstance().removeAlarmsDialog(this.nodes[this.nodes.length - 1], this.specific);
        CommunicationEventService.getInstance().removeCommunicationListener(this.m_discoveryMonitor);
        super.dispose();
    }

    public FilteredAlarmsDialog(JFrame owner, SrTreeNode[] nodes) {
        super((Window)owner);
        this.setTitle("Selected Alarms");
        this.nodes = nodes;
        this.model.addNodes(this.nodes);
    }

    @Override
    protected void exit() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    protected void initComponents() {
    }

    @Override
    protected SrPanel createTablePanel() {
        this.model = new SrFilteredAlarmsTableModel();
        SrAlarmsTablePanel pan = new SrAlarmsTablePanel(this.model);
        pan.addAlarmsTableListener(this.m_pane);
        this.table = pan.getTable();
        pan.getScrollPane().getViewport().setBackground(LookAndFill.TABLE_SCROLL_BACKGROUND_COLOR);
        return pan;
    }

    class DiscoveryMonitor
    extends CommunicationAdapter {
        DiscoveryMonitor() {
        }

        @Override
        public void discoverStarted(CommunicationEvent e) {
            FilteredAlarmsDialog.this.dispose();
        }
    }
}

