/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.alarm.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.gui.alarm.AlarmsTextPane;
import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.swing.ImageObject;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.DefaultStyledDocument;

public abstract class AlarmsDialog
extends JDialog {
    protected JTable table;
    protected JButton closeBtn;
    protected JLabel totalRowsLbl;
    protected SrPanel labelPanel;
    protected SrPanel buttonsPanel;
    protected AlarmsTextPane m_pane;
    private SrPanel selectedAlarmPanel;

    public AlarmsDialog(Window owner, String title) {
        super(owner, title);
        this.setDefaultCloseOperation(2);
        this.init();
    }

    protected void init() {
        this.setIconImage(ImageObject.APP_ICON.getImageIcon().getImage());
        this.initComponents();
        this.layoutComponents();
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                AlarmsDialog.this.setStatusMessage();
            }
        });
        this.setStatusMessage();
        this.setSize(750, 500);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 4, screenSize.height / 4);
    }

    private void setStatusMessage() {
        this.totalRowsLbl.setText("Total " + this.table.getRowCount() + " items");
    }

    private void layoutComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.buttonsPanel = this.createButtonsPanel();
        this.selectedAlarmPanel = this.createSelectedAlarmPanel();
        SrPanel tablePanel = this.createTablePanel();
        SrPanel southPanel = new SrPanel();
        southPanel.setLayout(new BorderLayout());
        southPanel.add((Component)this.selectedAlarmPanel, "Center");
        southPanel.add((Component)this.buttonsPanel, "South");
        this.getContentPane().add((Component)tablePanel, "Center");
        this.getContentPane().add((Component)southPanel, "South");
    }

    protected SrPanel createSelectedAlarmPanel() {
        SrPanel panel = new SrPanel();
        this.m_pane = new AlarmsTextPane(new DefaultStyledDocument());
        this.m_pane.setEditable(false);
        this.m_pane.setBorder(BorderFactory.createLineBorder(Color.gray, 3));
        this.totalRowsLbl = new JLabel();
        this.totalRowsLbl.setFont(LookAndFill.STATUSBAR_LABEL_FONT);
        this.totalRowsLbl.setForeground(LookAndFill.STATUSBAR_LABEL_FOREGROUND);
        SrPanel labelPanel = new SrPanel();
        labelPanel.setLayout(new FlowLayout());
        labelPanel.add(this.totalRowsLbl);
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.m_pane, "Center");
        panel.add((Component)labelPanel, "South");
        panel.setBorder(new EmptyBorder(3, 3, 3, 3));
        return panel;
    }

    protected SrPanel createButtonsPanel() {
        this.labelPanel = this.createLabelPanel();
        this.buttonsPanel = new SrPanel();
        this.buttonsPanel.setLayout(new FlowLayout(2));
        JButton printBtn = new JButton("Print");
        printBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlarmsDialog.this.printTable();
            }
        });
        this.closeBtn = new JButton("Close");
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlarmsDialog.this.exit();
            }
        });
        this.buttonsPanel.add(this.closeBtn);
        SrPanel panel = new SrPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.labelPanel, "West");
        panel.add((Component)this.buttonsPanel, "East");
        return panel;
    }

    protected SrPanel createLabelPanel() {
        return new SrPanel();
    }

    protected SrPanel createTablePanel() {
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBorder(new EmptyBorder(8, 8, 8, 8));
        SrScrollPane scroll = new SrScrollPane(this.table);
        scroll.getViewport().setBackground(LookAndFill.TABLE_SCROLL_BACKGROUND_COLOR);
        mainPanel.add((Component)scroll, "Center");
        return mainPanel;
    }

    protected void exit() {
        this.setVisible(false);
        this.dispose();
    }

    protected void printTable() {
        Frame printJobWindow = null;
        Window alarmDialogOwner = this.getOwner();
        printJobWindow = alarmDialogOwner instanceof Frame ? (Frame)alarmDialogOwner : ClientLoader.getMainFrame();
        PrintJob thePrintJob = Toolkit.getDefaultToolkit().getPrintJob(printJobWindow, "print1 ", null);
        if (thePrintJob != null) {
            Graphics g = thePrintJob.getGraphics();
            this.table.print(g);
            this.table.printComponents(g);
            g.dispose();
            thePrintJob.end();
        }
    }

    protected abstract void initComponents();

    @Override
    public void setVisible(boolean visible) {
        final boolean fVisible = visible;
        EventDispatcherTask.submit(new Runnable(){

            @Override
            public void run() {
                AlarmsDialog.this.setItVisible(fVisible);
            }
        });
    }

    private void setItVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    public void show() {
        EventDispatcherTask.submit(new Runnable(){

            @Override
            public void run() {
                AlarmsDialog.this.letItShow();
            }
        });
    }

    private void letItShow() {
        super.show();
    }

    @Override
    public void dispose() {
        EventDispatcherTask.submit(new Runnable(){

            @Override
            public void run() {
                AlarmsDialog.this.disposeMe();
            }
        });
    }

    private void disposeMe() {
        super.dispose();
    }
}

