/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.alarm.dialogs;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.alarm.AlarmNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.util.Utility;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.OKCancelDialog;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrScrollPane;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.text.LimitedLinesDocument;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class AlarmPropertiesDialog
extends OKCancelDialog {
    protected SrClientLabel severityLbl;
    protected JLabel severityFld;
    protected SrClientLabel nameLbl;
    protected SrTextField nameFld;
    protected SrClientLabel idLbl;
    protected SrTextField idFld;
    protected SrClientLabel sourceNameLbl;
    protected SrTextField sourceNameFld;
    protected SrClientLabel clusterNameLbl;
    protected SrTextField clusterNameFld;
    protected SrClientLabel sourceTypeLbl;
    protected SrTextField sourceTypeFld;
    protected SrClientLabel textLbl;
    protected JTextPane textFld;
    protected SrClientLabel openedAtLbl;
    protected SrTextField openedAtFld;
    protected SrClientLabel closedAtLbl;
    protected SrTextField closedAtFld;
    protected SrClientLabel closedByLbl;
    protected SrTextField closedByFld;
    protected SrClientLabel ackLbl;
    protected JCheckBox ackCbox;
    protected SrClientLabel ackByLbl;
    protected SrTextField ackByFld;
    protected SrClientLabel ackAtLbl;
    protected SrTextField ackAtFld;
    protected SrClientLabel categoryLbl;
    protected SrTextField categoryFld;
    protected SrClientLabel probableCauseLbl;
    protected SrTextField probableCauseFld;
    protected SrScrollPane scroll;
    protected AlarmNode alarm;

    public AlarmPropertiesDialog(JFrame owner, AlarmNode al) {
        super(owner, "Alarm Properties", false);
        this.alarm = al;
        this.initComponents();
        this.fixSizes();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AlarmPropertiesDialog.this.alarm.setUserObject(null);
            }
        });
        this.setOKAction(new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                return null;
            }
        });
    }

    @Override
    public void dispose() {
        this.alarm.setUserObject(null);
        super.dispose();
    }

    protected void fixSizes() {
        Dimension dim = this.probableCauseLbl.getPreferredSize();
        this.severityLbl.setPreferredSize(dim);
        this.nameLbl.setPreferredSize(dim);
        this.idLbl.setPreferredSize(dim);
        this.sourceNameLbl.setPreferredSize(dim);
        this.clusterNameLbl.setPreferredSize(dim);
        this.sourceTypeLbl.setPreferredSize(dim);
        this.textLbl.setPreferredSize(dim);
        this.openedAtLbl.setPreferredSize(dim);
        this.closedAtLbl.setPreferredSize(dim);
        this.categoryLbl.setPreferredSize(dim);
        this.probableCauseLbl.setPreferredSize(dim);
        if (this.ackLbl != null) {
            this.ackLbl.setPreferredSize(dim);
            this.ackByLbl.setPreferredSize(dim);
            this.ackAtLbl.setPreferredSize(dim);
        }
        dim = this.probableCauseFld.getPreferredSize();
        this.nameFld.setPreferredSize(dim);
        this.idFld.setPreferredSize(dim);
        this.sourceNameFld.setPreferredSize(dim);
        this.clusterNameFld.setPreferredSize(dim);
        this.sourceTypeFld.setPreferredSize(dim);
        this.openedAtFld.setPreferredSize(dim);
        this.categoryFld.setPreferredSize(dim);
        if (this.ackByFld != null) {
            this.ackAtFld.setPreferredSize(dim);
            this.ackByFld.setPreferredSize(dim);
        }
        this.scroll.setPreferredSize(new Dimension(dim.width + 35, dim.height + 35));
    }

    private SrPanel createSeverityPanel(SrClientLabel severityLbl, JLabel iconLbl, JLabel severityFld) {
        JPanel sPanel = new JPanel();
        SrPanel iconPanel = new SrPanel();
        iconPanel.setLayout(new FlowLayout());
        sPanel.setLayout(new FlowLayout());
        sPanel.setBackground(severityFld.getBackground());
        sPanel.setBorder(BorderFactory.createLineBorder(severityFld.getForeground()));
        sPanel.add(severityFld);
        iconPanel.add(iconLbl);
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new FlowLayout());
        mainPanel.add(iconPanel);
        mainPanel.add(sPanel);
        return this.createSrPanel(severityLbl, mainPanel);
    }

    protected void initComponents() {
        JTabbedPane tabsPanel = new JTabbedPane();
        tabsPanel.setBackground(LookAndFill.DIALOG_COLOR);
        tabsPanel.addTab("General", this.createGeneralPanel());
        if (this.alarm.isAcknowledged()) {
            tabsPanel.addTab("Acknowledge", this.createAckPanel());
        }
        tabsPanel.addTab("Troubleshooting", this.createTroubleshhotingTab());
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)tabsPanel, "Center");
        this.addCenterPanel(mainPanel);
        this.setComponentBgColor(this.buttonsPanel);
    }

    private SrPanel createAckPanel() {
        this.ackLbl = new SrClientLabel("Ack: ");
        this.ackCbox = new JCheckBox();
        this.ackCbox.setEnabled(false);
        this.ackCbox.setSelected(this.alarm.isAcknowledged());
        this.setComponentBgColor(this.ackCbox);
        SrPanel ackPanel = this.createSrPanel(this.ackLbl, this.ackCbox);
        this.ackByLbl = new SrClientLabel("Ack By: ");
        this.ackByFld = new SrTextField(false);
        this.ackByFld.setText(this.alarm.getAcknowledgedBy());
        SrPanel ackByPanel = this.createSrPanel(this.ackByLbl, this.ackByFld);
        this.ackAtLbl = new SrClientLabel("Ack At: ");
        this.ackAtFld = new SrTextField(false);
        this.ackAtFld.setText(this.alarm.getAcknowledgedAt().toString());
        SrPanel ackAtPanel = this.createSrPanel(this.ackAtLbl, this.ackAtFld);
        SrPanel mainAckPanel = new SrPanel();
        mainAckPanel.setLayout(new GridLayout(3, 1));
        mainAckPanel.add(ackPanel);
        mainAckPanel.add(ackByPanel);
        mainAckPanel.add(ackAtPanel);
        SrPanel panel = new SrPanel();
        panel.setLayout(new GridLayout(2, 1));
        panel.add(mainAckPanel);
        panel.add(new SrPanel());
        return panel;
    }

    private SrPanel createTroubleshhotingTab() {
        JTextPane textArea = new JTextPane(new LimitedLinesDocument());
        this.setFontOfTextPane(textArea);
        String troubleShooting = AlarmsManager.getInstance().getAlarmTroubleshooting(this.alarm.getAlarmId());
        if (troubleShooting != null) {
            textArea.setText(troubleShooting);
        }
        textArea.setEditable(false);
        SrScrollPane scroll = new SrScrollPane(textArea);
        SrPanel panel = new SrPanel(new BorderLayout());
        panel.add((Component)scroll, "Center");
        return panel;
    }

    private SrPanel createGeneralPanel() {
        SrPanel panel = new SrPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int rowIndex = 0;
        c.weighty = 0.1;
        c.weightx = 0.5;
        c.anchor = 23;
        c.fill = 1;
        Insets panelInsets = new Insets(10, 10, 5, 10);
        this.severityLbl = new SrClientLabel("Severity: ");
        this.severityFld = new JLabel(this.alarm.getSeverity().toString());
        Color backgroundColor = this.alarm.getSeverity().color();
        this.severityFld.setBackground(backgroundColor);
        if (backgroundColor.equals(Color.yellow)) {
            this.severityFld.setForeground(Color.black);
        } else {
            this.severityFld.setForeground(Color.white);
        }
        JLabel iconLbl = new JLabel(Utility.getInstance().getSeverityIcon(this.alarm.getSeverity()));
        SrPanel severityPanel = this.createSeverityPanel(this.severityLbl, iconLbl, this.severityFld);
        this.addGuiRow(panel, severityPanel, c, rowIndex++, panelInsets);
        panelInsets = new Insets(5, 10, 5, 10);
        this.nameLbl = new SrClientLabel("Name: ");
        this.nameFld = new SrTextField(false);
        this.nameFld.setText(this.alarm.getName());
        SrPanel namePanel = this.createSrPanel(this.nameLbl, this.nameFld);
        this.addGuiRow(panel, namePanel, c, rowIndex++, panelInsets);
        this.idLbl = new SrClientLabel("ID: ");
        this.idFld = new SrTextField(false);
        this.idFld.setText(this.alarm.getAlarmId());
        SrPanel idPanel = this.createSrPanel(this.idLbl, this.idFld);
        this.addGuiRow(panel, idPanel, c, rowIndex++, panelInsets);
        this.clusterNameLbl = new SrClientLabel("Cluster Name: ");
        this.clusterNameFld = new SrTextField(false);
        this.clusterNameFld.setText(this.alarm.getClusterPath().toString());
        SrPanel clusterNamePanel = this.createSrPanel(this.clusterNameLbl, this.clusterNameFld);
        this.addGuiRow(panel, clusterNamePanel, c, rowIndex++, panelInsets);
        this.sourceNameLbl = new SrClientLabel("Source Name: ");
        this.sourceNameFld = new SrTextField(false);
        this.sourceNameFld.setText(this.alarm.getSource().toString());
        SrPanel sourceNamePanel = this.createSrPanel(this.sourceNameLbl, this.sourceNameFld);
        this.addGuiRow(panel, sourceNamePanel, c, rowIndex++, panelInsets);
        this.sourceTypeLbl = new SrClientLabel("Source Type: ");
        this.sourceTypeFld = new SrTextField(false);
        SrTreeNode src = this.alarm.getSource();
        if (src instanceof SrTreeNode) {
            this.sourceTypeFld.setText(src.type());
        }
        SrPanel sourceTypePanel = this.createSrPanel(this.sourceTypeLbl, this.sourceTypeFld);
        this.addGuiRow(panel, sourceTypePanel, c, rowIndex++, panelInsets);
        this.openedAtLbl = new SrClientLabel("Opened At: ");
        this.openedAtFld = new SrTextField(false);
        this.openedAtFld.setText(this.alarm.openedAt().toString());
        SrPanel openedAtPanel = this.createSrPanel(this.openedAtLbl, this.openedAtFld);
        this.addGuiRow(panel, openedAtPanel, c, rowIndex++, panelInsets);
        this.categoryLbl = new SrClientLabel("Category: ");
        this.categoryFld = new SrTextField(false);
        this.categoryFld.setText(this.alarm.getCategory());
        SrPanel categoryPanel = this.createSrPanel(this.categoryLbl, this.categoryFld);
        this.addGuiRow(panel, categoryPanel, c, rowIndex++, panelInsets);
        this.probableCauseLbl = new SrClientLabel("Probable Cause: ");
        this.probableCauseFld = new SrTextField(false);
        this.probableCauseFld.setText(this.alarm.getProbableCause());
        SrPanel probableCausePanel = this.createSrPanel(this.probableCauseLbl, this.probableCauseFld);
        this.addGuiRow(panel, probableCausePanel, c, rowIndex++, panelInsets);
        this.textLbl = new SrClientLabel("Description: ");
        this.textFld = new JTextPane(new LimitedLinesDocument());
        this.textFld.setFont(LookAndFill.GENERAL_FONT);
        this.scroll = new SrScrollPane(this.textFld);
        this.setFontOfTextPane(this.textFld);
        this.textFld.setText(this.alarm.getText());
        this.textFld.setEditable(false);
        SrPanel textPanel = this.createSrPanel(this.textLbl, this.scroll);
        this.addGuiRow(panel, textPanel, c, rowIndex++, panelInsets);
        this.closedAtLbl = new SrClientLabel("Closed At: ");
        this.closedAtFld = new SrTextField(false);
        return panel;
    }

    private void addGuiRow(SrPanel panel1, SrPanel panel2, GridBagConstraints c, int rowIndex, Insets leftInsets) {
        c.insets = leftInsets;
        c.gridx = 0;
        c.gridy = rowIndex;
        panel1.add((Component)panel2, c);
    }

    @Override
    public void doOnCancel() {
    }

    private void setFontOfTextPane(JTextPane textPane) {
        StyleContext context = StyleContext.getDefaultStyleContext();
        Style def = context.getStyle("default");
        Style style = textPane.addStyle("FONT", def);
        StyleConstants.setFontFamily(style, LookAndFill.GENERAL_FONT.getFamily());
        StyleConstants.setFontSize(style, LookAndFill.GENERAL_FONT.getSize());
    }

    @Override
    public void removeListeners() {
    }
}

