/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.alarm.dialogs;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.alarm.AlarmsConfigurationTableModelCollection;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.alarm.SrAlarmsConfigurationTableModel;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.alarm.SrAlarmsConfigurationTablePanel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.OKCancelDialog;
import com.sanrad.swing.SrPanel;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JFrame;

public class AlarmNotificationConfigurationDialog
extends OKCancelDialog {
    private SrAlarmsConfigurationTablePanel table;
    private SrAlarmsConfigurationTableModel model;

    public AlarmNotificationConfigurationDialog(JFrame owner) {
        super(owner, "Alarms Notification Configuration", false);
        this.initComponents();
        this.setSizeAndMoveToCenter(400, 500);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AlarmNotificationConfigurationDialog.this.closeMe();
            }
        });
        SrClientAction<Void, Void> okAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                List mailEnabled = AlarmNotificationConfigurationDialog.this.model.getChangedMailEnabledAlarmTypes(true);
                List mailDisabled = AlarmNotificationConfigurationDialog.this.model.getChangedMailEnabledAlarmTypes(false);
                ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
                return Collections.singleton(AlarmsManager.getInstance().configureAlarmTypes(clusterNode, mailEnabled, mailDisabled));
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                return null;
            }
        };
        this.setOKAction(okAction);
    }

    protected void initComponents() {
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        this.model = (SrAlarmsConfigurationTableModel)AlarmsConfigurationTableModelCollection.getInstance().getCurrentModel();
        this.table = new SrAlarmsConfigurationTablePanel(this.model);
        mainPanel.add((Component)this.table, "Center");
        this.addCenterPanel(mainPanel);
        this.setComponentBgColor(this.buttonsPanel);
    }

    @Override
    public void doOnCancel() {
        this.closeMe();
    }

    private void closeMe() {
        this.dispose();
    }

    @Override
    public void removeListeners() {
    }
}

