/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.alarm;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.alarm.AlarmNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.alarm.SrAlarmsTableModel;
import com.sanrad.nms.client.data.alarm.SrAlarmsTablePopupMenu;
import com.sanrad.nms.client.event.alarm.AlarmsTableEvent;
import com.sanrad.nms.client.event.alarm.AlarmsTableListener;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.alarm.AlarmsTableRenderer;
import com.sanrad.nms.client.gui.alarm.CurrentAlarmsTableHeader;
import com.sanrad.nms.client.gui.alarm.dialogs.AlarmPropertiesDialog;
import com.sanrad.nms.client.gui.components.SrClientCheckBox;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrCheckboxTableCellEditor;
import com.sanrad.swing.SrTableModel;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.table.event.TableCellEditEvent;
import com.sanrad.swing.table.event.TableCellEditListener;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;

public class SrAlarmsTablePanel
extends SrTablePanel
implements View<AlarmNode> {
    private static SrLogger theLogger = SrLogger.getLogger();
    private SrAlarmsTablePopupMenu m_popup;
    SrEventListenerManager.Informer<AlarmsTableListener, AlarmsTableEvent> rowsSelectedInformer = new SrEventListenerManager.Informer<AlarmsTableListener, AlarmsTableEvent>(){

        @Override
        public void inform(AlarmsTableListener listener, AlarmsTableEvent event) {
            listener.rowsSelected(event);
        }
    };
    SrEventListenerManager.Informer<AlarmsTableListener, AlarmsTableEvent> emptySelectionInformer = new SrEventListenerManager.Informer<AlarmsTableListener, AlarmsTableEvent>(){

        @Override
        public void inform(AlarmsTableListener listener, AlarmsTableEvent event) {
            if (event != null) {
                throw new IllegalArgumentException("event is disregarded, must be null!");
            }
            listener.emptySelection();
        }
    };
    public final SrClientAction PROPERTIES_ACTION = new PropertiesAction();
    public final SrClientAction CLOSE_ACTION = new CloseAction();
    public final SrClientAction SOURCE_ACTION = new SourceAction<AlarmNode>(this);
    public final SrClientAction ACKNOWLEDGE_ACTION = new AcknowledgeAction();

    public SrAlarmsTablePanel(SrTableModel model) {
        super(model);
        this.setSelectionMode(2);
        this.m_popup = new SrAlarmsTablePopupMenu(this);
        this.setTablePopUpMenuObject(this.m_popup);
        this.getTable().setSelectionBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
        this.getTable().setSelectionForeground(Color.black);
        this.getTable().setShowGrid(true);
        this.getTable().setColumnSelectionAllowed(false);
        this.setTableRenderer();
        JTableHeader header = this.getTable().getTableHeader();
        header.setUpdateTableInRealTime(true);
        header.setFont(new Font("Verdana", 0, 9));
        this.setHeaderWidth();
        this.setHeaderStartupSortColumnSign();
        this.addTableCellEditListener(new TableCellEditListener(){
            Boolean m_oldAcknowledgeValue;
            int m_ackColumn;
            {
                this.m_ackColumn = SrAlarmsTablePanel.this.getModel().getColumnIndex(CurrentAlarmsTableHeader.ACK.getColumnName());
            }

            @Override
            public void tableEditingCanceled(TableCellEditEvent e) {
            }

            @Override
            public void tableEditingStopped(TableCellEditEvent e) {
                if (e.getEditingColumn() == this.m_ackColumn) {
                    int alarmCol = SrAlarmsTablePanel.this.getModel().getColumnIndex(CurrentAlarmsTableHeader.NAME.getColumnName());
                    AlarmNode alarm = (AlarmNode)SrAlarmsTablePanel.this.getTable().getValueAt(e.getEditingRow(), alarmCol);
                    Boolean newAcknowledgeValue = (Boolean)e.getEditorValue();
                    if (newAcknowledgeValue != null && this.m_oldAcknowledgeValue != null && !newAcknowledgeValue.equals(this.m_oldAcknowledgeValue)) {
                        ArrayList<String> hashKeyList = new ArrayList<String>();
                        hashKeyList.add((String)alarm.getIdentifier());
                        if (newAcknowledgeValue.booleanValue()) {
                            SrClientAction.blockActions(Collections.singleton(ClientAOImpl.getInstance().acknowledgeAlarms(hashKeyList, 0L)), StatusPanel.getInstance());
                        } else {
                            SrClientAction.blockActions(Collections.singleton(ClientAOImpl.getInstance().unacknowledgeAlarms(hashKeyList, 0L)), StatusPanel.getInstance());
                        }
                        SrAlarmsTablePanel.this.getTable().setValueAt(this.m_oldAcknowledgeValue, e.getEditingRow(), e.getEditingColumn());
                    }
                    this.m_oldAcknowledgeValue = null;
                }
            }

            @Override
            public void tableEditingStarted(TableCellEditEvent e) {
                if (e.getEditingColumn() == this.m_ackColumn) {
                    this.m_oldAcknowledgeValue = (Boolean)e.getTableCellValue();
                }
            }
        });
    }

    protected void setHeaderStartupSortColumnSign() {
        int openAtIndex = this.getModel().getColumnIndex(CurrentAlarmsTableHeader.OPENED_AT.getColumnName());
        this.invokeColumnSortOnStartup(openAtIndex, false);
    }

    public void addAlarmsTableListener(AlarmsTableListener l) {
        this.m_listeners.add(l);
    }

    public void removeAlarmsTableListener(AlarmsTableListener l) {
        this.m_listeners.remove(l);
    }

    @Override
    protected void rowSelectionChanged(int[] rowIndices) {
        if (rowIndices.length > 0) {
            AlarmNode alarm = ((SrAlarmsTableModel)this.getModel()).getSelectedAlarm(rowIndices[0]);
            if (alarm != null) {
                AlarmsTableEvent event = new AlarmsTableEvent(this, alarm);
                this.m_listeners.fireEvent(AlarmsTableListener.class, event, this.rowsSelectedInformer);
            }
        } else {
            this.m_listeners.fireEvent(AlarmsTableListener.class, null, this.emptySelectionInformer);
        }
    }

    protected void setHeaderWidth() {
        int index = this.getModel().getColumnIndex(CurrentAlarmsTableHeader.SEVERITY.getColumnName());
        this.getTable().getColumnModel().getColumn(index).setPreferredWidth(60);
        index = this.getModel().getColumnIndex(CurrentAlarmsTableHeader.TEXT.getColumnName());
        this.getTable().getColumnModel().getColumn(index).setPreferredWidth(400);
        index = this.getModel().getColumnIndex(CurrentAlarmsTableHeader.NAME.getColumnName());
        this.getTable().getColumnModel().getColumn(index).setPreferredWidth(60);
        index = this.getModel().getColumnIndex(CurrentAlarmsTableHeader.CLUSTER.getColumnName());
        this.getTable().getColumnModel().getColumn(index).setPreferredWidth(60);
        index = this.getModel().getColumnIndex(CurrentAlarmsTableHeader.SOURCE.getColumnName());
        this.getTable().getColumnModel().getColumn(index).setPreferredWidth(60);
        index = this.getModel().getColumnIndex(CurrentAlarmsTableHeader.ACK.getColumnName());
        this.getTable().getColumnModel().getColumn(index).setPreferredWidth(60);
        index = this.getModel().getColumnIndex(CurrentAlarmsTableHeader.ACK_AT.getColumnName());
        this.getTable().getColumnModel().getColumn(index).setPreferredWidth(60);
        index = this.getModel().getColumnIndex(CurrentAlarmsTableHeader.ACK_BY.getColumnName());
        this.getTable().getColumnModel().getColumn(index).setPreferredWidth(70);
        index = this.getModel().getColumnIndex(CurrentAlarmsTableHeader.OPENED_AT.getColumnName());
        this.getTable().getColumnModel().getColumn(index).setPreferredWidth(175);
    }

    private void setTableRenderer() {
        int ackIndex = this.getModel().getColumnIndex(CurrentAlarmsTableHeader.ACK.getColumnName());
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            if (i == ackIndex) continue;
            this.getTable().getColumnModel().getColumn(i).setCellRenderer(new AlarmsTableRenderer());
        }
        if (ackIndex != -1) {
            SrClientCheckBox check = (SrClientCheckBox)this.getModel().getDefault(ackIndex);
            this.getTable().getColumnModel().getColumn(ackIndex).setCellEditor(new SrCheckboxTableCellEditor(check));
        }
    }

    public List getSelectedAlarms() {
        int[] rows = this.getSelectedRows();
        int alarmCol = this.getModel().getColumnIndex(CurrentAlarmsTableHeader.NAME.getColumnName());
        ArrayList<Object> alarms = new ArrayList<Object>();
        for (int i = 0; i < rows.length; ++i) {
            Object alarm = this.getModel().getValueAt(rows[i], alarmCol);
            alarms.add(alarm);
        }
        return alarms;
    }

    private static boolean allAlarmsAreInSameAckState(Collection<AlarmNode> alarms) {
        Iterator<AlarmNode> iter = alarms.iterator();
        boolean ackValue = iter.next().isAcknowledged();
        while (iter.hasNext()) {
            if (iter.next().isAcknowledged() == ackValue) continue;
            return false;
        }
        return true;
    }

    private List getSelectedAlarmsStubs() {
        int alarmCol = this.getModel().getColumnIndex(CurrentAlarmsTableHeader.NAME.getColumnName());
        ArrayList alarms = new ArrayList();
        int[] rows = this.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            Object alarm = this.getModel().getValueAt(rows[i], alarmCol);
            alarms.add(((AlarmNode)alarm).getStub());
        }
        return alarms;
    }

    @Override
    public Collection<AlarmNode> getValue() {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<AlarmNode> retVal = new ArrayList<AlarmNode>(selectedRows.length);
        int colIndex = this.getModel().getColumnIndex(CurrentAlarmsTableHeader.NAME.getColumnName());
        if (selectedRows != null) {
            for (int i = 0; i < selectedRows.length; ++i) {
                if (selectedRows[i] >= this.getRowCount()) continue;
                retVal.add((AlarmNode)this.getModel().getValueAt(selectedRows[i], colIndex));
            }
        }
        return retVal;
    }

    @Override
    public void addListener(SrAction<AlarmNode, ?> action) {
        this.m_table.getSelectionModel().addListSelectionListener(new View.ViewListSelectionListener(action));
    }

    @Override
    public void removeListener(SrAction<AlarmNode, ?> action) {
        this.m_table.getSelectionModel().removeListSelectionListener(new View.ViewListSelectionListener(action));
    }

    private class AcknowledgeAction
    extends SrClientAction<AlarmNode, Void> {
        private boolean myIsAcknowledge;

        public AcknowledgeAction() {
            super(false, false, SrAlarmsTablePanel.this, SrLicenseTreePath.GENERAL_PATH);
            SrAlarmsTablePanel.this.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent arg0) {
                    AcknowledgeAction.this.updateEnabled();
                }
            });
            this.addControllerAsListener(StatusPanel.getInstance());
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<AlarmNode> arg) {
            ArrayList<String> stubs = new ArrayList<String>(arg.size());
            for (AlarmNode alarm : arg) {
                stubs.add((String)alarm.getIdentifier());
            }
            if (this.myIsAcknowledge) {
                return Collections.singleton(ClientAOImpl.getInstance().acknowledgeAlarms(stubs, 0L));
            }
            return Collections.singleton(ClientAOImpl.getInstance().unacknowledgeAlarms(stubs, 0L));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            Collection alarms = this.myView.getValue();
            if (!SrAlarmsTablePanel.allAlarmsAreInSameAckState(alarms)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.ALARMS_POPUP_NOT_ALL_ALARMS_ARE_IN_SAME_ACK_STATE);
            }
            this.myIsAcknowledge = !((AlarmNode)alarms.iterator().next()).isAcknowledged();
            this.setName(this.myIsAcknowledge ? "Acknowledge" : "UnAcknowledge");
            return null;
        }
    }

    public static class SourceAction<T extends SrTreeNode>
    extends SrClientAction<T, Void> {
        public SourceAction(View<T> aView) {
            super("Source", false, false, aView, SrLicenseTreePath.GENERAL_PATH, true);
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<T> arg) {
            SrTreeNode node = (SrTreeNode)arg.iterator().next();
            boolean isAlarm = node instanceof AlarmNode;
            AlarmNode alarm = isAlarm ? (AlarmNode)node : null;
            SrTreeNode source = isAlarm ? alarm.getSource() : node;
            AlarmsManager.getInstance().notifySourceSelected(alarm, source);
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }

        @Override
        public String getMultipleSelectionTooltip() {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.ALARMS_POPUP_MORE_THAN_ONE_ALARM_SELECTED);
        }
    }

    private class CloseAction
    extends SrClientAction<AlarmNode, Void> {
        public CloseAction() {
            super(false, false, SrAlarmsTablePanel.this, SrLicenseTreePath.GENERAL_PATH);
            this.setName("Close");
            this.addControllerAsListener(StatusPanel.getInstance());
            this.setConfirmationString("Are you sure you want to close the selected Alarms?");
            this.setConfirmationTitle("Close Alarm");
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<AlarmNode> arg) {
            ArrayList<String> toClose = new ArrayList<String>(arg.size());
            for (AlarmNode value : arg) {
                theLogger.trace(SrLogCategories.LEGACY, "CurrentAlarmsTable:: trying to close - ", value.logString());
                toClose.add((String)value.getIdentifier());
            }
            return Collections.singleton(AlarmsManager.getInstance().closeAlarms(toClose));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    private class PropertiesAction
    extends SrClientAction<AlarmNode, Void> {
        public PropertiesAction() {
            super(false, false, SrAlarmsTablePanel.this, SrLicenseTreePath.GENERAL_PATH);
            this.setName("Properties");
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<AlarmNode> arg) {
            JFrame frame = new JFrame();
            frame.setIconImage(ClientImageObject.APP_ICON.getImageIcon().getImage());
            int i = 0;
            for (AlarmNode alarm : arg) {
                JDialog dialog = (JDialog)alarm.getUserObject();
                if (dialog == null) {
                    AlarmPropertiesDialog props = new AlarmPropertiesDialog(frame, alarm);
                    alarm.setUserObject(props);
                    int x = (int)props.getLocation().getX();
                    int y = (int)props.getLocation().getY();
                    props.setLocation(x + i * 5, y + i * 5);
                    props.show();
                } else {
                    dialog.requestFocus();
                }
                ++i;
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }
}

