/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.alarm;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.alarm.AlarmNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.event.alarm.AlarmsEvent;
import com.sanrad.nms.client.event.alarm.AlarmsManagerListener;
import com.sanrad.nms.client.event.alarm.AlarmsTableEvent;
import com.sanrad.nms.client.event.alarm.AlarmsTableListener;
import com.sanrad.nms.client.gui.util.Utility;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.swing.LookAndFill;
import java.awt.Color;
import javax.swing.ImageIcon;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class AlarmsTextPane
extends JTextPane
implements AlarmsTableListener,
AlarmsManagerListener {
    private static SrLogger theLogger = SrLogger.getLogger();
    public static final String REGULAR = "Regular";
    public static final String BOLD = "Bold";
    public static final String ICON_SEVERITY = "IconSeverity";
    public static final String ICON_SOURCE = "IconSource";
    public static final String COLORED_TEXT = "Colored";
    private AlarmNode alarm;

    public AlarmsTextPane() {
        AlarmsManager.getInstance().addAlarmListener(this);
    }

    public void removeListeners() {
        AlarmsManager.getInstance().removeAlarmListener(this);
    }

    public AlarmsTextPane(StyledDocument doc) {
        super(doc);
        AlarmsManager.getInstance().addAlarmListener(this);
        StyleContext context = StyleContext.getDefaultStyleContext();
        Style def = context.getStyle("default");
        Style regular = this.addStyle(REGULAR, def);
        StyleConstants.setFontFamily(regular, LookAndFill.GENERAL_FONT.getFamily());
        StyleConstants.setFontSize(regular, LookAndFill.GENERAL_FONT.getSize());
        Style coloredText = this.addStyle(COLORED_TEXT, def);
        StyleConstants.setForeground(coloredText, Color.black);
        StyleConstants.setFontFamily(coloredText, LookAndFill.GENERAL_FONT.getFamily());
        StyleConstants.setFontSize(coloredText, LookAndFill.GENERAL_FONT.getSize());
    }

    @Override
    public void rowsSelected(AlarmsTableEvent e) {
        this.alarm = e.getAlarm();
        try {
            ImageIcon severityIcon = Utility.getInstance().getSeverityIcon(this.alarm.getSeverity());
            SrTreeNode source = this.alarm.getSource();
            ImageIcon sourceIcon = null;
            if (source instanceof SrTreeNode) {
                sourceIcon = source.getNodeIcon();
            }
            Style iconSeverityStyle = this.getStyle(ICON_SEVERITY);
            Style iconSourceStyle = this.getStyle(ICON_SOURCE);
            if (severityIcon != null && iconSeverityStyle != null) {
                StyleConstants.setIcon(iconSeverityStyle, severityIcon);
                if (sourceIcon != null) {
                    StyleConstants.setIcon(iconSourceStyle, sourceIcon);
                }
            }
            Document doc = this.getDocument();
            Style regular = this.getStyle(REGULAR);
            Style iconSeverityRegular = this.getStyle(ICON_SEVERITY);
            Style iconSourceRegular = this.getStyle(ICON_SOURCE);
            Style coloredText = this.getStyle(COLORED_TEXT);
            StringBuffer date = new StringBuffer();
            date.append(" ");
            date.append(this.alarm.openedAt().toString());
            date.append(" ");
            doc.remove(0, doc.getLength());
            doc.insertString(doc.getLength(), "  ", iconSeverityRegular);
            doc.insertString(doc.getLength(), date.toString(), regular);
            doc.insertString(doc.getLength(), "  ", iconSourceRegular);
            doc.insertString(doc.getLength(), " " + this.alarm.getText(), coloredText);
        }
        catch (BadLocationException ble) {
            theLogger.warn(SrLogCategories.LEGACY, ble);
        }
    }

    @Override
    public void emptySelection() {
        this.clear();
    }

    public void clear() {
        try {
            Document doc = this.getDocument();
            doc.remove(0, doc.getLength());
        }
        catch (BadLocationException ble) {
            theLogger.warn(SrLogCategories.LEGACY, ble, "Could not clear selected alarm panel...");
        }
    }

    @Override
    public void alarmOpened(AlarmsEvent event) {
    }

    @Override
    public void alarmClosed(AlarmsEvent event) {
        AlarmNode alarm;
        Object alarmObj = AlarmsManager.getInstance().getAlarmByStub((Alarm)event.getStub());
        if (alarmObj != null && (alarm = (AlarmNode)alarmObj).equals(this.alarm)) {
            this.clear();
        }
    }

    @Override
    public void alarmChanged(AlarmsEvent event) {
    }

    @Override
    public void alarmsDeleted(AlarmsEvent event) {
        this.clear();
    }

    @Override
    public void alarmsReadFromServer(AlarmsEvent event) {
    }
}

