/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.actions.volume;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.MainFrame;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.volume.wizard.exchange.SrExchangeVolumeWizardFrame;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;

public class VolumeActions {
    private static String SERVER_VOLUME_WIZARD_ACTION_NAME = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_CONFIG_SERVER_VOLUME);
    private static VolumeActions theInstance;
    private MainFrame myMainFrame;
    private SrClientAction<ClusterNode, Void> myExchangeVolumeWizardMainMenuAction;
    private SrClientAction<ClusterNode, Void> myExchangeVolumeWizardDropdownMenuAction;

    private VolumeActions(MainFrame aMainFrame) {
        Util.validateInputNotNull(aMainFrame, "MainFrame");
        this.myMainFrame = aMainFrame;
        this.myExchangeVolumeWizardMainMenuAction = new OpenExchangeVolumeWizardAction((Icon)ClientImageObject.MENU_CREATE_EXCHANGE_VOLUME.getImageIcon());
        this.myExchangeVolumeWizardDropdownMenuAction = new OpenExchangeVolumeWizardAction((Icon)ClientImageObject.DROPDOWN_MENU_EXCHANGE_VOLUME.getImageIcon());
    }

    public static VolumeActions getInstance() {
        if (theInstance == null) {
            throw new IllegalStateException("You have to call VolumeActions.init(MainFrame) before using this method");
        }
        return theInstance;
    }

    public static void init(MainFrame aMainFrame) {
        theInstance = new VolumeActions(aMainFrame);
    }

    public SrClientAction<ClusterNode, Void> getExchangeVolumeWizardMainMenuAction() {
        return this.myExchangeVolumeWizardMainMenuAction;
    }

    public SrClientAction<ClusterNode, Void> getExchangeVolumeWizardDropdownMenuAction() {
        return this.myExchangeVolumeWizardDropdownMenuAction;
    }

    private class OpenExchangeVolumeWizardAction
    extends SrClientAction<ClusterNode, Void> {
        private static final long serialVersionUID = 1L;

        public OpenExchangeVolumeWizardAction(Icon aIcon) {
            super(SERVER_VOLUME_WIZARD_ACTION_NAME, aIcon, true, true, VolumeActions.this.myMainFrame.getMainTreeView(ClusterNode.class), SrLicenseTreePath.VOLUME_PATH);
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> aArg) {
            SrExchangeVolumeWizardFrame wiz = new SrExchangeVolumeWizardFrame(aArg.iterator().next());
            wiz.runWizard();
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return ClusterManager.getInstance().validateClustersInSystem();
        }
    }
}

