/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.actions.target;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.target.qos.TargetQosGroupNode;
import com.sanrad.nms.client.data.target.qos.TargetQosGroupsManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.MainFrame;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.actions.TreeView;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class TargetActions {
    private static final String LOW_QOS_ALIAS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_QOS_LOW_GROUP_ALIAS_VALUE);
    private static final String HIGH_QOS_ALIAS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_QOS_HIGH_GROUP_ALIAS_VALUE);
    private static TargetActions theInstance;
    private MainFrame myMainFrame;
    private SrClientAction<TargetNode, Void> mySetLowQosAction;
    private SrClientAction<TargetNode, Void> mySetHighQosAction;

    public static TargetActions getInstance() {
        return theInstance;
    }

    private TargetActions(MainFrame aMainFrame) {
        this.myMainFrame = aMainFrame;
        this.mySetLowQosAction = new SetLowQosAction();
        this.mySetHighQosAction = new SetHighQosAction();
    }

    public static void init(MainFrame aMainFrame) {
        theInstance = new TargetActions(aMainFrame);
    }

    public SrClientAction<TargetNode, Void> getSetLowQosAction() {
        return this.mySetLowQosAction;
    }

    public SrClientAction<TargetNode, Void> getSetHighQosAction() {
        return this.mySetHighQosAction;
    }

    private boolean isTargetVswitchConnected(TargetNode aTarget) {
        VSwitchNode expsoedOnVs = aTarget.getExposedOnVSwitchNode();
        return expsoedOnVs != null && expsoedOnVs.isConnected();
    }

    private class SetHighQosAction
    extends SrClientAction<TargetNode, Void> {
        private static final long serialVersionUID = 1L;

        SetHighQosAction() {
            super(HIGH_QOS_ALIAS, true, true, new TreeView<TargetNode>(TargetActions.this.myMainFrame.getMainTreePanel().getTreeObject(), TargetNode.class), SrLicenseTreePath.GENERAL_PATH, true);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<TargetNode> arg) {
            TargetNode target = arg.iterator().next();
            HashMap<ClientParameterCode, Object> params = new HashMap<ClientParameterCode, Object>();
            params.put(ClientParameterCode.ISCSI_TARGET_QOS_GROUP_ID, null);
            return Collections.singleton(ClientAOImpl.getInstance().changeElements(Collections.singleton(target.getIdentifier()), params));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            TargetNode target = (TargetNode)this.myView.getValue().iterator().next();
            this.putValue("SwingSelectedKey", target.getQosGroup() == null);
            if (!TargetActions.this.isTargetVswitchConnected(target)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VSWITCH_DISCONNECTED);
            }
            TargetQosGroupNode qosGroup = TargetQosGroupsManager.getInstance().getQosGroup(target.getExposedOnVSwitchNode());
            if (qosGroup == null) {
                return "QoS not available";
            }
            return null;
        }
    }

    private class SetLowQosAction
    extends SrClientAction<TargetNode, Void> {
        private static final long serialVersionUID = 1L;

        SetLowQosAction() {
            super(LOW_QOS_ALIAS, true, true, new TreeView<TargetNode>(TargetActions.this.myMainFrame.getMainTreePanel().getTreeObject(), TargetNode.class), SrLicenseTreePath.GENERAL_PATH, true);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<TargetNode> arg) {
            TargetNode target = arg.iterator().next();
            TargetQosGroupNode qosGroup = TargetQosGroupsManager.getInstance().getQosGroup(target.getExposedOnVSwitchNode());
            HashMap params = new HashMap();
            params.put(ClientParameterCode.ISCSI_TARGET_QOS_GROUP_ID, qosGroup.getIdentifier());
            return Collections.singleton(ClientAOImpl.getInstance().changeElements(Collections.singleton(target.getIdentifier()), params));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            TargetNode target = (TargetNode)this.myView.getValue().iterator().next();
            this.putValue("SwingSelectedKey", target.getQosGroup() != null);
            if (!TargetActions.this.isTargetVswitchConnected(target)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VSWITCH_DISCONNECTED);
            }
            TargetQosGroupNode qosGroup = TargetQosGroupsManager.getInstance().getQosGroup(target.getExposedOnVSwitchNode());
            if (qosGroup == null) {
                return "QoS not available";
            }
            return null;
        }
    }
}

