/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.actions.delete;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.swing.SrOptionPane;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public abstract class DeleteTreeAction<T extends SrTreeNode>
extends DeleteAction<T> {
    private static final long serialVersionUID = 1L;
    private static final SrOptionPane.Option<Integer> YES_OPTION = new SrOptionPane.Option<Integer>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_OPTION_PANE_YES), 1);
    private static final SrOptionPane.Option<Integer> NO_OPTION = new SrOptionPane.Option<Integer>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_OPTION_PANE_NO), 2);
    private static final SrOptionPane.Option<Integer> YES_TO_ALL_OPTION = new SrOptionPane.Option<Integer>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_OPTION_PANE_YES_TO_ALL), 3);
    private static final SrOptionPane.Option<Integer> CANCEL_OPTION = new SrOptionPane.Option<Integer>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_OPTION_PANE_CANCEL), 4);
    private static final String UNEXPOSE_VOLUME_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_CONFIRMATOR_UNEXPOSE_VOLUME_TITLE);
    private static final String UNEXPOSE_DEVICE_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_CONFIRMATOR_UNEXPOSE_DEVICE_TITLE);
    private static final String DELETE_VOLUME_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_CONFIRMATOR_DELETE_VOLUME_TITLE);
    private static final String DELETE_DEVICE_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_CONFIRMATOR_DELETE_DEVICE_TITLE);
    private DeleteTreeConfirmator<T> myConfirmator = new DeleteTreeConfirmator(DeleteActionType.UNEXPOSE_ALL_TREE);
    private SrOptionPane.Option<String> myDeleteTreeOption = new SrOptionPane.Option<String>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_DELETE_TREE_OPTION));
    private boolean myShowAllTreeCheckBox = true;

    public DeleteTreeAction(View<T> view, OperationController controller) {
        super(view, controller, null);
    }

    public DeleteTreeAction(String aName, DeleteActionType aAction, View<T> aView, OperationController controller, boolean singleSelection, boolean aShowAllTreeCheckBox) {
        super(aName, aView, controller, null, singleSelection);
        this.myShowAllTreeCheckBox = aShowAllTreeCheckBox;
        this.myConfirmator = new DeleteTreeConfirmator(aAction);
        this.myDeleteTreeOption = new SrOptionPane.Option<String>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_DELETE_TREE_OPTION));
        this.updateEnabled();
    }

    public void setCheckBoxText(String aCheckBoxText) {
        this.myDeleteTreeOption = new SrOptionPane.Option<String>(aCheckBoxText);
    }

    @Override
    public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<T> aArgs) {
        if (aArgs.isEmpty()) {
            return Collections.singleton(new CompleteFuture("DeleteAction, no args"));
        }
        DeleteRequest<T> request = this.myConfirmator.confirmMultiple(aArgs, this.myShowAllTreeCheckBox);
        if (request == null || request.elements().isEmpty()) {
            return Collections.singleton(new CompleteFuture("DeleteAction, not confirmed"));
        }
        ArrayList<ClientConfigElementData> cedList = new ArrayList<ClientConfigElementData>();
        ClusterNode cluster = null;
        for (SrTreeNode node : request.elements()) {
            if (cluster == null) {
                cluster = SystemRootNode.getInstance().getClusterNodeOfSource(node);
            }
            ClientConfigElementData ced = null;
            ced = !this.myShowAllTreeCheckBox || request.isTreeDeletion(node) ? new ClientConfigElementData((CommKeyClassId)node.getIdentifier(), (CommKeyClassId)cluster.getIdentifier(), ConfigOperation.DELETE_TREE) : new ClientConfigElementData((CommKeyClassId)node.getIdentifier(), (CommKeyClassId)cluster.getIdentifier(), ConfigOperation.DELETE);
            cedList.add(ced);
        }
        ClientConfigElementData mainCed = (ClientConfigElementData)cedList.remove(0);
        mainCed.setPostConfigurationElement(cedList);
        List<ClientConfigElementData> preDeleteCed = this.getPreConfigurationElement();
        if (preDeleteCed != null) {
            mainCed.setPreConfigurationElement(preDeleteCed);
        }
        return Collections.singleton(ClientAOImpl.getInstance().configureElementsTree(mainCed));
    }

    protected List<ClientConfigElementData> getPreConfigurationElement() {
        return null;
    }

    @Override
    protected String derivedClientUpdateEnabled() {
        String shouldBeEnabled = super.derivedClientUpdateEnabled();
        if (shouldBeEnabled != null) {
            return shouldBeEnabled;
        }
        String canChildsBeDeleted = null;
        for (SrTreeNode item : this.myView.getValue()) {
            if (item == null) {
                throw new IllegalArgumentException("Action " + this.getValue("Name") + " received a null item from View " + this.myView.getClass());
            }
            canChildsBeDeleted = this.validateTreeDeletion(item);
            if (canChildsBeDeleted == null) continue;
            break;
        }
        if (this.myShowAllTreeCheckBox) {
            this.myConfirmator.setEnableCheckbox(canChildsBeDeleted == null);
            this.myConfirmator.setCheckBoxToolTipText(canChildsBeDeleted);
            return null;
        }
        return canChildsBeDeleted;
    }

    protected abstract String validateTreeDeletion(T var1);

    private static class DeleteRequest<T> {
        HashMap<T, Boolean> myNodeToDeleteOperationMap = new HashMap();

        private DeleteRequest() {
        }

        void addElementToDelete(T aNode, Boolean aDeleteTree) {
            this.myNodeToDeleteOperationMap.put(aNode, aDeleteTree);
        }

        boolean isTreeDeletion(SrTreeNode aNode) {
            return this.myNodeToDeleteOperationMap.get(aNode);
        }

        Set<T> elements() {
            return this.myNodeToDeleteOperationMap.keySet();
        }
    }

    private class DeleteTreeConfirmator<T> {
        private DeleteActionType myActionType;
        private boolean myShouldCheckboxBeEnable = false;
        private String myCheckBoxToolTip = null;

        DeleteTreeConfirmator(DeleteActionType aActionType) {
            this.myActionType = aActionType;
        }

        public DeleteRequest<T> confirmMultiple(Collection<T> aNodes) {
            return this.confirmMultiple(aNodes, true);
        }

        public DeleteRequest<T> confirmMultiple(Collection<T> aNodes, boolean aShowAllTreeCheckBox) {
            int argSize = aNodes.size();
            if (argSize == 1) {
                SrOptionPane.Option result;
                T node = aNodes.iterator().next();
                SrOptionPane pane = this.createOptionPane(node, aShowAllTreeCheckBox, YES_OPTION, NO_OPTION);
                if (aShowAllTreeCheckBox) {
                    this.setPaneCheckbox(pane);
                }
                if ((result = pane.show()) == NO_OPTION || result == null) {
                    return null;
                }
                List treeDeletionSelection = pane.getSelectedCheckBoxes();
                DeleteRequest<T> request = new DeleteRequest<T>();
                request.addElementToDelete(node, treeDeletionSelection.contains(DeleteTreeAction.this.myDeleteTreeOption));
                return request;
            }
            DeleteRequest<T> request = new DeleteRequest<T>();
            boolean isYesToAllState = false;
            boolean yesToAllDeleteTreeMode = false;
            for (T node : aNodes) {
                SrOptionPane.Option result;
                if (isYesToAllState) {
                    request.addElementToDelete(node, yesToAllDeleteTreeMode);
                    continue;
                }
                SrOptionPane pane = this.createOptionPane(node, aShowAllTreeCheckBox, YES_OPTION, YES_TO_ALL_OPTION, NO_OPTION, CANCEL_OPTION);
                if (aShowAllTreeCheckBox) {
                    this.setPaneCheckbox(pane);
                }
                if ((result = pane.show()) == CANCEL_OPTION || result == null) {
                    return null;
                }
                if (result == NO_OPTION) continue;
                List treeDeletionSelection = pane.getSelectedCheckBoxes();
                boolean isDeleteTree = true;
                if (aShowAllTreeCheckBox) {
                    isDeleteTree = treeDeletionSelection.contains(DeleteTreeAction.this.myDeleteTreeOption);
                }
                if (result == YES_TO_ALL_OPTION) {
                    isYesToAllState = true;
                    yesToAllDeleteTreeMode = isDeleteTree;
                }
                request.addElementToDelete(node, isDeleteTree);
            }
            return request;
        }

        void setEnableCheckbox(boolean aEnable) {
            this.myShouldCheckboxBeEnable = aEnable;
        }

        void setCheckBoxToolTipText(String aToolTip) {
            this.myCheckBoxToolTip = aToolTip;
        }

        public String getTitle(T item) {
            if (item instanceof LUNode) {
                VolumeTreeNode volume = ((LUNode)item).getVolumeChild();
                switch (this.myActionType) {
                    case UNEXPOSE: {
                        return volume.isDevice() ? UNEXPOSE_DEVICE_TITLE : UNEXPOSE_VOLUME_TITLE;
                    }
                    case UNEXPOSE_ALL_TREE: {
                        return volume.isDevice() ? DELETE_DEVICE_TITLE : DELETE_VOLUME_TITLE;
                    }
                }
                throw new IllegalStateException("The DeleteTreeAction was initialized with the invalid action type: " + (Object)((Object)this.myActionType));
            }
            return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_CONFIRMATOR_DEFAULT_TITLE, ((SrTreeNode)item).type());
        }

        protected String getMessage(T aNode) {
            if (aNode instanceof LUNode) {
                VolumeTreeNode volume = ((LUNode)aNode).getVolumeChild();
                String[] args = new String[]{volume.toString()};
                if (volume.isDevice()) {
                    switch (this.myActionType) {
                        case UNEXPOSE_ALL_TREE: {
                            return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_CONFIRMATOR_DELETE_DEVICE_MESSAGE, args);
                        }
                        case UNEXPOSE: {
                            return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_CONFIRMATOR_UNEXPOSE_DEVICE_MESSAGE, args);
                        }
                    }
                    throw new IllegalStateException("The DeleteTreeAction was initialized with the invalid action type: " + (Object)((Object)this.myActionType));
                }
                switch (this.myActionType) {
                    case UNEXPOSE_ALL_TREE: {
                        return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_CONFIRMATOR_DELETE_VOLUME_MESSAGE, args);
                    }
                    case UNEXPOSE: {
                        return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_CONFIRMATOR_UNEXPOSE_VOLUME_MESSAGE, args);
                    }
                }
                throw new IllegalStateException("The DeleteTreeAction was initialized with the invalid action type: " + (Object)((Object)this.myActionType));
            }
            return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_CONFIRMATOR_DEFAULT_MESSAGE, ((SrTreeNode)aNode).type() + " " + aNode);
        }

        private void setPaneCheckbox(SrOptionPane aPane) {
            aPane.setEnableCheckbox(DeleteTreeAction.this.myDeleteTreeOption, this.myShouldCheckboxBeEnable);
            if (!this.myShouldCheckboxBeEnable) {
                aPane.setCheckBoxToolTip(DeleteTreeAction.this.myDeleteTreeOption, this.myCheckBoxToolTip);
            }
        }

        private SrOptionPane createOptionPane(T aNode, SrOptionPane.Option<Integer> ... aButtonOptions) {
            return this.createOptionPane(aNode, true, aButtonOptions);
        }

        private SrOptionPane createOptionPane(T aNode, boolean aShowAllTreeCheckBox, SrOptionPane.Option<Integer> ... aButtonOptions) {
            SrOptionPane pane = new SrOptionPane(this.getTitle(aNode), this.getMessage(aNode), SrOptionPane.MessageType.QUESTION_DIALOG, SrAction.getConfirmationOwner());
            pane.addButtons(aButtonOptions);
            pane.setDefaultButton(YES_OPTION);
            if (aShowAllTreeCheckBox) {
                pane.addCheckBox(DeleteTreeAction.this.myDeleteTreeOption, false);
            }
            return pane;
        }
    }

    public static enum DeleteActionType {
        UNEXPOSE_ALL_TREE,
        UNEXPOSE;

    }
}

