/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.actions.delete;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.YesToAllDialogPane;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JOptionPane;

public class DeleteAction<A extends SrTreeNode>
extends SrClientAction<A, Void> {
    public static final String DELETE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_DELETE);
    private static SrLogger theLogger = SrLogger.getLogger();
    private Confirmator<A> myConfirmator = null;
    private OperationController myController;

    public DeleteAction(View<A> view, OperationController controller, Confirmator<A> aConfirmator) {
        this(view, controller, aConfirmator, false);
    }

    public DeleteAction(View<A> view, OperationController controller, Confirmator<A> aConfirmator, boolean singleSelection) {
        this(DELETE, view, controller, aConfirmator, singleSelection);
    }

    public DeleteAction(String aName, View<A> aView, OperationController controller, Confirmator<A> aConfirmator, boolean singleSelection) {
        super(aName, ClientImageObject.DELETE.getImageIcon(), true, true, aView, SrLicenseTreePath.GENERAL_PATH);
        theLogger.logAndAssert(SrLogCategories.ERROR, controller != null, new Object[]{"Controller may not be null"});
        this.myController = controller;
        if (controller != null) {
            this.addControllerAsListener(controller);
        }
        this.setConfirmator(aConfirmator);
        this.setConnectionErrorMessage("Failed to delete the selected items.");
    }

    @Override
    public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<A> aArgs) {
        if (this.myConfirmator != null && (aArgs = this.myConfirmator.confirmMultiple(aArgs)).isEmpty()) {
            return Collections.singleton(new CompleteFuture("DeleteAction, not confirmed"));
        }
        ArrayList<Object> identifiers = new ArrayList<Object>(aArgs.size());
        for (SrTreeNode item : aArgs) {
            identifiers.add(item.getIdentifier());
        }
        return Collections.singleton(ClientAOImpl.getInstance().deleteObjects(identifiers));
    }

    @Override
    protected String derivedClientUpdateEnabled() {
        for (SrTreeNode item : this.myView.getValue()) {
            if (item == null) {
                throw new IllegalArgumentException("Action " + this.getValue("Name") + " received a null item from View " + this.myView.getClass());
            }
            String problemOnDeletion = item.getProblemOnDeletion();
            if (problemOnDeletion == null) continue;
            return problemOnDeletion;
        }
        return null;
    }

    public void setConfirmator(Confirmator<A> aConfirmator) {
        this.myConfirmator = aConfirmator;
    }

    public static class Confirmator<AA extends SrTreeNode> {
        private static final String UNEXPOSE_VOLUME_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_CONFIRMATOR_UNEXPOSE_VOLUME_TITLE);
        private static final String UNEXPOSE_DEVICE_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_CONFIRMATOR_UNEXPOSE_DEVICE_TITLE);

        public Collection<AA> confirmMultiple(Collection<AA> arg) {
            int argSize = arg.size();
            if (argSize == 1) {
                SrTreeNode item = (SrTreeNode)arg.iterator().next();
                int answer = JOptionPane.showConfirmDialog(SrAction.getConfirmationOwner(), this.getMessage(item), this.getTitle(item), 0, 3);
                boolean isConfigred = answer == 0;
                return isConfigred ? arg : Collections.EMPTY_LIST;
            }
            Vector<SrTreeNode> retVal = new Vector<SrTreeNode>(argSize);
            boolean yesToAll = false;
            for (SrTreeNode item : arg) {
                if (yesToAll) {
                    retVal.add(item);
                    continue;
                }
                int answer = YesToAllDialogPane.showYesToAllDialog(SrAction.getConfirmationOwner(), this.getMessage(item), this.getTitle(item));
                switch (answer) {
                    case 0: {
                        retVal.add(item);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 3: {
                        yesToAll = true;
                        retVal.add(item);
                        break;
                    }
                    case 2: {
                        return Collections.EMPTY_LIST;
                    }
                }
            }
            return retVal;
        }

        public String getTitle(AA item) {
            if (item instanceof LUNode) {
                VolumeTreeNode volume = ((LUNode)item).getVolumeChild();
                return volume.isDevice() ? UNEXPOSE_DEVICE_TITLE : UNEXPOSE_VOLUME_TITLE;
            }
            return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_CONFIRMATOR_DEFAULT_TITLE, ((SrTreeNode)item).type());
        }

        protected String getMessage(AA item) {
            if (item instanceof LUNode) {
                VolumeTreeNode volume = ((LUNode)item).getVolumeChild();
                String[] args = new String[]{volume.toString()};
                if (volume.isDevice()) {
                    return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_CONFIRMATOR_UNEXPOSE_DEVICE_MESSAGE, args);
                }
                return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_CONFIRMATOR_UNEXPOSE_VOLUME_MESSAGE, args);
            }
            return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DELETE_ACTION_CONFIRMATOR_DEFAULT_MESSAGE, ((SrTreeNode)item).type() + " " + item);
        }
    }
}

