/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.actions;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.actions.ViewDecorator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class VolumeLUView<AV extends VolumeTreeNode>
extends ViewDecorator<LUNode, AV> {
    private static final SrLogger theLogger = SrLogger.getLogger();

    public VolumeLUView(View<AV> aView) {
        super(aView);
    }

    @Override
    public Collection<LUNode> getValue() {
        ArrayList<LUNode> retVal = new ArrayList<LUNode>();
        for (VolumeTreeNode volume : this.myView.getValue()) {
            LUNode luNode = volume.getLUNode();
            if (luNode == null) {
                return Collections.EMPTY_LIST;
            }
            retVal.add(luNode);
        }
        return retVal;
    }

    public String getContextMismatchTooltip() {
        Collection selectedVolumes = this.myView.getValue();
        if (selectedVolumes.isEmpty()) {
            return null;
        }
        for (VolumeTreeNode volume : selectedVolumes) {
            LUNode luNode = volume.getLUNode();
            if (luNode != null) continue;
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_NOT_EXPOSED);
        }
        theLogger.logAndAssert(SrLogCategories.ERROR, "There exist selected volumes, and all of them have LU's.");
        return null;
    }
}

