/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.actions;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.VSwitchGroupNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.View;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;

public class SynchronizeElementAction<T extends VSwitchGroupNode<?>>
extends SrClientAction<T, Void> {
    public static final String SYNCHRONIZE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_POPUP_MENU_CLUSTER_SYNC_LABEL);

    public SynchronizeElementAction(View<T> view, OperationController controller) {
        super(SYNCHRONIZE, true, true, view, SrLicenseTreePath.GENERAL_PATH, true);
        this.addControllerAsListener(controller);
        this.setConnectionErrorMessage("Failure during synchronization");
    }

    @Override
    public Collection<SrFuture<Void>> derivedActionPerformed(Collection<T> aArgs) {
        return Collections.singleton(ClientAOImpl.getInstance().synchronize((CommKeyClassId)((VSwitchGroupNode)aArgs.iterator().next()).getIdentifier()));
    }

    @Override
    public String derivedClientUpdateEnabled() {
        String retVal = null;
        for (VSwitchGroupNode node : this.myView.getValue()) {
            retVal = this.validateNode(node);
            if (retVal == null) continue;
            return retVal;
        }
        return retVal;
    }

    private String validateNode(VSwitchGroupNode node) {
        if (!(node instanceof ClusterNode)) {
            return null;
        }
        ClusterNode cluster = (ClusterNode)node;
        if (cluster.getConnectedVSwitches().length < 2) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.CLUSTER_SYNC_VALIDATION_THE_CLUSTER_HOLDS_LESS_THAN_2_VSWITCHES, cluster.getAlias());
        }
        return cluster.getInDiscoveryTooltip();
    }
}

