/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.actions;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.comm.CommunicationEventService;
import com.sanrad.nms.client.comm.DataListener;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.event.ConnectionErrorEvent;
import com.sanrad.nms.client.event.ConnectionErrorListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.server.RemoteEvent;
import com.sanrad.nms.server.license.LicenseManager;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.SrExecutionException;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public abstract class SrClientAction<A, V>
extends SrAction<A, V> {
    private static final String DB_CORRUPTION_TOOLTIP = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ACTIONS_DB_CORRUPTED);
    public static final String LICENSE_TOOLTIP = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.LICENSE_OPERATION_BLOCK);
    private static final String DISCONNECTION_TOOLTIP = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ACTIONS_SERVER_DISCONNECTION);
    private static SrLogger theLogger = SrLogger.getLogger();
    private boolean myIsRequiresConnection;
    private boolean myIsNoDBCorruption;
    private SrLicenseTreePath myLicensePath;
    private String myConnectionErrorMessage = null;
    private static final ConnectionErrorListener theConnectionListener = new ConnectionErrorListener(){

        @Override
        public void onConnectionError(ConnectionErrorEvent e) {
            SrAction.theActionStartStop.fireEvent(SrClientAction.class, e, SrAction.theUpdateInformer);
        }
    };
    private static final DataListener theDataListener = new DataListener(){

        @Override
        public void dataReady(RemoteEvent aEvent) {
            SrAction.theActionStartStop.fireEvent(SrClientAction.class, new EventObject(aEvent), SrAction.theUpdateInformer);
        }
    };
    private static final String WARNING = ClientLoader.BUNDLE.getString(SrClientBundleKeys.WARNING);

    public SrClientAction(SrLicenseTreePath licensePath) {
        this(null, null, true, true, null, licensePath, false, true);
    }

    public SrClientAction(boolean requiresConnection, boolean noDBCorruption, View<A> view, SrLicenseTreePath licensePath) {
        this(null, null, requiresConnection, noDBCorruption, view, licensePath);
    }

    public SrClientAction(String name, boolean requiresConnection, boolean noDBCorruption, View<A> view, SrLicenseTreePath licensePath) {
        this(name, null, requiresConnection, noDBCorruption, view, licensePath);
    }

    public SrClientAction(String name, Icon icon, boolean requiresConnection, boolean noDBCorruption, View<A> view, SrLicenseTreePath licensePath) {
        this(name, icon, requiresConnection, noDBCorruption, view, licensePath, false, true);
    }

    public SrClientAction(boolean requiresConnection, boolean noDBCorruption, View<A> view, SrLicenseTreePath licensePath, boolean singleSelection) {
        this(null, null, requiresConnection, noDBCorruption, view, licensePath, singleSelection, true);
    }

    public SrClientAction(String name, boolean requiresConnection, boolean noDBCorruption, View<A> view, SrLicenseTreePath licensePath, boolean singleSelection) {
        this(name, null, requiresConnection, noDBCorruption, view, licensePath, singleSelection, true);
    }

    public SrClientAction(String aName, Icon aIcon, boolean aIsRequiresConnection, boolean aIsNoDBCorruption, View<A> aView, SrLicenseTreePath aLicensePath, boolean aIsSingleSelection, boolean aIsShouldBlockActions) {
        super(aName, aIcon, aView, aIsSingleSelection, aIsShouldBlockActions);
        this.initClientActionParameters(aName, aIcon, aIsRequiresConnection, aIsNoDBCorruption, aView, aLicensePath, aIsSingleSelection, aIsShouldBlockActions);
    }

    protected void initClientActionParameters(String aName, Icon aIcon, boolean aIsRequiresConnection, boolean aIsNoDBCorruption, View<A> aView, SrLicenseTreePath aLicensePath, boolean aIsSingleSelection, boolean aIsShouldBlockActions) {
        this.initActionParameters(aName, aIcon, aView, aIsSingleSelection, aIsShouldBlockActions);
        Util.validateInputNotNull(aLicensePath, "Client action license path");
        this.myIsRequiresConnection = aIsRequiresConnection;
        this.myIsNoDBCorruption = aIsNoDBCorruption;
        this.myLicensePath = aLicensePath;
        this.updateEnabled();
    }

    @Override
    public final Collection<? extends SrFuture<V>> baseActionPerformed(Collection<A> arg) {
        if (this.myView != null && this.myIsNoDBCorruption) {
            Collection<ClusterNode> col = this.getSelectedClusters(arg);
            for (ClusterNode cluster : col) {
                if (!cluster.isInitializing() || JOptionPane.showOptionDialog(SrClientAction.getConfirmationOwner(), ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLUSTER_INITIALIZING_MESSAGE, cluster.getAlias()), WARNING, 2, 2, null, null, 2) == 0) continue;
                return Collections.EMPTY_LIST;
            }
        }
        return this.derivedActionPerformed(arg);
    }

    public abstract Collection<? extends SrFuture<V>> derivedActionPerformed(Collection<A> var1);

    @Override
    protected final String derivedUpdateEnabled() {
        String headDisabledMessage = this.getPreferredDisabledText();
        if (headDisabledMessage != null) {
            return headDisabledMessage;
        }
        if (this.myLicensePath == null) {
            return null;
        }
        if (this.myIsRequiresConnection && !Manager.isConnected()) {
            return DISCONNECTION_TOOLTIP;
        }
        if (!LicenseManager.getInstance().isEnabled(this.myLicensePath, null)) {
            return LICENSE_TOOLTIP;
        }
        if (this.myIsNoDBCorruption && SrClientAction.dbCorrupted()) {
            return DB_CORRUPTION_TOOLTIP;
        }
        if (this.myView != null) {
            Collection arg = this.myView.getValue();
            Collection<ClusterNode> col = this.getSelectedClusters(arg);
            for (ClusterNode cluster : col) {
                if (LicenseManager.getInstance().isEnabled(this.myLicensePath, cluster.getCapability())) continue;
                return LICENSE_TOOLTIP;
            }
        }
        return this.derivedClientUpdateEnabled();
    }

    protected String getPreferredDisabledText() {
        return null;
    }

    private Collection<ClusterNode> getSelectedClusters(Collection<? extends A> arg) {
        Vector<ClusterNode> col = new Vector<ClusterNode>();
        for (A item : arg) {
            ClusterNode clusterNode;
            if (!(item instanceof SrTreeNode) || (clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource((SrTreeNode)item)) == null) continue;
            col.add(clusterNode);
        }
        return col;
    }

    @Override
    protected final boolean shouldBeVisible() {
        if (this.myLicensePath == null) {
            return true;
        }
        return LicenseManager.getInstance().isVisible(this.myLicensePath, null) && this.shouldClientActionBeVisible();
    }

    protected boolean shouldClientActionBeVisible() {
        return true;
    }

    protected abstract String derivedClientUpdateEnabled();

    private static boolean dbCorrupted() {
        return false;
    }

    public void setConnectionErrorMessage(String message) {
        this.myConnectionErrorMessage = message;
    }

    private Throwable getRemoteOrNetworkCauseException(Throwable aThr) {
        Throwable retVal = null;
        if (retVal == null && aThr instanceof RemoteException) {
            retVal = aThr;
        }
        if (retVal == null && aThr instanceof SrExecutionException) {
            SrExecutionException see = (SrExecutionException)aThr;
            for (Throwable th : see.getCauses()) {
                retVal = this.getRemoteOrNetworkCauseException(th);
            }
        }
        if (retVal == null && aThr instanceof ExecutionException) {
            retVal = this.getRemoteOrNetworkCauseException(aThr.getCause());
        }
        return retVal;
    }

    @Override
    protected void onActionFinished(Collection<? extends SrFuture<V>> futures) {
        for (SrFuture<V> future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                theLogger.logAndAssert(SrLogCategories.EXCEPTION, e);
            }
            catch (ExecutionException e) {
                Throwable th = this.getRemoteOrNetworkCauseException(e);
                if (th == null) continue;
                Manager.onConnectionError(this.myConnectionErrorMessage);
                theLogger.error(SrLogCategories.INFORMATIVE, th, new Object[0]);
            }
        }
    }

    static {
        Manager.addErrorConnectionListener(theConnectionListener);
        CommunicationEventService.getInstance().addDataListener(theDataListener);
    }
}

