/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.actions;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.data.volume.copy.CopyOperationNode;
import com.sanrad.nms.client.data.volume.copy.MirrorSyncOperationNode;
import com.sanrad.nms.client.data.volume.copy.OfflineCopyOperationNode;
import com.sanrad.nms.client.data.volume.copy.RestoreOperationNode;
import com.sanrad.nms.client.gui.MainFrame;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrTransientWindowPane;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import com.sanrad.swing.actions.View;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class RestartOperationAction<A extends CopyOperationNode>
extends SrClientAction<A, Void> {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private static final String DEFAULT_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_RESTART_COPY_CONFIRMATION_TITLE);
    private static final String RESTORE_SNAPSHOT_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_RESTART_RESTORE_SNAPSHOT_CONFIRMATION_TITLE);
    private static final String RESTART = "Restart";
    private JFrame myOwner;
    private Collection<A> myLastArgs = null;

    public RestartOperationAction(View<A> view) {
        super(RESTART, null, true, true, view, SrLicenseTreePath.GENERAL_PATH, false, true);
        this.setConnectionErrorMessage("Failed to restart the Copy Operation.");
    }

    protected Collection<A> confirm(Collection<A> arg) {
        Vector<CopyOperationNode> opersToRestart = new Vector<CopyOperationNode>(arg.size());
        this.myOwner = null;
        for (Window window = RestartOperationAction.getConfirmationOwner(); window != null; window = window.getOwner()) {
            if (!(window instanceof JFrame)) continue;
            this.myOwner = (JFrame)window;
        }
        for (CopyOperationNode current : arg) {
            int result;
            VolumeOperationOperStatusConstant operStat;
            if (current instanceof RestoreOperationNode) {
                theLogger.logAndAssert(SrLogCategories.ERROR, current.getSource() instanceof SnapshotVolumeNode, new Object[]{"Volume " + current.getSource() + " is the source of a restore snapshot operation and non-snapshot"});
                StringBuffer msg = CopyOperManager.getInstance().getRollbackConfirmMsg((SnapshotVolumeNode)current.getSource());
                if (JOptionPane.showConfirmDialog(this.myOwner, msg.toString(), "Restart rollback operation Confirmation", 2, 3) != 0) continue;
            }
            if ((operStat = current.getCopyStatus()).equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_UNKNOWN) ? !current.getVSwitch().isConnected() && (result = JOptionPane.showConfirmDialog(this.myOwner, this.getMessage(current), this.getTitle(current), 2, 3)) == 2 : operStat.isActive()) continue;
            opersToRestart.add(current);
        }
        return opersToRestart;
    }

    private String getMessage(A node) {
        String[] args = new String[]{ClassID.VSWITCH.toString(), ((CopyOperationNode)node).getVSwitch().getName(), ((CopyOperationNode)node).getDestination().getAlias()};
        if (node instanceof RestoreOperationNode) {
            return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_RESTART_RESTORE_SNAPSHOT_CONFIRMATION_MSG, args);
        }
        if (((CopyOperationNode)node).isMirrorSync()) {
            return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_RESTART_MIRROR_SYNC_CONFIRMATION_MSG, args);
        }
        return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_RESTART_COPY_CONFIRMATION_MSG, args);
    }

    private String getTitle(A node) {
        if (node instanceof RestoreOperationNode) {
            return RESTORE_SNAPSHOT_TITLE;
        }
        return DEFAULT_TITLE;
    }

    @Override
    public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<A> arg) {
        if ((arg = this.confirm(arg)).isEmpty()) {
            return new ArrayList();
        }
        ArrayList<CommKeyClassId> identifiers = new ArrayList<CommKeyClassId>(arg.size());
        for (CopyOperationNode node : arg) {
            identifiers.add((CommKeyClassId)node.getIdentifier());
        }
        this.myLastArgs = arg;
        return Collections.singleton(ClientAOImpl.getInstance().restartOperation(identifiers));
    }

    @Override
    protected String derivedClientUpdateEnabled() {
        Collection arg = this.myView.getValue();
        for (CopyOperationNode current : arg) {
            if (current.getCopyStatus().equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_OPERATING) || current.getCopyStatus().equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_WAITING)) {
                return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_RESTART_RUNNING, current.toString());
            }
            String volNonFunc = AlarmsManager.VOLUME_NON_FUNC;
            for (VolumeTreeNode vol : new VolumeTreeNode[]{current.getDestination(), current.getSource()}) {
                if (!AlarmsManager.getInstance().isAlarmExist(current.getDestination(), volNonFunc)) continue;
                return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_RESTART_VOL_NON_FUNCTIONAL, current.toString(), vol.toString());
            }
            if (!(current instanceof RestoreOperationNode)) continue;
            StringBuffer reason = new StringBuffer();
            if (CopyOperManager.getInstance().isLegitimateForRestoreOper((SnapshotVolumeNode)current.getSource(), reason)) continue;
            return reason.toString();
        }
        return null;
    }

    @Override
    protected void onActionFinished(Collection<? extends SrFuture<Void>> futures) {
        super.onActionFinished(futures);
        if (this.myLastArgs.isEmpty()) {
            return;
        }
        CopyOperationNode item = (CopyOperationNode)this.myLastArgs.iterator().next();
        if (!RestartOperationAction.isSuccessful(futures, 1)) {
            return;
        }
        ArrayList<MirrorSyncOperationNode> succeeded = new ArrayList<MirrorSyncOperationNode>(this.myLastArgs.size());
        for (CopyOperationNode operation : this.myLastArgs) {
            if (!operation.getCopyStatus().isActive()) continue;
            succeeded.add((MirrorSyncOperationNode)operation);
        }
        if (item.isMirrorSync()) {
            SrTransientWindowPane.showMultiMirrorSyncStarted(this.myOwner, succeeded.size(), this.myLastArgs.size(), MainFrame.createShowConstantMirrorSyncOperationsAction(succeeded));
        } else if (item instanceof RestoreOperationNode) {
            SrTransientWindowPane.showMultiSnapshotRollbackStarted(this.myOwner, succeeded.size(), this.myLastArgs.size(), MainFrame.createShowConstantRestoreOperationAction(succeeded));
        } else if (item instanceof OfflineCopyOperationNode) {
            SrTransientWindowPane.showMultiOfflineCopyStarted(this.myOwner, succeeded.size(), this.myLastArgs.size(), MainFrame.createShowConstantCopyOperationAction(succeeded));
        } else {
            theLogger.logAndAssert(SrLogCategories.ERROR, "Unsupported copy operation node class: ", item.getClass(), item);
        }
    }
}

