/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.actions;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.ExposeVolumeDialog;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.actions.View;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JFrame;

public class ExposeInternalVolumeAction<T extends VolumeTreeNode>
extends SrClientAction<T, Void> {
    private static final String EXPOSE = "Expose...";
    private JFrame owner;

    public ExposeInternalVolumeAction(JFrame owner, View<T> view, SrLicenseTreePath licensePath) {
        super(EXPOSE, ClientImageObject.EXPOSE.getImageIcon(), true, true, view, licensePath, true, false);
        this.owner = owner;
    }

    @Override
    public Collection<SrFuture<Void>> derivedActionPerformed(Collection<T> arg) {
        VolumeTreeNode volumeNode = (VolumeTreeNode)arg.iterator().next();
        ExposeVolumeDialog exposeVolumeDialog = new ExposeVolumeDialog(this.owner, volumeNode);
        exposeVolumeDialog.setVisible(true);
        return Collections.EMPTY_LIST;
    }

    @Override
    protected String derivedClientUpdateEnabled() {
        VolumeTreeNode node = (VolumeTreeNode)this.myView.getValue().iterator().next();
        if (node.isExposed()) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.EXPOSED_VOLUME_VALIDAION_THE_SOURCE_IS_ALREADY_EXPOSED);
        }
        if (node instanceof StorageDeviceNode) {
            StorageDeviceNode storageDeviceNode = (StorageDeviceNode)node;
            if (!(!AlarmsManager.getInstance().isRemovableDisk(storageDeviceNode) || storageDeviceNode.isDisk() && AlarmsManager.getInstance().hasConfiguredAlarmOnly(storageDeviceNode))) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.EXPOSED_VOLUME_VALIDAION_THE_PARENT_IS_MISSING_OR_INVALID);
            }
            if (storageDeviceNode.isDisk() && storageDeviceNode.hasSubdisks()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.EXPOSED_VOLUME_VALIDAION_THE_DISK_HAS_SUBDISKS);
            }
            if (storageDeviceNode.hasVolumeParent()) {
                VolumeTreeNode parent = (VolumeTreeNode)storageDeviceNode.getParent();
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.EXPOSED_VOLUME_VALIDAION_THE_SORCE_HAS_A_PARENT_VOLUME, parent.getAlias());
            }
            DRPairNode drPair = DRPairManager.getPairContainingVolume(storageDeviceNode);
            if (drPair != null) {
                String[] args = new String[]{drPair.toString()};
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.EXPOSED_VOLUME_VALIDAION_USED_FOR_DR, args);
            }
            if (CopyOperManager.getInstance().isExistActiveCopyInHeirarchy(node) || CopyOperManager.getInstance().isExistAbortedCopyInHeirarchy(node)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.EXPOSED_VOLUME_VALIDAION_THE_SOURCE_INVOLVED_IN_A_COPY_OR_MIRROR_SYNC_OPERATION);
            }
        }
        StringBuffer reason = new StringBuffer("");
        if (!VolumeManager.getInstance().canBeExposed(node, reason)) {
            return reason.toString();
        }
        return null;
    }
}

