/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.actions;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.gui.actions.SrTransientAction;
import com.sanrad.nms.client.gui.alarm.dialogs.FilteredAlarmsDialog;
import com.sanrad.nms.client.gui.alarm.dialogs.FilteredAlarmsDialogsPool;
import com.sanrad.swing.actions.View;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class AlarmAction<T extends SrTreeNode>
extends SrTransientAction<T, Void> {
    private boolean myIsSpecific;
    private Component myOwnerComponent;

    public AlarmAction(View<T> aView, boolean aIsSpecific) {
        this.setProxy(new AlarmActionProxy(aView));
        this.myIsSpecific = aIsSpecific;
    }

    public boolean isSpecific() {
        return this.myIsSpecific;
    }

    public void setOwnerComponent(Component aComponent) {
        this.myOwnerComponent = aComponent;
    }

    private class AlarmActionProxy
    extends SrTransientAction.AbstractProxy<T, Void> {
        private View<T> myView;

        AlarmActionProxy(View<T> aView) {
            this.myView = aView;
        }

        @Override
        public View<T> getView() {
            return this.myView;
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<T> aArgs) {
            int index = 0;
            for (SrTreeNode node : aArgs) {
                Window tempOwner;
                Vector<SrTreeNode> nodes = new Vector<SrTreeNode>();
                if (AlarmAction.this.myIsSpecific) {
                    nodes.add(node);
                } else {
                    nodes.addAll(AlarmsManager.getInstance().getDependenciesFor(node));
                }
                Window windowOwner = ClientLoader.getMainFrame();
                if (AlarmAction.this.myOwnerComponent != null && (tempOwner = SwingUtilities.getWindowAncestor(AlarmAction.this.myOwnerComponent)) != null) {
                    windowOwner = tempOwner;
                }
                FilteredAlarmsDialog dialog = FilteredAlarmsDialogsPool.getInstance().getFilteredDialog(windowOwner, nodes, AlarmAction.this.myIsSpecific);
                dialog.requestFocus();
                dialog.setLocation(dialog.getX() + index * 20, dialog.getY() + index * 20);
                dialog.show();
                ++index;
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        public String derivedClientUpdateEnabled() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public boolean isConnectionRequired() {
            return false;
        }

        @Override
        public boolean isNoDbCorruptionRequired() {
            return false;
        }
    }
}

