/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.acl;

import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.acl.WorkbenchAclTablePanel;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.identity.IdentitiesTablePanel;
import com.sanrad.nms.client.gui.target.dialogs.SrAclTablePanel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrSplitPane;
import com.sanrad.swing.SrTable;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AclWorkbenchMainPanel
extends SrPanel
implements ListSelectionListener {
    private SrSplitPane split;
    private WorkbenchAclTablePanel aclTablePanel;
    private IdentitiesTablePanel identitiesTablePanel;
    public final SrClientAction moveDownAction;
    public final SrClientAction moveUpAction;
    public final SrClientAction attachAction;
    public final SrClientAction detachAction;

    public AclWorkbenchMainPanel(JFrame owner, TargetNode targetNode) {
        this.setLayout(new BorderLayout());
        this.split = new SrSplitPane(0);
        this.aclTablePanel = new WorkbenchAclTablePanel(targetNode);
        this.split.setTopComponent(this.aclTablePanel);
        this.identitiesTablePanel = new IdentitiesTablePanel(owner, targetNode);
        this.aclTablePanel.getACLTable().getTable().getSelectionModel().addListSelectionListener(this);
        this.identitiesTablePanel.getIdentitiesTablePanel().getTable().getSelectionModel().addListSelectionListener(this);
        this.moveDownAction = new SrClientAction<IdentityNode, Void>("Move Down", (Icon)ClientImageObject.MOVE_DOWN.getImageIcon(), true, true, this.aclTablePanel.myView, SrLicenseTreePath.GENERAL_PATH, true, true){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<IdentityNode> arg) {
                AclWorkbenchMainPanel.this.aclTablePanel.moveDownSelectedEntry();
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                SrAclTablePanel tablePanel = AclWorkbenchMainPanel.this.aclTablePanel.getACLTable();
                if (tablePanel.getSelectedRow() + 1 == tablePanel.getRowCount()) {
                    return "Cannot move down the last row";
                }
                return null;
            }
        };
        this.moveUpAction = new SrClientAction<IdentityNode, Void>("Move Up", (Icon)ClientImageObject.MOVE_UP.getImageIcon(), true, true, this.aclTablePanel.myView, SrLicenseTreePath.GENERAL_PATH, true, true){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<IdentityNode> arg) {
                AclWorkbenchMainPanel.this.aclTablePanel.moveUpSelectedEntry();
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                SrAclTablePanel tablePanel = AclWorkbenchMainPanel.this.aclTablePanel.getACLTable();
                if (tablePanel.getSelectedRow() == 0) {
                    return "Cannot move up the first row";
                }
                return null;
            }
        };
        this.attachAction = new SrClientAction<IdentityNode, Void>("Attach", (Icon)ClientImageObject.ATTACH.getImageIcon(), true, true, this.identitiesTablePanel.getView(), SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<IdentityNode> arg) {
                IdentityNode[] selectedIdentities = AclWorkbenchMainPanel.this.identitiesTablePanel.removeSelectedIdentities();
                AclWorkbenchMainPanel.this.aclTablePanel.attachIdentities(selectedIdentities);
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                return null;
            }
        };
        this.detachAction = new SrClientAction<IdentityNode, Void>("Detach", (Icon)ClientImageObject.DETACH.getImageIcon(), true, true, this.aclTablePanel.myView, SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<IdentityNode> arg) {
                AclWorkbenchMainPanel.this.aclTablePanel.detachSelectedIdentities();
                AclWorkbenchMainPanel.this.identitiesTablePanel.addIdentities(arg);
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                return null;
            }
        };
        this.split.setBottomComponent(this.identitiesTablePanel);
        this.split.setDividerLocation(200);
        this.add((Component)this.split, "Center");
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
    }

    public WorkbenchAclTablePanel getAclTablePanel() {
        return this.aclTablePanel;
    }

    public void removePolicyManagerListener() {
        this.aclTablePanel.closeMe();
        this.identitiesTablePanel.closeMe();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel sourceTableModel = (ListSelectionModel)e.getSource();
        if (sourceTableModel.getMinSelectionIndex() == -1) {
            return;
        }
        SrTable otherTable = sourceTableModel == this.aclTablePanel.getACLTable().getTable().getSelectionModel() ? this.identitiesTablePanel.getIdentitiesTablePanel().getTable() : this.aclTablePanel.getACLTable().getTable();
        otherTable.getSelectionModel().clearSelection();
    }

    public List<List<Object>> getNewAclFromTable() {
        return this.aclTablePanel.getAcl();
    }

    public void refreshButtonPressed() {
        this.aclTablePanel.refresh();
        this.identitiesTablePanel.refresh();
    }

    public void newClusterHasBeenSelected() {
        this.aclTablePanel.newClusterHasBeenSelected();
        this.identitiesTablePanel.newClusterHasBeenSelected();
    }

    public JSplitPane getSplitPanel() {
        return this.split;
    }
}

