/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.acl;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.acl.PolicyManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.acl.AclToolBarPanel;
import com.sanrad.nms.client.gui.acl.AclWorkbenchMainPanel;
import com.sanrad.nms.client.gui.acl.AclWorkbenchPool;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.swing.FrameView;
import com.sanrad.swing.OKCancelDialog;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.SrButton;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.List;

public class AclWorkbenchFrame
extends FrameView
implements OperationController {
    private AclWorkbenchMainPanel mainPanel;
    private AclToolBarPanel aclToolbarPanel;
    private TargetNode target;

    public AclWorkbenchFrame(TargetNode targetNode) {
        super("Attach Host Groups");
        this.target = targetNode;
        this.setTitle("Attach Host Groups to Target - " + targetNode.getAlias());
        this.initView();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AclWorkbenchFrame.this.closeMe();
            }
        });
        this.setSize(660, 560);
    }

    protected void closeMe() {
        AclWorkbenchPool.getInstance().removeAlarmsDialog(this.target);
        this.mainPanel.removePolicyManagerListener();
        this.dispose();
    }

    protected void initView() {
        this.mainPanel = new AclWorkbenchMainPanel(this, this.target);
        this.getMainPanel().add((Component)this.mainPanel, "Center");
        this.aclToolbarPanel = new AclToolBarPanel(this.mainPanel);
        this.setToolBarPanel(this.aclToolbarPanel);
    }

    public AclWorkbenchMainPanel getAclWorkbenchMainPanel() {
        return this.mainPanel;
    }

    @Override
    protected SrPanel createButtonsPanel() {
        SrButton okBtn = new SrButton(OKCancelDialog.OK);
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AclWorkbenchFrame.this.okButtonPressed(e);
            }
        });
        SrButton cancelBtn = new SrButton(OKCancelDialog.CANCEL);
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AclWorkbenchFrame.this.cancelButtonPressed(e);
            }
        });
        SrButton restoreBtn = new SrButton("Restore");
        restoreBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AclWorkbenchFrame.this.restoreButtonPressed(e);
            }
        });
        okBtn.setPreferredSize(cancelBtn.getPreferredSize());
        SrPanel buttonsPanel = new SrPanel();
        buttonsPanel.setLayout(new FlowLayout(2));
        buttonsPanel.add(restoreBtn);
        buttonsPanel.add(okBtn);
        buttonsPanel.add(cancelBtn);
        return buttonsPanel;
    }

    protected void cancelButtonPressed(ActionEvent e) {
        this.closeMe();
    }

    protected void okButtonPressed(ActionEvent e) {
        List<List<Object>> acl = this.mainPanel.getNewAclFromTable();
        int answer = 1;
        if (acl != null) {
            String warningMsg = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ACL_CHANGED_WARNING_MSG);
            answer = SrOptionPaneUtil.showYesNoCancelConfirmDialog(this, warningMsg, this.getTitle());
            if (answer == 0) {
                ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(this.target);
                PolicyManager policyMgr = clusterNode.getPolicyManager();
                SrClientAction.blockActions(Collections.singleton(policyMgr.updateAcl(this.target, acl)), this);
            } else if (answer == 1) {
                // empty if block
            }
        }
        if (answer != 2) {
            this.closeMe();
        }
    }

    protected void restoreButtonPressed(ActionEvent e) {
        this.restore();
    }

    private void restore() {
        this.mainPanel.refreshButtonPressed();
    }

    @Override
    public void inProcess(String message) {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    public void success(SrAction aAction) {
        this.closeMe();
    }

    @Override
    public void fail(String message) {
        this.setVisible(true);
        SrOptionPaneUtil.showErrorMessage(this, message);
        this.restore();
    }

    public void newClusterHasBeenSelected() {
        this.mainPanel.newClusterHasBeenSelected();
    }

    public SrClientAction getAttachAction() {
        return this.mainPanel.attachAction;
    }
}

