/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.acl;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.acl.SrAclTableModel;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrMainTreePanel;
import com.sanrad.nms.client.gui.acl.AclTableHeader;
import com.sanrad.nms.client.gui.acl.AclWorkbenchFrame;
import com.sanrad.nms.client.gui.acl.AclWorkbenchPool;
import com.sanrad.nms.client.gui.target.dialogs.SrAclTablePanel;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.TableViewPanel;
import com.sanrad.util.SrResourceBundle;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;

public class AclViewPanel
extends TableViewPanel {
    protected AclWorkbenchFrame workbench;
    protected JFrame owner;
    private SrMainTreePanel myMainTreePanel;
    SrAclTableModel myAclTableModel;

    public AclViewPanel(SrMainTreePanel mainTreePanel) {
        super(ClientLoader.BUNDLE.getString(SrClientBundleKeys.ACL_TABLE_PANEL_TITLE), new SrAclTablePanel(new SrAclTableModel(null, new SrDefaultTableColumns(AclTableHeader.getColumnNames()))));
        this.myMainTreePanel = mainTreePanel;
        this.m_tablePanel.setOpaque(false);
        this.m_tablePanel.add((Component)this.createLabelPanel(), "North");
        this.myAclTableModel = (SrAclTableModel)this.getCurrentTablePanel().getModel();
        this.myMainTreePanel.addMainTreeListener(this.myAclTableModel);
    }

    public void removeListeners() {
        this.myMainTreePanel.removeMainTreeListener(this.myAclTableModel);
    }

    public void clear() {
        this.myAclTableModel.clear();
    }

    private SrPanel createLabelPanel() {
        JButton attachBtn = new JButton("Attach Host Groups...");
        attachBtn.setFont(Font.decode(SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getString(SrDefaultUIBundleKeys.PANEL_TITLE_LABEL_FONT)));
        attachBtn.setToolTipText("Attach Host Groups to Targets");
        attachBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AclViewPanel.this.openAclWorkbench(e);
            }
        });
        SrPanel attachBtnPanel = new SrPanel(new FlowLayout(0));
        attachBtnPanel.add(attachBtn);
        attachBtnPanel.setOpaque(false);
        return attachBtnPanel;
    }

    private void openAclWorkbench(ActionEvent e) {
        TargetNode targetNode = (TargetNode)this.myMainTreePanel.getTreeObject().getSelectionPath().getLastPathComponent();
        AclWorkbenchFrame workbench = AclWorkbenchPool.getInstance().getWorkbench(targetNode);
        workbench.requestFocus();
        workbench.setState(0);
        workbench.setLocation(100, 100);
        workbench.show();
    }

    public void newClusterHasBeenSelected() {
        if (this.workbench != null) {
            this.workbench.newClusterHasBeenSelected();
        }
    }
}

