/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.acl;

import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.RendererPanel;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.swing.LookAndFill;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class AclTableRenderer
extends DefaultTableCellRenderer {
    private RendererPanel m_rendererPanel = new RendererPanel();

    public AclTableRenderer() {
        this.setFont(LookAndFill.GENERAL_FONT);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setText(value.toString());
        if (hasFocus) {
            this.setBorder(null);
        }
        if (isSelected) {
            this.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
            this.setForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
        } else {
            this.setBackground(LookAndFill.TABLE_BACKGROUND);
            this.setForeground(LookAndFill.TABLE_FOREGROUND);
        }
        if (value instanceof Permission) {
            this.setIcon(this.getAccessRightsIcon(value));
        }
        if (value instanceof AliasObject || value instanceof IdentityNode) {
            this.setIcon(ClientImageObject.IDENTITIES.getImageIcon());
            this.m_rendererPanel.restorePanel(this, (SrTreeNode)((AliasObject)value).getValue());
            if (isSelected) {
                this.m_rendererPanel.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
            } else {
                this.m_rendererPanel.setBackground(Color.white);
            }
            return this.m_rendererPanel;
        }
        return this;
    }

    private ImageIcon getAccessRightsIcon(Object value) {
        Permission accessRight = (Permission)value;
        if (accessRight.equals(Permission.N_A)) {
            return ClientImageObject.NOT_ACCESSIBLE.getImageIcon();
        }
        if (accessRight.equals(Permission.READ_ONLY)) {
            return ClientImageObject.READ_ONLY.getImageIcon();
        }
        return ClientImageObject.READ_WRITE.getImageIcon();
    }
}

