/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.acl;

import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.components.SrComboBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class AccessRightsEditor
extends SrComboBox
implements TableCellEditor,
TableCellRenderer {
    private boolean isRowSelected;
    private Vector listeners;

    public AccessRightsEditor() {
        this.setFont(LookAndFill.GENERAL_FONT);
        AccessRightsRenderer accessRenderer = new AccessRightsRenderer();
        this.setRenderer(accessRenderer);
        this.addItem(Permission.READ_WRITE);
        this.addItem(Permission.READ_ONLY);
        this.addItem(Permission.N_A);
        this.listeners = new Vector();
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                AccessRightsEditor.this.notifyEditingStopped();
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessRightsEditor.this.notifyEditingStopped();
            }
        });
        this.addItemListener(accessRenderer);
    }

    private void notifyEditingStopped() {
        ChangeEvent e = new ChangeEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((CellEditorListener)this.listeners.get(i)).editingStopped(e);
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.getSelectedItem();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        ChangeEvent event = new ChangeEvent(this);
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((CellEditorListener)e.nextElement()).editingStopped(event);
        }
        return true;
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.addElement(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        Component component = renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.isRowSelected = isSelected;
        this.setColors(isSelected, component);
        ((JLabel)component).setIcon(this.getAccessRightIcon(value));
        return component;
    }

    private void setColors(boolean isSelected, Component component) {
        if (isSelected) {
            component.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
            component.setForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
            return;
        }
        component.setBackground(LookAndFill.TABLE_BACKGROUND);
        component.setForeground(LookAndFill.TABLE_FOREGROUND);
    }

    private ImageIcon getAccessRightIcon(Object value) {
        Permission accessRight = (Permission)value;
        if (accessRight.equals(Permission.N_A)) {
            return ClientImageObject.NOT_ACCESSIBLE.getImageIcon();
        }
        if (accessRight.equals(Permission.READ_ONLY)) {
            return ClientImageObject.READ_ONLY.getImageIcon();
        }
        return ClientImageObject.READ_WRITE.getImageIcon();
    }

    class AccessRightsRenderer
    extends DefaultListCellRenderer
    implements ItemListener {
        AccessRightsRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            AccessRightsEditor.this.setColors(isSelected, this);
            this.setIcon(AccessRightsEditor.this.getAccessRightIcon(value));
            return this;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (AccessRightsEditor.this.isRowSelected) {
                this.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
                this.setForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
                return;
            }
            this.setBackground(LookAndFill.TABLE_BACKGROUND);
            this.setForeground(LookAndFill.TABLE_FOREGROUND);
        }
    }
}

