/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.volume.VolumeOperationHandler;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.SrTreeCellRenderer;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;

public class VolumeTreeCellRenderer
extends SrTreeCellRenderer {
    private VolumeOperationHandler volOperHandler;

    public VolumeTreeCellRenderer() {
        this((VolumeOperationHandler)null);
    }

    public VolumeTreeCellRenderer(VolumeOperationHandler volOperHandler) {
        this.volOperHandler = volOperHandler;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        ImageIcon icon = null;
        if (value instanceof SrTreeNode) {
            icon = ((SrTreeNode)value).getNodeIcon();
        }
        if (value instanceof VolumeTreeNode) {
            VolumeTreeNode node = (VolumeTreeNode)value;
            if (this.volOperHandler != null) {
                String tooltip = this.volOperHandler.isOperationLegitimate(node);
                this.setEnabled(tooltip == null);
                if (tooltip != null) {
                    this.setToolTipText(tooltip);
                }
            }
            icon = this.getIcon((ImageIcon)((SrTreeNode)value).getAlarmIcon(), icon);
        }
        this.setLeafIcon(icon);
        this.setOpenIcon(icon);
        this.setClosedIcon(icon);
        this.setDisabledIcon(icon);
        this.setIcon(icon);
        if (value instanceof SrTreeNode) {
            this.setEnabled(((SrTreeNode)value).isEnabled() && this.isEnabled());
        }
        return this;
    }
}

