/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.HashMap;
import org.jfree.chart.LegendItem;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class SrXYItemRenderer
extends StandardXYItemRenderer {
    private static SrLogger theLogger = SrLogger.getExternalPackageLogger();
    private HashMap m_currentRateMap;
    private static final String CURRENT_RATE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_STATISTICS_CHART_CURRENT_LEGEND_LABEL);

    public SrXYItemRenderer() {
    }

    public SrXYItemRenderer(int type) {
        super(type);
    }

    public SrXYItemRenderer(int type, XYToolTipGenerator toolTipGenerator) {
        super(type, toolTipGenerator);
    }

    public SrXYItemRenderer(int type, XYToolTipGenerator toolTipGenerator, XYURLGenerator urlGenerator, TimeSeriesCollection dataset) {
        super(type, toolTipGenerator, urlGenerator);
        int seriesCount = dataset.getSeriesCount();
        this.m_currentRateMap = new HashMap(seriesCount);
        for (int series = 0; series < seriesCount; ++series) {
            this.m_currentRateMap.put(dataset.getSeriesName(series), new Integer(0));
        }
    }

    @Override
    public LegendItem getLegendItem(int datasetIndex, int series) {
        XYDataset dataset;
        LegendItem result = null;
        XYPlot plot = this.getPlot();
        if (plot != null && (dataset = plot.getDataset(datasetIndex)) != null && this.getItemVisible(series, 0)) {
            String label;
            String labelKey = dataset.getSeriesName(series);
            StringBuffer labelBuff = new StringBuffer(labelKey);
            if (this.m_currentRateMap.containsKey(labelKey)) {
                labelBuff.append(" (");
                labelBuff.append(CURRENT_RATE);
                labelBuff.append((Number)this.m_currentRateMap.get(labelKey));
                labelBuff.append(")");
            }
            String description = label = labelBuff.toString();
            Shape shape = this.getSeriesShape(series);
            boolean shapeFilled = this.getSeriesShapesFilled(series);
            Paint paint = this.getSeriesPaint(series);
            Paint outlinePaint = this.getSeriesOutlinePaint(series);
            Stroke stroke = this.getSeriesStroke(series);
            result = new LegendItem(label, description, shape, shapeFilled, paint, stroke, outlinePaint, stroke);
        }
        return result;
    }

    public void setCurrentRateLabel(String seriesName, Number number) {
        if (this.m_currentRateMap.containsKey(seriesName)) {
            this.m_currentRateMap.put(seriesName, number);
        } else {
            theLogger.error(SrLogCategories.LEGACY, "Series name : ", seriesName, " is not defined in the chart dataset!");
        }
    }
}

