/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.ConcatinationVolumeNode;
import com.sanrad.nms.client.data.volume.CubeVolumeNode;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.MirrorVolumeNode;
import com.sanrad.nms.client.data.volume.ReplaceVolumeOperationHandler;
import com.sanrad.nms.client.data.volume.ResizeVolumeOperationHandler;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.StripeVolumeNode;
import com.sanrad.nms.client.data.volume.TransparentVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.data.volume.copy.MirrorSyncOperationNode;
import com.sanrad.nms.client.data.volume.copy.MirrorSyncTableModelCollection;
import com.sanrad.nms.client.data.volume.copy.OfflineCopyOperationHandler;
import com.sanrad.nms.client.data.volume.copy.RestoreOperationNode;
import com.sanrad.nms.client.data.volume.copy.SrMirrorSyncTableModel;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotSchedulerManager;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotSchedulerNode;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionAdapter;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionEvent;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.MainFrame;
import com.sanrad.nms.client.gui.SrClientTreePanel;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrTransientWindowPane;
import com.sanrad.nms.client.gui.VolumeTreeCellRenderer;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.storage.dialogs.DirectAccessDevicePropertiesDialog;
import com.sanrad.nms.client.gui.storage.dialogs.SubdiskPropertiesDialog;
import com.sanrad.nms.client.gui.volume.SrVolumeTreePopupMenu;
import com.sanrad.nms.client.gui.volume.VolumeOperationFramePool;
import com.sanrad.nms.client.gui.volume.copy.dialogs.MirrorSyncOperationDialog;
import com.sanrad.nms.client.gui.volume.copy.dialogs.OfflineCopyOperationDialog;
import com.sanrad.nms.client.gui.volume.dialogs.JournalVolumePropertiesDialog;
import com.sanrad.nms.client.gui.volume.dialogs.StripeVolumePropertiesDialog;
import com.sanrad.nms.client.gui.volume.dialogs.VolumePropertiesDialog;
import com.sanrad.nms.client.gui.volume.snapshot.SnapshotSchedulerDialog;
import com.sanrad.nms.client.gui.volume.snapshot.dialogs.SnapshotVolumePropertiesDialog;
import com.sanrad.nms.client.gui.volume.snapshot.dialogs.SnapshotVolumesDialog;
import com.sanrad.nms.client.gui.volume.snapshot.dialogs.SnapshotsVolumesDialogPool;
import com.sanrad.nms.client.gui.volume.snapshot.dialogs.TakeSnapshotDialog;
import com.sanrad.nms.client.gui.volume.wizard.clone.SrAddMirrorWizardFrame;
import com.sanrad.nms.server.license.LicenseManager;
import com.sanrad.nms.server.license.SrFeatureNameConstant;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.swing.SrPopupMenu;
import com.sanrad.swing.SrTreeModel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.TreeView;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.wizard.SrWizardFrame;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class SrVolumeTreePanel
extends SrClientTreePanel
implements TreeModelListener {
    private static SrLogger theLogger = SrLogger.getLogger();
    protected JFrame myOwner;
    private VolumeSelectionAdapter m_sourceAdapter = new VolumeSelectionAdapter();
    protected VolumeTreeCellEditor volumeTreeCellEditor;
    private static final SrLicenseTreePath theTransparentPropertiesLicensePath = new SrLicenseTreePath(SrLicenseTreePath.VOLUME_PATH, new SrFeatureNameConstant[]{SrFeatureNameConstant.NON_VIRTUAL, SrFeatureNameConstant.TRANSPARENT, SrFeatureNameConstant.PROPERTIES});
    public final View<VolumeTreeNode> myView = new TreeView<VolumeTreeNode>(this.m_tree, VolumeTreeNode.class);
    public final SrClientAction activateSnapshot = new VolumeManager.ActivateDeactivateSnapshot<VolumeTreeNode>(true, this.myView, StatusPanel.getInstance());
    public final SrClientAction deactivateSnapshot = new VolumeManager.ActivateDeactivateSnapshot<VolumeTreeNode>(false, this.myView, StatusPanel.getInstance());
    public final SrClientAction restoreSnapshotAction = new SrClientAction<VolumeTreeNode, Void>("Start Rollback", true, true, this.myView, SrLicenseTreePath.VOLUME_PATH){
        private Collection<VolumeTreeNode> myLastArgs;

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
            ArrayList<CommKeyClassId> ids = new ArrayList<CommKeyClassId>(arg.size());
            this.myLastArgs = new ArrayList<VolumeTreeNode>(arg.size());
            ClusterNode cluster = null;
            for (VolumeTreeNode volumeNode : arg) {
                SnapshotVolumeNode node = (SnapshotVolumeNode)volumeNode;
                cluster = SystemRootNode.getInstance().getClusterNodeOfSource(node);
                JFrame frame = new JFrame();
                frame.setIconImage(ClientImageObject.APP_ICON.getImageIcon().getImage());
                StringBuffer msg = CopyOperManager.getInstance().getRollbackConfirmMsg(node);
                int result = JOptionPane.showConfirmDialog(SrVolumeTreePanel.this, msg.toString(), "Start Rollback Operation Confirmation", 2, 3);
                if (result == 2) continue;
                ids.add((CommKeyClassId)node.getIdentifier());
                this.myLastArgs.add(node);
            }
            return Collections.singleton(ClientAOImpl.getInstance().restoreSnapshots(cluster.getCopyOperManagerID(), ids));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (VolumeTreeNode volumeNode : this.myView.getValue()) {
                SnapshotVolumeNode snapshotVolume = (SnapshotVolumeNode)volumeNode;
                StringBuffer reason = new StringBuffer("");
                boolean isLegitimateForRestoreOper = CopyOperManager.getInstance().isLegitimateForRestoreOper(snapshotVolume, reason);
                if (isLegitimateForRestoreOper) continue;
                return reason.toString();
            }
            return null;
        }

        @Override
        protected boolean shouldClientActionBeVisible() {
            VolumeManager volMgr = VolumeManager.getInstance();
            for (VolumeTreeNode volumeNode : this.myView.getValue()) {
                if (volMgr.isSnapshotVolume(volumeNode)) continue;
                return false;
            }
            return true;
        }

        @Override
        protected void onActionFinished(Collection<? extends SrFuture<Void>> aFutures) {
            super.onActionFinished(aFutures);
            if (!this.myLastArgs.isEmpty() && 1.isSuccessful(aFutures, 1)) {
                ArrayList<RestoreOperationNode> started = new ArrayList<RestoreOperationNode>(this.myLastArgs.size());
                for (VolumeTreeNode volume : this.myLastArgs) {
                    RestoreOperationNode restoreOperation = ((SnapshotVolumeNode)volume).getRestoreOperation();
                    if (!CopyOperManager.getInstance().operationStatusActive(restoreOperation.getCopyStatus())) continue;
                    started.add(restoreOperation);
                }
                SrTransientWindowPane.showMultiSnapshotRollbackStarted(ClientLoader.getMainFrame(), started.size(), this.myLastArgs.size(), MainFrame.createShowConstantRestoreOperationAction(started));
            }
            this.myLastArgs = null;
        }
    };
    public final SrClientAction mirrorSyncAction = new SrClientAction<VolumeTreeNode, Void>("Sync", true, true, this.myView, SrLicenseTreePath.VOLUME_PATH){
        private Collection<VolumeTreeNode> myLastArg;
        {
            this.myLastArg = null;
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
            this.myLastArg = arg;
            ArrayList<CommKeyClassId> ids = new ArrayList<CommKeyClassId>(arg.size());
            for (VolumeTreeNode node : arg) {
                ids.add((CommKeyClassId)node.getIdentifier());
            }
            return Collections.singleton(ClientAOImpl.getInstance().mirrorSync(ids));
        }

        @Override
        protected void onActionFinished(Collection<? extends SrFuture<Void>> aFutures) {
            super.onActionFinished(aFutures);
            if (!2.isSuccessful(aFutures, 1)) {
                return;
            }
            ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(this.myLastArg.iterator().next());
            SrMirrorSyncTableModel model = (SrMirrorSyncTableModel)MirrorSyncTableModelCollection.getInstance().getModel(clusterNode);
            ArrayList<MirrorSyncOperationNode> toSelect = new ArrayList<MirrorSyncOperationNode>();
            int total = 0;
            for (MirrorSyncOperationNode mirrorSyncOperationNode : model.getCopyOperations()) {
                if (!this.myLastArg.contains(mirrorSyncOperationNode.getSource().getParent())) continue;
                toSelect.add(mirrorSyncOperationNode);
                ++total;
            }
            SrTransientWindowPane.showMultiMirrorSyncStarted(ClientLoader.getMainFrame(), toSelect.size(), total, MainFrame.createShowConstantMirrorSyncOperationsAction(toSelect));
            this.myLastArg = null;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (VolumeTreeNode node : this.myView.getValue()) {
                String retVal = SrVolumeTreePanel.this.handleMirrSync(this, node);
                if (retVal == null) continue;
                return retVal;
            }
            return null;
        }
    };
    public final SrClientAction replaceVolumeAction = new SrClientAction<VolumeTreeNode, Void>("Replace", true, true, this.myView, SrLicenseTreePath.VOLUME_PATH, true){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
            VolumeTreeNode node = arg.iterator().next();
            VolumeOperationFramePool.getInstance().openVolumeOperationFrame(node, new ReplaceVolumeOperationHandler(node));
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String getContextMismatchTooltip() {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_SOURCE_IS_NULL_OR_NOT_A_VOLUME);
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            VolumeTreeNode treeNode = (VolumeTreeNode)this.myView.getValue().iterator().next();
            if (!treeNode.isNonFunctional()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_IS_FUNCTIONAL);
            }
            if (treeNode.isInconsistent()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_IS_INCONSISTENT);
            }
            if (treeNode.isIllegal()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_IS_ILLEGAL);
            }
            if (SrVolumeTreePopupMenu.isExposedOnDisconnectedVswitch(treeNode)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_EXPOSE_ON_DISCONNECTED_VSWITCH);
            }
            if (CopyOperManager.getInstance().isExistActiveCopyInHeirarchy(treeNode)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_EXISTS_IN_OFFLINE_COPY_OR_MIRROR_SYNC);
            }
            TreeNode parent = treeNode.getParent();
            if (parent instanceof VolumeTreeNode) {
                VolumeTreeNode parentNode = (VolumeTreeNode)parent;
                if (parentNode.isIllegal()) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_REPLACE_VALIDATION_VOLUME_PARENT_IS_ILLEGAL);
                }
                if (parentNode.isInconsistent()) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_REPLACE_VALIDATION_VOLUME_PARENT_IS_INCONSISTENT);
                }
            } else {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_REPLACE_VALIDATION_VOLUME_IS_ROOT);
            }
            return null;
        }
    };
    public final SrClientAction copyAction = new SrClientAction<VolumeTreeNode, Void>("Copy...", true, true, this.myView, SrLicenseTreePath.VOLUME_PATH, true){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
            VolumeTreeNode node = arg.iterator().next();
            VolumeOperationFramePool.getInstance().openVolumeOperationFrame(node, new OfflineCopyOperationHandler(node));
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            VolumeTreeNode node = (VolumeTreeNode)this.myView.getValue().iterator().next();
            if (node.isExposed()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_COPY_OPER_NOT_ALLOWED_ON_EXPOSED);
            }
            StringBuffer reason = new StringBuffer("");
            if (!CopyOperManager.getInstance().isLegitimateForCopyOper(node, reason)) {
                return reason.toString();
            }
            return null;
        }
    };
    public final SrClientAction showSnapshotAction = new SrClientAction<VolumeTreeNode, Void>("Show snapshots...", true, true, this.myView, SrLicenseTreePath.VOLUME_PATH, true){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
            VolumeTreeNode node = arg.iterator().next();
            ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(node);
            SnapshotVolumesDialog dialog = SnapshotsVolumesDialogPool.getInstance().getSnapshotsVolumeDialog(SrVolumeTreePanel.this.myOwner, clusterNode, node);
            dialog.show();
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            VolumeTreeNode node = (VolumeTreeNode)this.myView.getValue().iterator().next();
            if (!VolumeManager.getInstance().getClusterSnapshotMap().isSourceOfSnapshot(SystemRootNode.getInstance().getClusterNodeOfSource(node), node)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_SNAPSHOT_SOURCE_VALIDAION_THE_VOLUME_IS_NOT_A_SNAPSHOT_SOURCE);
            }
            return null;
        }
    };
    public final SrClientAction copyShowAction = new SrClientAction<VolumeTreeNode, Void>("Show...", true, true, this.myView, SrLicenseTreePath.VOLUME_PATH, true){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
            VolumeTreeNode node = arg.iterator().next();
            ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(node);
            OfflineCopyOperationDialog dialog = OfflineCopyOperationDialog.getInstance(SrVolumeTreePanel.this.myOwner, clusterNode);
            if (dialog != null) {
                dialog.show();
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            VolumeTreeNode node = (VolumeTreeNode)this.myView.getValue().iterator().next();
            if (!CopyOperManager.getInstance().isInvolvedInOfflineCopy(node)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_COPY_SHOW_VALIDATION_VOLUME_NOT_INVOLVE_IN_OFFLINE_COPY);
            }
            return null;
        }
    };
    public final SrClientAction showMirrorSyncAction = new SrClientAction<VolumeTreeNode, Void>("Show...", true, true, this.myView, SrLicenseTreePath.VOLUME_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
            ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(arg.iterator().next());
            MirrorSyncOperationDialog dialog = MirrorSyncOperationDialog.getInstance(SrVolumeTreePanel.this.myOwner, clusterNode);
            dialog.show();
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (VolumeTreeNode node : this.myView.getValue()) {
                String retVal = SrVolumeTreePanel.this.handleMirrSync(this, node);
                if (retVal == null) continue;
                return retVal;
            }
            return null;
        }
    };
    public final SrClientAction snapshotSchedulerAction = new SrClientAction<VolumeTreeNode, Void>("Create snapshot schedule...", true, true, this.myView, SrLicenseTreePath.VOLUME_PATH, true){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
            final VolumeTreeNode node = arg.iterator().next();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SnapshotSchedulerDialog d = new SnapshotSchedulerDialog(node);
                    d.setVisible(true);
                }
            });
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            VolumeTreeNode vol = (VolumeTreeNode)this.myView.getValue().iterator().next();
            SnapshotSchedulerNode schedNode = SnapshotSchedulerManager.getInstance().getSnapshotSchedulerOfSource(vol);
            this.setName(schedNode == null ? "Create snapshot schedule..." : "Edit snapshot schedule...");
            StringBuffer reason = new StringBuffer("");
            if (!VolumeManager.getInstance().canBeSnapshotSource(vol, reason)) {
                return reason.toString();
            }
            if (schedNode == null && !this.canAllocateMoreSnapshots(vol)) {
                return "Cannot create any more snapshots";
            }
            return null;
        }

        private boolean canAllocateMoreSnapshots(VolumeTreeNode aVolume) {
            ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(aVolume);
            int snapCount = VolumeManager.getInstance().getClusterSnapshotMap().getSnapshotCount(cluster, aVolume);
            int leftSnaps = VolumeManager.MAX_SNAPSHOTS_PER_VOLUME - snapCount;
            return leftSnaps > 0;
        }
    };
    public final SrClientAction createSnapshotAction = new SrClientAction<VolumeTreeNode, Void>("Take snapshot now...", true, true, this.myView, SrLicenseTreePath.VOLUME_PATH, true){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
            final VolumeTreeNode node = arg.iterator().next();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TakeSnapshotDialog d = new TakeSnapshotDialog(node);
                    d.setVisible(true);
                }
            });
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            StringBuffer reason = new StringBuffer("");
            if (!VolumeManager.getInstance().canBeSnapshotSource((VolumeTreeNode)this.myView.getValue().iterator().next(), reason)) {
                return reason.toString();
            }
            return null;
        }
    };
    public final SrClientAction addMirrorAction = new SrClientAction<VolumeTreeNode, Void>("Add...", true, true, this.myView, SrLicenseTreePath.VOLUME_PATH, true){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
            VolumeTreeNode node = arg.iterator().next();
            if (node instanceof SnapshotVolumeNode) {
                node = (VolumeTreeNode)node.getChildAt(0);
            }
            ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(node);
            SrAddMirrorWizardFrame frm = new SrAddMirrorWizardFrame((JFrame)ClientLoader.getMainFrame(), clusterNode, node, true);
            frm.runWizard();
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            if (SrWizardFrame.isAlreadyRunningWizard(SrAddMirrorWizardFrame.class)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NO_ADD_MIRROR_WIZARD_IS_ALREADY_OPENED);
            }
            VolumeTreeNode node = (VolumeTreeNode)this.myView.getValue().iterator().next();
            if (SrVolumeTreePopupMenu.isExposedOnDisconnectedVswitch(node)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_EXPOSE_ON_DISCONNECTED_VSWITCH);
            }
            TreeNode nodeParent = node.getParent();
            MirrorVolumeNode mirrVol = null;
            if (node instanceof TransparentVolumeNode) {
                ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_IS_TANSPARENT);
            }
            if (nodeParent instanceof SnapshotVolumeNode) {
                SnapshotVolumeNode snapNode = (SnapshotVolumeNode)nodeParent;
                if (VolumeManager.getInstance().isSnapshotSourceUsedByAPair(snapNode)) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_PARENT_VOLUME_IS_GDR_SNAPSHOT);
                }
            }
            if (nodeParent instanceof TransparentVolumeNode) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_PARENT_VOLUME_IS_TANSPARENT);
            }
            if (nodeParent instanceof CubeVolumeNode) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_VOLUME_IS_A_CUBE);
            }
            if (node instanceof MirrorVolumeNode) {
                mirrVol = (MirrorVolumeNode)node;
            } else if (nodeParent instanceof MirrorVolumeNode) {
                mirrVol = (MirrorVolumeNode)nodeParent;
            }
            if (mirrVol != null && mirrVol.getChildCount() >= 4) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.VOLUME_TREE_MIRROR_VALIDATION_THE_MIRROR_CHILD_COUNT_IS_BIGGER_THAN_MAX_CHILD_ALLOWED, "4");
            }
            if (mirrVol != null && mirrVol.isIllegal()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_IS_ILLEGAL);
            }
            if (mirrVol != null && mirrVol.isInconsistent()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_IS_INCONSISTENT);
            }
            VolumeTreeNode treeNode = node;
            DRPairNode pair = DRPairManager.getPairContainingVolume(treeNode);
            if (pair != null) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_SOURCE_IS_USED_BY_PAIR);
            }
            if (mirrVol != null && DRPairManager.getPairContainingVolume(mirrVol) != null) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_SOURCE_IS_USED_BY_PAIR);
            }
            if (CopyOperManager.getInstance().isExistActiveCopyInHeirarchy(treeNode)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_EXISTS_IN_OFFLINE_COPY_OR_MIRROR_SYNC);
            }
            if (!(treeNode.isExposed() || treeNode.getParent() instanceof VolumeTreeNode || node instanceof MirrorVolumeNode)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_MIRROR_VALIDATION_INTERNAL_VOLUME_HAS_NO_PARENT_VOLUME_AND_IS_NOT_A_MIRROR);
            }
            if (treeNode.isIllegal()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_IS_ILLEGAL);
            }
            if (treeNode.isInconsistent()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_IS_INCONSISTENT);
            }
            if (SnapshotSchedulerManager.getInstance().getSnapshotSchedulerOfSource(node) != null) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_VOLUME_HAS_A_SNAPSHOT_SCHEDULER);
            }
            return null;
        }
    };
    public final SrClientAction resizeAction = new SrClientAction<VolumeTreeNode, Void>("Resize...", true, true, this.myView, SrLicenseTreePath.VOLUME_PATH, true){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
            VolumeTreeNode node = arg.iterator().next();
            if (node instanceof SnapshotVolumeNode) {
                node = (VolumeTreeNode)node.getChildAt(0);
            }
            VolumeOperationFramePool.getInstance().openVolumeOperationFrame(node, new ResizeVolumeOperationHandler(node));
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            VolumeTreeNode treeNode = (VolumeTreeNode)this.myView.getValue().iterator().next();
            if (treeNode instanceof StorageDeviceNode) {
                StorageDeviceNode storageDeviceNode = (StorageDeviceNode)treeNode;
                if (storageDeviceNode.isTape() || storageDeviceNode.isProcessor()) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_RESIZE_VALIDATION_THE_STORAGE_IS_NOT_A_DISK_OR_SUBDISK);
                }
                if (storageDeviceNode.isSubDisk()) {
                    DirectAccessDeviceNode parentDisk = ((SubDirectAccessDeviceNode)treeNode).getDirectAccessDeviceParent();
                    if (VolumeManager.getInstance().isMissingOrInvalidDisk(parentDisk)) {
                        return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_RESIZE_VALIDATION_THE_SUBDISK_PARENT_IS_MISSING_OR_INVALID);
                    }
                }
                if (storageDeviceNode.isDisk() && VolumeManager.getInstance().isMissingOrInvalidDisk((DirectAccessDeviceNode)treeNode)) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_RESIZE_VALIDATION_THE_DISK_IS_MISSING_OR_INVALID);
                }
            }
            if (SrVolumeTreePopupMenu.isExposedOnDisconnectedVswitch(treeNode)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_RESIZE_VALIDATION_THE_SOURCE_IS_EXPOSED_ON_DISCONNECTED_VSWITCH);
            }
            if (treeNode instanceof TransparentVolumeNode) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_SOURCE_CANNOT_BE_TRANSPARENT_VOLUME);
            }
            if (treeNode instanceof StripeVolumeNode) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_SOURCE_CANNOT_BE_STRIPE_VOLUME);
            }
            if (treeNode instanceof JournalVolumeNode) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_SOURCE_CANNOT_BE_JOURNAL_VOLUME);
            }
            if (treeNode instanceof SnapshotVolumeNode) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_SOURCE_CANNOT_BE_SNAPSHOT_VOLUME);
            }
            if (treeNode instanceof MirrorVolumeNode) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_SOURCE_CANNOT_BE_MIRROR_VOLUME);
            }
            TreeNode nodeParent = treeNode.getParent();
            if (DRPairManager.getPairContainingVolume(treeNode) != null) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_SOURCE_IS_USED_BY_PAIR);
            }
            if (treeNode.isNonFunctional()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_IS_NON_FUNCTIONAL);
            }
            if (treeNode.isIllegal()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_IS_ILLEGAL);
            }
            if (treeNode.isInconsistent()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_IS_INCONSISTENT);
            }
            if (nodeParent instanceof TransparentVolumeNode) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_PARENT_VOLUME_IS_TANSPARENT);
            }
            if (nodeParent instanceof SnapshotVolumeNode && !(treeNode instanceof DirectAccessDeviceNode) && !(treeNode instanceof ConcatinationVolumeNode)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_RESIZE_VALIDATION_THE_SNAPSHOT_CHILD_IS_NOT_A_DISK_OR_CONCATINATION_VOLUME);
            }
            if (SnapshotSchedulerManager.getInstance().getSnapshotSchedulerOfSource(treeNode) != null) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_VOLUME_HAS_A_SNAPSHOT_SCHEDULER);
            }
            ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(treeNode);
            if (VolumeManager.getInstance().getClusterSnapshotMap().isSourceOfSnapshot(clusterNode, treeNode)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_VOLUME_HAS_A_SNAPSHOT);
            }
            SnapshotVolumeNode snapshotParent = (SnapshotVolumeNode)treeNode.getAncestorOfType(SnapshotVolumeNode.class);
            if (snapshotParent != null && SnapshotSchedulerManager.getInstance().getSchedulerOfSnapshot(snapshotParent) != null) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_RESIZE_VALIDATION_SNAPSHOT_BELONGS_SCHEDULER);
            }
            if (CopyOperManager.getInstance().isExistActiveCopyInHeirarchy(treeNode)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_VOLUME_IS_PART_OF_COPY_OPR_OR_MIRROR_SYNC);
            }
            if (nodeParent instanceof VolumeTreeNode && DRPairManager.getPairContainingVolume((VolumeTreeNode)nodeParent) != null) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_PAIR_VALIDAION_THE_SOURCE_IS_USED_BY_GDR);
            }
            return null;
        }
    };
    public final SrClientAction expandAction = new SrClientAction<VolumeTreeNode, Void>("Expand", true, true, this.myView, SrLicenseTreePath.VOLUME_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
            this.setConnectionErrorMessage("Failed to Expand.");
            ArrayList<CommKeyClassId> ids = new ArrayList<CommKeyClassId>(arg.size());
            for (VolumeTreeNode node : arg) {
                theLogger.logAndAssert(SrLogCategories.ERROR, node instanceof ConcatinationVolumeNode || node instanceof MirrorVolumeNode, new Object[]{node + " to expand is neither Concat nor Mirror"});
                ids.add((CommKeyClassId)node.getIdentifier());
            }
            return Collections.singleton(ClientAOImpl.getInstance().expand(ids));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (VolumeTreeNode node : this.myView.getValue()) {
                if (CopyOperManager.getInstance().isInvolvedInAnyCopyOper(node)) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_VOLUME_IS_PART_OF_COPY_OPR_OR_MIRROR_SYNC);
                }
                if (SrVolumeTreePopupMenu.isExposedOnDisconnectedVswitch(node)) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_EXPOSE_ON_DISCONNECTED_VSWITCH);
                }
                if (VolumeManager.getInstance().canBeExpand(node)) continue;
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_EXPAND_VALIDATION_THE_SOURCE_CANNOT_BE_EXPAND);
            }
            return null;
        }
    };
    public final SrClientAction retractAction = new SrClientAction<VolumeTreeNode, Void>("Retract", true, true, this.myView, SrLicenseTreePath.VOLUME_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
            ArrayList<CommKeyClassId> ids = new ArrayList<CommKeyClassId>(arg.size());
            for (VolumeTreeNode node : arg) {
                ids.add((CommKeyClassId)node.getIdentifier());
            }
            return Collections.singleton(ClientAOImpl.getInstance().retract(ids));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (VolumeTreeNode node : this.myView.getValue()) {
                if (!(node instanceof ConcatinationVolumeNode)) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_SOURCE_IS_NOT_A_CONCATINATION_VOLUME);
                }
                if (!VolumeManager.getInstance().canBeRetract(node)) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_RETRACT_VALIDATION_THE_SOURCE_CANNOT_BE_RETRACT);
                }
                if (SrVolumeTreePopupMenu.isExposedOnDisconnectedVswitch(node)) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_EXPOSE_ON_DISCONNECTED_VSWITCH);
                }
                if (!CopyOperManager.getInstance().isExistActiveCopyInHeirarchy(node)) continue;
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_VOLUME_IS_PART_OF_COPY_OPR_OR_MIRROR_SYNC);
            }
            return null;
        }
    };
    public final SrClientAction breakMirrorAction = new SrClientAction<VolumeTreeNode, Void>("Break", true, true, this.myView, SrLicenseTreePath.VOLUME_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
            CommKeyClassId[] childrenKeys = new CommKeyClassId[arg.size()];
            int i = 0;
            for (VolumeTreeNode node : arg) {
                childrenKeys[i++] = (CommKeyClassId)node.getIdentifier();
            }
            MirrorVolumeNode parent = (MirrorVolumeNode)arg.iterator().next().getParent();
            return Collections.singleton(ClientAOImpl.getInstance().breakMirror((CommKeyClassId)parent.getIdentifier(), childrenKeys));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            Collection value = this.myView.getValue();
            VolumeTreeNode node = (VolumeTreeNode)value.iterator().next();
            TreeNode firstParent = node.getParent();
            if (!(firstParent instanceof MirrorVolumeNode)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_MIRROR_BREAK_VALIDATION_NOT_MIRROR_CHILD);
            }
            MirrorVolumeNode mirrorVol = (MirrorVolumeNode)firstParent;
            if (SrVolumeTreePopupMenu.isExposedOnDisconnectedVswitch(mirrorVol)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_EXPOSE_ON_DISCONNECTED_VSWITCH);
            }
            if (mirrorVol.isIllegal()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_IS_ILLEGAL);
            }
            if (DRPairManager.getPairContainingVolume(mirrorVol) != null) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_SOURCE_IS_USED_BY_PAIR);
            }
            if (CopyOperManager.getInstance().isExistActiveCopyInHeirarchy(node)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_EXISTS_IN_OFFLINE_COPY_OR_MIRROR_SYNC);
            }
            for (VolumeTreeNode curNode : value) {
                if (firstParent.equals(curNode.getParent())) continue;
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_MIRROR_BREAK_VALIDATION_NOT_ALL_SELECTED_SOURCES_HAVE_THE_SAME_PARENT);
            }
            Vector<VolumeTreeNode> canSyncChildren = new Vector<VolumeTreeNode>();
            Vector<VolumeTreeNode> needSyncChildren = new Vector<VolumeTreeNode>();
            Enumeration<TreeNode> children = ((MirrorVolumeNode)firstParent).children();
            int numOfChildren = 0;
            while (children.hasMoreElements()) {
                VolumeTreeNode child = (VolumeTreeNode)children.nextElement();
                if (child.isNeedSync()) {
                    needSyncChildren.add(child);
                } else if (!child.isNeedSync() && !child.isNonFunctional()) {
                    canSyncChildren.add(child);
                }
                ++numOfChildren;
            }
            if (numOfChildren == value.size()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_MIRROR_BREAK_VALIDATION_CANNOT_BREAK_ALL_THE_MIRROR_CHILDREN);
            }
            for (VolumeTreeNode selected : value) {
                canSyncChildren.remove(selected);
                needSyncChildren.remove(selected);
            }
            if (needSyncChildren.size() > 0 && canSyncChildren.size() == 0) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_MIRROR_BREAK_VALIDATION_CANNOT_BREAK_LAST_CHILD_THAT_CAN_SYNC_IF_ANOTHER_CHILD_NEED_SYNC);
            }
            if (SnapshotSchedulerManager.getInstance().getSnapshotSchedulerOfSource(mirrorVol) != null) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_THE_VOLUME_HAS_A_SNAPSHOT_SCHEDULER);
            }
            return null;
        }
    };
    public final AlarmAction mySpecificAction = new AlarmAction<VolumeTreeNode>(this.myView, true);
    public final AlarmAction myPropagatedAction = new AlarmAction<VolumeTreeNode>(this.myView, false);
    public final SrClientAction volumePropertiesAction = new SrClientAction<VolumeTreeNode, Void>(null, null, true, true, this.myView, SrLicenseTreePath.GENERAL_PATH, false, false){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
            int i = 0;
            for (VolumeTreeNode node : arg) {
                final JDialog uo = (JDialog)node.getUserObject();
                if (uo == null) {
                    SrVolumeTreePanel.this.openPropertiesDialog(node, i);
                } else {
                    uo.requestFocus();
                    if (node instanceof VolumeNode) {
                        EventDispatcherTask.submit(new Runnable(){

                            @Override
                            public void run() {
                                uo.setVisible(true);
                            }
                        });
                    }
                }
                ++i;
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            if (!LicenseManager.getInstance().isEnabled(theTransparentPropertiesLicensePath, null)) {
                for (VolumeTreeNode node : this.myView.getValue()) {
                    if (!(node instanceof TransparentVolumeNode)) continue;
                    return SrClientAction.LICENSE_TOOLTIP;
                }
            }
            return null;
        }
    };
    public final SrClientAction renameAction = new SrClientAction<VolumeTreeNode, Void>("Rename", true, true, this.myView, SrLicenseTreePath.VOLUME_PATH, true){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
            SrVolumeTreePanel.this.startEditingAtPath(SrVolumeTreePanel.this.getSelectionPaths()[0]);
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };

    protected SrVolumeTreePanel(SrTreeModel model, JFrame owner) {
        super(model);
        this.myOwner = owner;
        this.createTree();
        this.breakMirrorAction.setConfirmationString("Are you sure you want to break the selected Mirror Children?");
        this.breakMirrorAction.setConfirmationTitle("Break Mirror Confirmation");
        this.breakMirrorAction.addControllerAsListener(StatusPanel.getInstance());
        this.mirrorSyncAction.addControllerAsListener(StatusPanel.getInstance());
        this.expandAction.addControllerAsListener(StatusPanel.getInstance());
        this.retractAction.addControllerAsListener(StatusPanel.getInstance());
        this.restoreSnapshotAction.addControllerAsListener(StatusPanel.getInstance());
        this.setTreePopupMenu(this.getPopupObject());
        AlarmsManager.getInstance().addAlarmSourceSelectionListener(this.m_sourceAdapter);
        this.getTreeObject().setFont(new Font("Verdana", 0, 9));
        this.getTreeObject().setShowsRootHandles(false);
    }

    protected SrPopupMenu getPopupObject() {
        return null;
    }

    public abstract void newClusterHasBeenSelected();

    private String handleMirrSync(SrClientAction<VolumeTreeNode, Void> action, VolumeTreeNode node) {
        boolean isParentSnapshotInActiveRollbackOper;
        TreeNode nodeParent = node.getParent();
        MirrorVolumeNode mirrVol = null;
        if (node instanceof MirrorVolumeNode) {
            mirrVol = (MirrorVolumeNode)node;
        } else if (nodeParent instanceof MirrorVolumeNode) {
            mirrVol = (MirrorVolumeNode)nodeParent;
        }
        if (mirrVol == null) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_MIRROR_SYNC_VALIDATION_SOURCE_IS_NOT_A_MIRROR);
        }
        if (VolumeManager.getInstance().getClusterSnapshotMap().isInvolvedInActiveRestore(mirrVol) && action == this.mirrorSyncAction) {
            return "This volume is involved in an active restore";
        }
        boolean oneOfChildIsMirrorSyncDst = false;
        Enumeration<TreeNode> children = mirrVol.children();
        ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(mirrVol);
        SrMirrorSyncTableModel currentModel = (SrMirrorSyncTableModel)MirrorSyncTableModelCollection.getInstance().getModel(cluster);
        int i = 0;
        while (children.hasMoreElements()) {
            VolumeTreeNode child = (VolumeTreeNode)children.nextElement();
            if (!child.isNonFunctional() && currentModel.isMirrorSyncDst(child)) {
                oneOfChildIsMirrorSyncDst = true;
                break;
            }
            ++i;
        }
        VolumeTreeNode treeNode = node;
        boolean isMirrorVolume = mirrVol.equals(node);
        boolean isParentMirrorVolume = mirrVol == nodeParent;
        boolean isCopySrc = currentModel.isCopySrc(node);
        boolean isNotDstOfMirrorSync = !currentModel.isMirrorSyncDst(node);
        boolean bl = isParentSnapshotInActiveRollbackOper = nodeParent instanceof SnapshotVolumeNode && ((SnapshotVolumeNode)nodeParent).isInvolvedInAnotherActiveRestoreOperation();
        if (cluster == null) {
            SrLogger.getLogger().error(SrLogCategories.LEGACY, ">>>> ERROR!!! ClusterSnapshotMap: clusterNode is NULL when trying to call to getSnapshotMap");
            return "";
        }
        if (action == this.mirrorSyncAction) {
            List<SnapshotVolumeNode> snapshots = VolumeManager.getInstance().getClusterSnapshotMap().getSnapshotsForSource(cluster, mirrVol);
            if (snapshots != null) {
                for (int i2 = 0; i2 < snapshots.size(); ++i2) {
                    SnapshotVolumeNode sns = snapshots.get(i2);
                    if (!sns.isInvolvedInAnotherRestoreOperation()) continue;
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_MIRROR_SYNC_VALIDATION_VOLUME_IS_SRC_OF_COPY_OPER);
                }
            }
            if (isMirrorVolume) {
                if (oneOfChildIsMirrorSyncDst) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_MIRROR_SYNC_VALIDATION_SOME_CHILD_IS_A_MIRROR_SYNC_DST);
                }
                if (isParentSnapshotInActiveRollbackOper) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_MIRROR_SYNC_VALIDATION_VOLUME_IS_SRC_OF_COPY_OPER);
                }
            } else {
                if (!isParentMirrorVolume) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_MIRROR_SYNC_VALIDATION_PARENT_IS_A_MIRROR_VOLUME);
                }
                if (!isNotDstOfMirrorSync) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_MIRROR_SYNC_VALIDATION_SOURCE_IS_DST_OF_MIRROR_SYNC);
                }
                if (isCopySrc) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_MIRROR_SYNC_VALIDATION_VOLUME_IS_SRC_OF_COPY_OPER);
                }
                if (treeNode.isNonFunctional()) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_VALIDATION_VOLUME_IS_NON_FUNCTIONAL);
                }
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_MIRROR_SYNC_VALIDATION_SOURCE_IS_NOT_A_MIRROR);
            }
        }
        if (!CopyOperManager.getInstance().isInvolvedInMirrorSync(node) && action == this.showMirrorSyncAction) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_TREE_SHOW_MIRROR_SYNC_VALIDATION_SOURCE_IS_A_TARGET_OR_DST_OF_MIRROR_SYNC);
        }
        return null;
    }

    private void openPropertiesDialog(SrTreeNode node, int location) {
        JFrame frame = new JFrame();
        frame.setIconImage(ClientImageObject.APP_ICON.getImageIcon().getImage());
        if (node instanceof SubDirectAccessDeviceNode) {
            SubdiskPropertiesDialog props = new SubdiskPropertiesDialog(frame, (SubDirectAccessDeviceNode)node);
            ((SubDirectAccessDeviceNode)node).setUserObject(props);
            props.show();
        } else if (node instanceof DirectAccessDeviceNode) {
            DirectAccessDevicePropertiesDialog props = new DirectAccessDevicePropertiesDialog(frame, (DirectAccessDeviceNode)node);
            ((DirectAccessDeviceNode)node).setUserObject(props);
            int x = (int)props.getLocation().getX();
            int y = (int)props.getLocation().getY();
            props.setLocation(x + location * 4, y + location * 4);
            props.show();
        } else if (node instanceof StorageDeviceNode) {
            DirectAccessDevicePropertiesDialog props = new DirectAccessDevicePropertiesDialog(frame, (StorageDeviceNode)node);
            ((StorageDeviceNode)node).setUserObject(props);
            int x = (int)props.getLocation().getX();
            int y = (int)props.getLocation().getY();
            props.setLocation(x + location * 4, y + location * 4);
            props.show();
        } else if (node instanceof VolumeNode) {
            VolumePropertiesDialog prop = null;
            prop = node instanceof SnapshotVolumeNode ? new SnapshotVolumePropertiesDialog((Window)frame, (VolumeNode)node) : (node instanceof StripeVolumeNode ? new StripeVolumePropertiesDialog(frame, (VolumeNode)node) : (node instanceof JournalVolumeNode ? new JournalVolumePropertiesDialog(frame, (JournalVolumeNode)node) : new VolumePropertiesDialog((Window)frame, (VolumeNode)node)));
            ((VolumeNode)node).setUserObject(prop);
            int x = (int)prop.getLocation().getX();
            int y = (int)prop.getLocation().getY();
            prop.setLocation(x + location * 4, y + location * 4);
            prop.show();
        }
    }

    public void setModel(TreeModel model) {
        this.getTreeObject().getModel().removeTreeModelListener(this);
        this.getTreeObject().setModel(model);
        this.getTreeObject().getModel().addTreeModelListener(this);
        this.expandTree();
    }

    protected void createTree() {
        VolumeTreeCellRenderer volumeTreeCellRenderer = this.initTreeRenderer();
        this.volumeTreeCellEditor = new VolumeTreeCellEditor(this.getTreeObject(), volumeTreeCellRenderer);
        this.getTreeObject().setCellEditor(this.volumeTreeCellEditor);
        this.getTreeObject().setEditable(true);
    }

    protected VolumeTreeCellRenderer initTreeRenderer() {
        VolumeTreeCellRenderer volumeTreeCellRenderer = new VolumeTreeCellRenderer();
        this.getTreeObject().setCellRenderer(volumeTreeCellRenderer);
        return volumeTreeCellRenderer;
    }

    protected void selectNode(SrTreeNode selected) {
        VolumeTreeNode node = (VolumeTreeNode)selected;
        Object[] nodesInPath = this.getTreeModel().getPathToRoot(node);
        TreePath tp = new TreePath(nodesInPath);
        if (tp != null) {
            this.getTreeObject().setSelectionPath(tp);
            this.getTreeObject().scrollPathToVisible(tp);
        }
    }

    public void clearSelection() {
        this.getTreeObject().getSelectionModel().clearSelection();
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.expandIfFirstChild(e.getTreePath());
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }

    protected void expandIfFirstChild(TreePath treePath) {
        this.getTreeObject().collapsePath(treePath);
        this.getTreeObject().expandPath(treePath);
    }

    public void startEditingAtPath(TreePath path) {
        if (path != null) {
            this.getTreeObject().startEditingAtPath(path);
        }
    }

    public abstract DeleteAction getDeleteAction();

    class VolumeSelectionAdapter
    extends AlarmSourceSelectionAdapter {
        VolumeSelectionAdapter() {
        }

        @Override
        public void volumeSelected(AlarmSourceSelectionEvent e) {
            SrTreeNode selected = e.getNode();
            SrVolumeTreePanel.this.selectNode(selected);
        }
    }

    class VolumeTreeCellEditor
    extends DefaultTreeCellEditor {
        public VolumeTreeCellEditor(JTree tree, DefaultTreeCellRenderer rend) {
            super(tree, rend);
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            String strValue = value.toString();
            int ind = strValue.indexOf("[");
            if (ind != -1) {
                strValue = strValue.substring(0, ind);
                strValue = strValue.trim();
            }
            ((VolumeTreeCellRenderer)this.renderer).getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
            return super.getTreeCellEditorComponent(tree, strValue, isSelected, expanded, leaf, row);
        }
    }
}

