/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrSwingUtils;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;

public class SrTreeCellRenderer
extends DefaultTreeCellRenderer {
    protected static Border theCellInsetsBorder = BorderFactory.createEmptyBorder(2, 1, 1, 2);

    public SrTreeCellRenderer() {
        this.setBackgroundNonSelectionColor(LookAndFill.TREE_BACKGROUND_COLOR);
        this.setBackgroundSelectionColor(LookAndFill.TREE_SELECTION_BACKGROUND_COLOR);
        this.setTextSelectionColor(LookAndFill.TREE_SELECTION_FOREGROUND_COLOR);
        this.setBorder(theCellInsetsBorder);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel superResult = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof SrTreeNode) {
            this.addGraphicalIndication((SrTreeNode)value);
        }
        return superResult;
    }

    public void addGraphicalIndication(SrTreeNode node) {
        String graphicalIndicationString = node.getGraphicalIndicationString();
        this.setText(this.getText() + graphicalIndicationString);
    }

    protected ImageIcon getIcon(ImageIcon alarmIcon, ImageIcon nodeIcon) {
        return SrSwingUtils.horizontallyJoinTwoIcons(alarmIcon, nodeIcon, 3);
    }
}

